/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.config;

import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.superx.common.DBServletException;
import de.superx.common.Field;
import de.superx.common.FieldContainer;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.Maske;
import de.superx.common.SichtException;
import de.superx.common.SxUser;
import de.superx.common.UngueltigeEingabeException;
import de.superx.rest.config.HisDynamicFieldConfigurator;
import de.superx.rest.config.ValueFormatTool;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.HisDynamicFieldConfig;
import de.superx.rest.model.Item;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class HisDynamicSelectConfigurator
extends HisDynamicFieldConfigurator {
    public HisDynamicSelectConfigurator(Maske maske, Field field, SxUser user) {
        this.maske = maske;
        this.field = field;
        this.user = user;
    }

    @Override
    public HisDynamicFieldConfig createConfig(String currentSelection) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
        FieldContainer maskenFelder = this.maske.getIndividualFields();
        this.field.setInited(false);
        Hashtable formular = this.maske.getFormularCopy();
        HashMap map = new HashMap();
        map.put("UserIsAdmin", this.user.getBasicMap().get("UserIsAdmin"));
        this.field.updateDefaultValue(formular, map, maskenFelder, null, false, this.user);
        this.config = HisDynamicSelectConfigurator.createSelectUpdate(this.field, currentSelection);
        return this.config;
    }

    @Override
    public String escapeForFormular(String inputValue) throws UngueltigeEingabeException {
        String escapedValue = inputValue;
        if (escapedValue == null) {
            escapedValue = this.field.getDefaultValueKey();
        }
        if (escapedValue.contains(";")) {
            throw new UngueltigeEingabeException("Eingabe enth\u00e4lt ung\u00fcltige Zeichen");
        }
        return HisDynamicSelectConfigurator.addQuotes(escapedValue);
    }

    @Override
    public String getUpdatedFormularValue() {
        String value = this.config.defaultValue.toString();
        value = ValueFormatTool.addQuotes(value);
        return value;
    }

    public static boolean checkIfValueIsValid(List<Item> validItems, String inputValue) {
        List<String> validValues = HisDynamicSelectConfigurator.extractValues(validItems);
        boolean isValid = validValues.contains(inputValue);
        return isValid;
    }

    private static HisDynamicFieldConfig createSelectUpdate(Field field, String selectedValue) {
        HisDynamicFieldConfig formField = new HisDynamicFieldConfig(field, FieldType.Select);
        List<Item> items = HisDynamicSelectConfigurator.createSelectableItems(field);
        formField.setItems(items);
        String defaultValue = field.getDefaultValueKey();
        if (!field.isHidden() && HisDynamicSelectConfigurator.checkIfValueIsValid(items, selectedValue)) {
            defaultValue = selectedValue;
        } else if (!(defaultValue.isEmpty() || HisDynamicSelectConfigurator.checkIfValueIsValid(items, defaultValue) || items.isEmpty())) {
            defaultValue = items.get((int)(items.size() - 1)).value;
        }
        formField.defaultValue = defaultValue;
        return formField;
    }
}

