/*
 * Decompiled with CFR 0.152.
 */
package de.superx.etl;

import de.memtext.util.MemoryUtils;
import de.memtext.util.StringUtils;
import de.superx.bin.SxConnection;
import de.superx.bin.SxDBUtils;
import de.superx.bin.SxJdbcClient;
import java.io.BufferedOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

public class QueryResultSerializer {
    public final String NEWLINE = System.getProperty("line.separator");
    private String outfile;
    private SxConnection mySxConnection;
    private String query;
    private String CSVdelim;
    private Boolean printColNames;
    private String outFormat;
    private Logger logger;
    private String mandantenId = "default";
    private Statement st;
    private Connection myConnection;
    private String[] colnames;
    private int[] coltypes;
    private int columnCount;
    private StringBuffer outString = new StringBuffer("");
    private String outputHeader = "";
    private String outputFooter = "";
    private BufferedOutputStream outputStream;
    public StringWriter outputString;
    public FileWriter outputFile;
    private int returnCode;
    private ResultSet myrs;

    public QueryResultSerializer(String mandantenId, SxConnection mySxConnection, String query, StringWriter sw) {
        this.mySxConnection = mySxConnection;
        this.query = this.prepareQuery(query);
        this.mandantenId = mandantenId;
        this.logger = Logger.getLogger("superx_" + mandantenId);
        this.outputString = sw;
    }

    public QueryResultSerializer(String mandantenId, SxConnection mySxConnection, String query, FileWriter fw) {
        this.mySxConnection = mySxConnection;
        this.query = this.prepareQuery(query);
        this.mandantenId = mandantenId;
        this.logger = Logger.getLogger("superx_" + mandantenId);
        this.outputFile = fw;
    }

    public QueryResultSerializer(String mandantenId, SxConnection mySxConnection, ResultSet rs, FileWriter fw) {
        this.mySxConnection = mySxConnection;
        this.myrs = rs;
        this.mandantenId = mandantenId;
        this.logger = Logger.getLogger("superx_" + mandantenId);
        this.outputFile = fw;
    }

    public QueryResultSerializer(String mandantenId, SxConnection mySxConnection, ResultSet rs, StringWriter sw) {
        this.mySxConnection = mySxConnection;
        this.myrs = rs;
        this.mandantenId = mandantenId;
        this.logger = Logger.getLogger("superx_" + mandantenId);
        this.outputString = sw;
    }

    public QueryResultSerializer(String mandantenId, Connection myConnection, String query, FileWriter fw) {
        this.myConnection = myConnection;
        this.query = this.prepareQuery(query);
        this.mandantenId = mandantenId;
        this.logger = Logger.getLogger("superx_" + mandantenId);
        this.outputFile = fw;
    }

    public String getOutfile() {
        return this.outfile;
    }

    public void setOutfile(String outfile) {
        this.outfile = outfile;
    }

    public SxConnection getMySxConnection() {
        return this.mySxConnection;
    }

    public void setMyConnection(SxConnection mySxConnection) {
        this.mySxConnection = mySxConnection;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getOutFormat() {
        return this.outFormat;
    }

    public void setOutFormat(String outFormat) {
        this.outFormat = outFormat;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getMandantenId() {
        return this.mandantenId;
    }

    public void setMandantenId(String mandantenId) {
        this.mandantenId = mandantenId;
    }

    public String[] getColnames() {
        return this.colnames;
    }

    public void setColnames(String[] colnames) {
        this.colnames = colnames;
    }

    public int[] getColtypes() {
        return this.coltypes;
    }

    public void setColtypes(int[] coltypes) {
        this.coltypes = coltypes;
    }

    public StringWriter getOutputString() {
        return this.outputString;
    }

    public void setOutputString(StringWriter output) {
        this.outputString = output;
    }

    public FileWriter getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(FileWriter outputFile) {
        this.outputFile = outputFile;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    protected ResultSet getMyrs() {
        return this.myrs;
    }

    protected void setMyrs(ResultSet myrs) {
        this.myrs = myrs;
    }

    public long unloadQueryResults(String uniquename, String outformat, String delim, boolean printColname) throws Exception {
        this.returnCode = 0;
        long numberOfRows = 0L;
        Object zs = "";
        if (this.myrs == null) {
            Object rs = null;
            SxJdbcClient myClient = new SxJdbcClient(this.logger, this.myConnection, this.query);
            myClient.Rs_executeALL();
            this.logger.info("Getting resultset");
            this.myrs = myClient.getRs();
        }
        if (this.myrs != null) {
            ResultSetMetaData rsmd = this.myrs.getMetaData();
            this.setColnamesAndTypes(rsmd);
            if (outformat.equalsIgnoreCase("xml")) {
                zs = (String)zs + "<unload name=\"" + uniquename + "\"><query><![CDATA[" + this.query + "]]></query><rs>";
                if (printColname) {
                    zs = (String)zs + this.getColnamesXML();
                }
            } else if (printColname) {
                zs = (String)zs + this.getColnamesCSV(delim) + "\n";
            }
            try {
                numberOfRows = this.printResult(outformat, (String)zs, this.myrs, delim);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.returnCode = 1;
            }
        }
        return numberOfRows;
    }

    private long printResult(String outformat, String header, ResultSet outrs, String delim) throws SQLException, IOException {
        StringBuffer line = new StringBuffer();
        int[] types = this.getColtypes();
        String[] lbl = this.getColnames();
        String f_wert = null;
        Object o = null;
        int rowCounterBeforeFlush = 0;
        long rowCounter = 0L;
        FileWriter fw = null;
        StringWriter sw = null;
        String rowDelim1 = outformat.equalsIgnoreCase("xml") ? "<row>" : "";
        String rowDelim2 = outformat.equalsIgnoreCase("xml") ? "</row>" + this.NEWLINE : "\n";
        String footer = outformat.equalsIgnoreCase("xml") ? "</rs></unload>" : "";
        boolean writeFileOutput = this.outputFile != null;
        int colNumber = this.getColumnCount();
        if (writeFileOutput) {
            fw = this.getOutputFile();
            fw.write(header);
        } else {
            sw = this.getOutputString();
            sw.write(header);
        }
        while (outrs.next()) {
            line.setLength(0);
            line.append(rowDelim1);
            for (int i = 1; i <= colNumber; ++i) {
                o = types[i - 1] == -1 ? outrs.getString(i) : outrs.getObject(i);
                f_wert = SxDBUtils.field_value(o);
                f_wert = this.prepareFieldValue(outformat, lbl[i - 1], f_wert, delim);
                if (i < colNumber) {
                    line.append(f_wert);
                    continue;
                }
                line.append(f_wert);
                line.append(rowDelim2);
            }
            if (writeFileOutput) {
                fw.write(line.toString());
                if (++rowCounterBeforeFlush > 10000) {
                    MemoryUtils.printfree();
                    fw.flush();
                    rowCounterBeforeFlush = 0;
                }
            } else {
                sw.write(line.toString());
            }
            ++rowCounter;
        }
        outrs.close();
        if (writeFileOutput) {
            if (outformat.equalsIgnoreCase("xml")) {
                fw.write(footer);
            }
            fw.flush();
            fw.close();
        } else {
            if (outformat.equalsIgnoreCase("xml")) {
                sw.write(footer);
            }
            sw.close();
            this.setOutputString(sw);
        }
        return rowCounter;
    }

    private void setColnamesAndTypes(ResultSetMetaData rsmd) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] types = new int[cols];
        String[] lbl = new String[cols];
        for (int i = 0; i < cols; ++i) {
            lbl[i] = rsmd.getColumnLabel(i + 1);
            types[i] = rsmd.getColumnType(i + 1);
        }
        this.setColnames(lbl);
        this.setColtypes(types);
        this.setColumnCount(cols);
    }

    private String getColnamesCSV(String delim) {
        Object headZs = "";
        int colNumber = this.getColnames().length;
        for (int i = 0; i < colNumber; ++i) {
            headZs = (String)headZs + this.getColnames()[i] + delim;
        }
        return headZs;
    }

    private String getColnamesXML() {
        Object headZs = "<rsmd>";
        int colNumber = this.getColnames().length;
        for (int i = 0; i < colNumber; ++i) {
            headZs = (String)headZs + "<fld name=\"" + this.getColnames()[i] + "\" type=\"" + SxDBUtils.getSqlTypeName(this.getColtypes()[i]) + "\" />" + this.NEWLINE;
        }
        headZs = (String)headZs + "</rsmd>";
        return headZs;
    }

    private String prepareQuery(String query) {
        if ((query = query.trim()).length() > 0) {
            if (query.startsWith("\"")) {
                query = query.substring(1, query.length());
            }
            if (query.endsWith("\"")) {
                query = query.substring(0, query.length() - 1);
            }
        }
        return query;
    }

    private String prepareFieldValue(String outformat, String fieldName, String f_wert, String delim) {
        Object fieldValue = "";
        if (outformat.equals("xml")) {
            fieldValue = (String)fieldValue + "<fld name=\"" + fieldName + "\">";
            fieldValue = (f_wert = this.encodeCDATA(f_wert)).indexOf("&") > -1 || f_wert.indexOf("<") > -1 || f_wert.indexOf(">") > -1 ? (String)fieldValue + "<![CDATA[" + f_wert + "]]>" : (String)fieldValue + f_wert;
            fieldValue = (String)fieldValue + "</fld>" + this.NEWLINE;
        }
        if (outformat.equals("txt")) {
            fieldValue = SxDBUtils.prepareInformixCsv(f_wert);
            if (fieldValue != null && ((String)fieldValue).indexOf(delim) > -1) {
                fieldValue = StringUtils.replace((String)fieldValue, delim, "\\" + delim);
            }
            fieldValue = (String)fieldValue + delim;
        }
        return fieldValue;
    }

    private String encodeCDATA(String x) {
        if (x == null) {
            x = "";
        }
        x = StringUtils.replace(x, "<![CDATA[", "CDATASTART");
        x = StringUtils.replace(x, "]]>", "CDATAEND");
        return x;
    }
}

