/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.superx.util.SqlStringUtils;
import java.io.Serializable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XilParser
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static Logger logger = LoggerFactory.getLogger(XilParser.class);
    protected String xilString;
    private static final Pattern FIXED_COLUMN_PATTERN = Pattern.compile("fixed_columns *= *\\d", 2);

    public XilParser(String xilString) {
        this.xilString = xilString;
    }

    public XilParser() {
    }

    public void setXilString(String xilString) {
        this.xilString = xilString;
    }

    public int getFixedColumnCount() {
        int fixedColumns = 0;
        Matcher matcher = FIXED_COLUMN_PATTERN.matcher(this.xilString);
        if (matcher.find()) {
            String fc = matcher.group().replaceAll(" ", "").replaceAll("fixed_columns=", "");
            try {
                fixedColumns = Integer.parseInt(fc);
            }
            catch (NumberFormatException e) {
                logger.error("Couldn't parse fixed_columns String: " + fc, (Throwable)e);
            }
            if (this.xilString.toLowerCase().indexOf("\"ebene\"") > -1 && fixedColumns < 2) {
                fixedColumns = 2;
            }
        }
        return fixedColumns;
    }

    public boolean hasAggregationHeaders() {
        return this.xilString.indexOf("\u0000") > -1 || this.xilString.indexOf("\\000") > -1;
    }

    public String getHiddenAggregationColumns() {
        String result = null;
        String x = "hiddenaggregationcolumns=\"";
        int pos1 = this.xilString.toLowerCase().indexOf(x);
        if (pos1 > -1) {
            int pos2 = this.xilString.substring(pos1 + x.length()).indexOf(34);
            if (pos2 < 2) {
                throw new IllegalStateException("Endemarkierung von Attribut startcolset nicht gefunden");
            }
            result = this.xilString.substring(pos1 + x.length(), pos1 + x.length() + pos2);
        }
        return result;
    }

    public String getStartColSet() {
        String result = null;
        String x = "startcolset=\"";
        int pos1 = this.xilString.toLowerCase().indexOf(x);
        if (pos1 > -1) {
            int pos2 = this.xilString.substring(pos1 + x.length()).indexOf(34);
            if (pos2 < 2) {
                throw new IllegalStateException("Endemarkierung von Attribut startcolset nicht gefunden");
            }
            result = this.xilString.substring(pos1 + x.length(), pos1 + x.length() + pos2);
        }
        return result;
    }

    public Vector getHeaderVector() {
        return SqlStringUtils.getHeader(this.xilString);
    }

    public Vector getWidths() {
        Vector<String> widths = new Vector<String>();
        int pos = 0;
        int end_pos = 0;
        int offset = 0;
        int len = this.xilString.length();
        String search_str = "width=";
        String width_str = null;
        int search_len = search_str.length();
        while (offset < len && (pos = this.xilString.indexOf(search_str, offset)) != -1 && (end_pos = this.xilString.indexOf("\n", pos + search_len)) != -1) {
            width_str = this.xilString.substring(pos + search_len, end_pos);
            int pos_leer = 0;
            pos_leer = width_str.indexOf(" ");
            if (pos_leer != -1) {
                width_str = width_str.substring(0, pos_leer);
            }
            widths.addElement(width_str.trim());
            offset = pos + search_len + width_str.length() + 1;
        }
        return widths;
    }
}

