/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.baseobjects.coll.NamedIdObjectList;
import de.memtext.util.GetOpts;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.memtext.util.TimeUtils;
import de.memtext.util.TransletUtils;
import de.superx.bin.SxTransformer;
import de.superx.common.Maske;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxUser;
import de.superx.sec.InputCheckRegistry;
import de.superx.servlet.JasperCreator;
import de.superx.servlet.RequestParameter;
import de.superx.servlet.ServletBasics;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.StatisticExporter;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.servlet.UserInitializer;
import de.superx.servlet.XmlTransformer;
import de.superx.spring.cli.config.CLIConfig;
import de.superx.spring.config.BatchConfig;
import de.superx.spring.config.DataJdbcConfiguration;
import de.superx.spring.config.ServiceConfig;
import de.superx.util.PathAndFileUtils;
import de.superx.util.SqlStringUtils;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Level;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletConfig;

public class ExecuteMask {
    private static GenericApplicationContext APPLICATION_CONTEXT = null;
    private static String mandantenID = "default";
    private static TimeUtils tutil = new TimeUtils();
    private static String myLocale;
    private static String myParams;
    private static Object adminUser;
    private static Integer userid;
    private static String myWEBINFFilePath;
    private static Logger log;
    private static String usage;
    static MockHttpServletRequest mock;
    static MockHttpServletResponse mockResponse;
    static MockServletConfig mockServletConfig;
    static SxUser user;
    private static File fopxconfFile;

    public static void main(String[] args) {
        try {
            GenericApplicationContext context = ExecuteMask.createContext();
            SxPools.closeAll();
            SxPools.init();
            SxPools.get(mandantenID).init();
            SxPools.get(mandantenID).initLogging(true, Level.DEBUG);
            ExecuteMask.execute(args);
        }
        catch (Exception e) {
            System.err.println("Could not init SxPools!");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    public static void execute(String[] args) throws Exception {
        mock = new MockHttpServletRequest();
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_logger, GetOpts.Options.opt_tid, GetOpts.Options.opt_out, GetOpts.Options.opt_user});
        if (isdrin != null) {
            System.err.println(usage);
            return;
        }
        String userName = GetOpts.getValue(GetOpts.Options.opt_user);
        String loggingProperties = GetOpts.getValue(GetOpts.Options.opt_logger);
        try {
            myWEBINFFilePath = PathAndFileUtils.getWebinfDirectory();
        }
        catch (URISyntaxException e1) {
            myWEBINFFilePath = ExecuteMask.getMyWEBINFFilePath();
        }
        fopxconfFile = GetOpts.isPresent(GetOpts.Options.opt_fopxconf) ? new File(GetOpts.getOpt(GetOpts.Options.opt_fopxconf).replaceAll(GetOpts.Options.opt_fopxconf.stringValue() + ":", "")) : new File(myWEBINFFilePath + File.separator + "conf" + File.separator + "fop.xconf");
        LinkedList<String> mandantenNamen = new LinkedList<String>();
        if (GetOpts.isPresent(GetOpts.Options.opt_mandID)) {
            String mid = GetOpts.getValue(GetOpts.Options.opt_mandID);
            System.out.println("Opt -mandantenID present: " + mid);
            mandantenID = mid;
        } else if (mandantenID == null) {
            System.out.println("No opt -mandantenID present. Set to " + SxSQL_Server.DEFAULT_MANDANTEN_ID);
            mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;
        } else {
            System.out.println("No opt -mandantenID present. mandantenID was already set to " + mandantenID);
        }
        mandantenNamen.add(mandantenID);
        try (FileInputStream ins = new FileInputStream(loggingProperties);){
            LogManager MyLogManager = LogManager.getLogManager();
            MyLogManager.readConfiguration(ins);
            log = Logger.getLogger(ExecuteMask.class.getName());
            log.addHandler(new ConsoleHandler());
            System.out.println("Using Loggging-Level " + String.valueOf(log.getLevel()));
        }
        catch (FileNotFoundException e2) {
            System.err.println("Datei " + loggingProperties + " nicht gefunden:" + e2.toString());
            return;
        }
        catch (IOException e) {
            System.err.println("Datei " + loggingProperties + " kann nicht gelesen werden:" + e.toString());
            return;
        }
        tutil.start();
        try {
            SuperXManager.initKettleEnv((ApplicationContext)APPLICATION_CONTEXT);
            userid = ExecuteMask.getUserID(userName, mandantenID);
            adminUser = ExecuteMask.getUserAdmin(userName, mandantenID);
            UserInitializer ui = new UserInitializer(mandantenID, userName, userid, adminUser);
            Connection con = SxPools.get(mandantenID).getConnection();
            ui.initUser(con, null);
            user = ui.getUser();
            user.setMandantenID(mandantenID);
            con.close();
        }
        catch (Exception e) {
            log.severe("Fehler beim Aufbau der Connection: " + e.toString());
            e.printStackTrace();
            return;
        }
        String tidString = GetOpts.getValue(GetOpts.Options.opt_tid);
        String outfile = GetOpts.getValue(GetOpts.Options.opt_out);
        myLocale = GetOpts.isPresent(GetOpts.Options.opt_locale) ? GetOpts.getValue(GetOpts.Options.opt_locale) : SqlStringUtils.getEncoding();
        if (GetOpts.isPresent(GetOpts.Options.opt_params)) {
            myParams = GetOpts.getValue(GetOpts.Options.opt_params);
        }
        Locale desiredLocale = new Locale(myLocale);
        SuperXManager.maxRows = 1000000;
        Maske maske = null;
        InputCheckRegistry.registerDefaultChecks();
        try {
            maske = new Maske(mandantenID, user, Integer.valueOf(tidString), desiredLocale);
            NamedIdObjectList fields = maske.readFelderFromDb(user);
            ExecuteMask.setParams(mock, myParams);
            maske.setFieldDefaults(user, (HttpServletRequest)mock, true);
            ExecuteMask.exportTable((HttpServletRequest)mock, (HttpServletResponse)mockResponse, maske, user, outfile, desiredLocale);
            System.out.println("Datei " + outfile + " f\u00fcr Maske " + tidString + " erzeugt in " + tutil.getSinceStart());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe("Fehler beim Ausf\u00fchren der Maske " + tidString + ": " + e.toString());
            throw e;
        }
    }

    public static HttpServletResponse getHttpResponse() {
        return mockResponse;
    }

    private static Integer getUserID(String userName, String mandantenID_par) {
        String query = "select tid from userinfo where benutzer='" + userName + "';";
        Integer userID = null;
        SxResultSet rs = null;
        try {
            rs = ServletUtils.execute("Ermittle ID f\u00fcr  " + userName, query, mandantenID_par);
        }
        catch (Exception e) {
            log.severe("Fehler beim Ermitteln der ID f\u00fcr " + userName + ": " + e.toString());
        }
        for (SxResultRow row : rs) {
            userID = (Integer)row.get(0);
        }
        if (userID == null) {
            System.err.println("User " + userName + "unbekannt");
            return -1;
        }
        return userID;
    }

    private static String getUserAdmin(String userName, String mandantenID_par) {
        String query = "select administration from userinfo where benutzer='" + userName + "';";
        String admin = null;
        SxResultSet rs = null;
        try {
            rs = ServletUtils.execute("Ermittle Admin-Flag f\u00fcr  " + userName, query, mandantenID_par);
        }
        catch (Exception e) {
            log.severe("Fehler beim Ermitteln der Admin-Rechte f\u00fcr " + userName + ": " + e.toString());
        }
        if (rs == null) {
            return admin;
        }
        for (SxResultRow row : rs) {
            admin = row.get(0).toString();
        }
        return admin;
    }

    private static void setParams(MockHttpServletRequest mock, String paramsString) {
        StringTokenizer st = new StringTokenizer(paramsString, "&");
        while (st.hasMoreTokens()) {
            String paramString = st.nextToken();
            String paramName = paramString.substring(0, paramString.indexOf("="));
            String paramVal = paramString.substring(paramString.indexOf("=") + 1);
            mock.addParameter(paramName, paramVal);
        }
    }

    private static void exportTable(HttpServletRequest mock_par, HttpServletResponse mockResponse_par, Maske maske, SxUser user_par, String outfile, Locale desiredLocale) {
        String currentXml_local = null;
        String method = "html";
        String stylesheet = ServletHelper.getParameter(mock_par, RequestParameter.stylesheet);
        if (stylesheet == null || stylesheet.equals("")) {
            stylesheet = "tabelle_html_p.xsl";
        }
        log.info("Stylesheet " + stylesheet + " wird genutzt");
        String contenttype = ServletHelper.getParameter(mock_par, RequestParameter.contenttype);
        if (contenttype == null || contenttype.equals("")) {
            contenttype = "text/html";
        }
        if (contenttype.indexOf("pdf") > -1) {
            method = "pdf";
        }
        if (contenttype.indexOf("xml") > -1) {
            method = "xml";
        }
        if (contenttype.indexOf("spreadsheetml") > -1) {
            method = "xls";
        }
        log.info("Contenttype " + contenttype + " wird erzeugt");
        maske.setMaxOffset(10000000);
        maske.setReuseResult(false);
        maske.resetTableStylesheet();
        maske.setSelectedTableStylesheetFileAndContenttype(stylesheet);
        maske.setDesiredContenttype(contenttype);
        log.info("Start Maskengenerierung");
        try {
            String statistikExport = ServletBasics.getParamChecked(mock_par, maske, RequestParameter.Statistikexport.toString());
            if (!statistikExport.isEmpty()) {
                String ausgabeFormat = ServletHelper.getParameter(mock_par, RequestParameter.Exportformat);
                if (ausgabeFormat == null) {
                    ausgabeFormat = "text/html";
                }
                log.info("Amtliche Statistik. Ausgabeformat = " + ausgabeFormat);
                StatisticExporter statisticExporter = new StatisticExporter(mock_par, mockResponse_par, maske);
                if (statisticExporter.xmlStatisticExport(ausgabeFormat)) {
                    return;
                }
            }
            currentXml_local = maske.runQuery(user_par, mock_par, null).toString();
            System.out.println("Ausgabe Maskenprotokoll\n" + SuperXManager.activityLog.toString());
            log.info("Maskenergebnis wird lokalisiert");
            currentXml_local = SxPools.get(mandantenID).localize(currentXml_local, desiredLocale);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe("Fehler beim Erstellen des XML f\u00fcr Maske " + e.toString());
        }
        String ausgabedatei = "";
        if (stylesheet.equals("tabelle_xml.xsl")) {
            ausgabedatei = ExecuteMask.writeTextFile(currentXml_local, outfile);
        } else if (contenttype.equals("text/csv")) {
            try {
                ausgabedatei = ExecuteMask.writeTextFile(maske.getCSV(mandantenID).toString(), outfile);
            }
            catch (IOException e) {
                System.out.println("Fehler beim Erstellen der datei " + outfile);
                e.printStackTrace();
            }
        } else {
            ausgabedatei = ExecuteMask.writeTextFile(currentXml_local, outfile + ".xml");
            if (stylesheet.endsWith(".jrxml")) {
                ExecuteMask.exportJR(mock_par, mockResponse_par, maske, user_par, outfile, stylesheet, contenttype, mandantenID, myWEBINFFilePath + "/reports/", currentXml_local);
            } else {
                ExecuteMask.transformFile(maske, ausgabedatei, stylesheet, contenttype, outfile, mockResponse_par, method);
            }
        }
        log.info("Datei " + ausgabedatei + " erzeugt");
    }

    private static void exportJR(HttpServletRequest mock_par, HttpServletResponse mockResponse_par, Maske maske, SxUser user_par, String outfile, String stylesheet, String contentType, String mandantenID_par, String reports_dir, String currentXml_par) {
        block5: {
            if ((currentXml_par.indexOf("Insgesamt 0 S\u00e4tze gefunden") < 1 || currentXml_par.indexOf("ergebnis ordnr=\"1\"") > -1) && currentXml_par.indexOf("Zeilen liegen \u00fcber max. Grenze") < 1) {
                try {
                    JasperCreator jc = new JasperCreator(mock_par, mockResponse_par, user_par, maske, stylesheet, contentType, reports_dir);
                    if (maske.getSelectedTableStylesheetFilename().indexOf("_xmlsource") > -1) {
                        jc.perform(mandantenID_par, currentXml_par, outfile);
                        break block5;
                    }
                    jc.perform(mandantenID_par, maske, outfile);
                }
                catch (IOException | JRException e) {
                    log.severe("Fehler bei JasperReport-Erzeugung " + e.toString());
                }
            } else {
                log.info("Keine Daten f\u00fcr JR verf\u00fcgbar");
            }
        }
    }

    private static String writeTextFile(String content, String filename) {
        String targetfilename = "";
        try {
            File temp = File.createTempFile("tabelle", ".xml");
            FileWriter f1 = new FileWriter(temp);
            f1.write(content == null ? "" : content);
            f1.flush();
            f1.close();
            targetfilename = temp.getAbsolutePath();
            Path tmpPath = Paths.get(targetfilename, new String[0]);
            if (filename != null) {
                Path destPath = Paths.get(filename, new String[0]);
                Path resultPath = Files.move(tmpPath, destPath, StandardCopyOption.REPLACE_EXISTING);
                targetfilename = resultPath.toString();
            }
        }
        catch (IOException e) {
            log.severe("Fehler beim Erstellen der Datei " + filename + " " + e.toString());
        }
        return targetfilename;
    }

    private static void transformFile(Maske maske, String xmlfile, String stylesheet, String contenttype, String filename, HttpServletResponse mockResponse_par, String method) {
        TransletUtils.initFactory("net.sf.saxon.TransformerFactoryImpl", null);
        String stylesheetPath = myWEBINFFilePath + File.separator + ".." + File.separator + "xml" + File.separator + stylesheet;
        if (method.equals("xls")) {
            try {
                XmlTransformer xt = new XmlTransformer((ServletConfig)mockServletConfig, (HttpServletRequest)mock, mockResponse_par, null, null);
                xt.setMandantenID(mandantenID);
                xt.setMaske(maske);
                String xml = StringUtils.readFile(new File(xmlfile));
                if (contenttype.indexOf("spreadsheetml") > -1) {
                    if (maske.isNewExcelExport()) {
                        xml = XmlTransformer.stripXml(xml);
                    }
                    xt.createExcelStandalone(xml, stylesheetPath, filename);
                    log.info("Datei " + filename + " erzeugt");
                }
            }
            catch (Exception e) {
                log.severe("Fehler bei der Transformation:");
                e.printStackTrace();
            }
        } else {
            SxTransformer myTransformer = new SxTransformer(log);
            try {
                myTransformer.quellstring = xmlfile;
                myTransformer.stylesheet = stylesheetPath;
                myTransformer.outfile = filename;
                myTransformer.mandantenID = mandantenID;
                if (fopxconfFile != null) {
                    myTransformer.setFopxconfFile(fopxconfFile);
                }
                myTransformer.transformFile(method);
            }
            catch (Exception e) {
                log.severe("Fehler bei der Transformation:");
                e.printStackTrace();
            }
        }
    }

    public static String getMyWEBINFFilePath() {
        return myWEBINFFilePath;
    }

    public static void setMyWEBINFFilePath(String myWEBINFFilePath) {
        ExecuteMask.myWEBINFFilePath = myWEBINFFilePath;
    }

    public static String getMandantenID() {
        return mandantenID;
    }

    public static void setMandantenID(String mandantenID) {
        ExecuteMask.mandantenID = mandantenID;
    }

    public static GenericApplicationContext createContext() {
        if (APPLICATION_CONTEXT == null) {
            APPLICATION_CONTEXT = new AnnotationConfigApplicationContext(new Class[]{BatchConfig.class, DataJdbcConfiguration.class, CLIConfig.class, ServiceConfig.class});
        }
        return APPLICATION_CONTEXT;
    }

    static {
        myParams = "";
        myWEBINFFilePath = System.getProperty("user.dir");
        usage = " Kommandozeilen-Interface f\u00fcr Ausf\u00fchrung von Masken und Export des Ergebnis als Datei\n Parameter:\n  -logger:Pfad zu logging.properties, normalerweise $SUPERX_DIR/db/conf\n  -tid:Nummer der Maske\n  -out:Ausgabedatei\n  -user:Benutzerkennung, unter der Maske laufen soll\n  -locale:Locale (optional)\n  -params:Parameter f\u00fcr die Maske, jeweils mit \"&\" getrennt in einem String\n \n Sollte im Arbeitsverzeichnis webapps/superx/WEB-INF laufen\n \n Beispiele:\n HTML Druckversion (Default): \n java de.superx.bin.ExecuteMask -tid:16000 -out:test.htm -user:admin \"-params:K\u00f6pfe oder F\u00e4lle ?=1=1&Stichtag=1\" -logger:/home/superx/git/superx/superx/WEB-INF/conf/edustore/db/conf/logging.properties\n PDF Datei:\n java de.superx.bin.ExecuteMask -tid:16000 -out:test.pdf -user:admin \"-params:K\u00f6pfe oder F\u00e4lle ?=1=1&Stichtag=1&stylesheet=tabelle_fo_pdf.xsl&contenttype=application/pdf\" -logger:/home/superx/git/superx/superx/WEB-INF/conf/edustore/db/conf/logging.properties\n Excel-Datei\n java de.superx.bin.ExecuteMask -tid:16000 -out:test.xls -user:admin \"-params:K\u00f6pfe oder F\u00e4lle ?=1=1&Stichtag=1&stylesheet=tabelle_xls.xsl&contenttype=application/vnd.openxmlformats-officedocument.spreadsheetml.sheet\" -logger:/home/superx/git/superx/superx/WEB-INF/conf/edustore/db/conf/logging.properties\n CSV-Datei\n java de.superx.bin.ExecuteMask -tid:16000 -out:test.csv -user:admin \"-params:K\u00f6pfe oder F\u00e4lle ?=1=1&Stichtag=1&contenttype=text/csv\" -logger:/home/superx/git/superx/superx/WEB-INF/conf/edustore/db/conf/logging.properties\n -fopxconf (Pfad dazu - optional)";
        mockResponse = new MockHttpServletResponse();
        mockServletConfig = new MockServletConfig();
        fopxconfFile = null;
    }
}

