/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.GetOpts;
import de.superx.bin.SxDBUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class DelEndChar {
    private static String _dateiPfad = "";
    private static String DELIMITER = "^";
    private static String _outDateiPfad = "";
    private static String _tabelle = "";

    public static void main(String[] args) {
        DelEndChar r = new DelEndChar();
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_in});
        if (isdrin != null) {
            System.err.println("Datei-Pfade werden als Parameter erwartet. Folgende Optionen fehlen: " + isdrin);
            r.zeige_hilfe();
            System.exit(1);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_in)) {
            _dateiPfad = GetOpts.getValue(GetOpts.Options.opt_in);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_out)) {
            _outDateiPfad = GetOpts.getValue(GetOpts.Options.opt_out);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_delim)) {
            DELIMITER = GetOpts.getValue(GetOpts.Options.opt_delim);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_table)) {
            _tabelle = GetOpts.getValue(GetOpts.Options.opt_table);
        }
        if (args[0].toString().equals("?") || args[0].toString().equals("/?") || args[0].toString().equals("\\?") || args[0].toString().toLowerCase().equals("-h") || args[0].toString().toLowerCase().equals("--h")) {
            r.zeige_hilfe();
            System.exit(1);
        }
        try {
            r.updateFile(_dateiPfad, _outDateiPfad);
            System.out.println("Datei: " + _dateiPfad + " nach " + _outDateiPfad + " umgesetzt");
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    private void updateFile(String inDateiPfad, String outDateiPfad) throws IOException, Exception {
        File f = new File(inDateiPfad);
        if (!f.exists()) {
            throw new Exception("Datei nicht gefunden: " + inDateiPfad);
        }
        File out_tmp = new File(inDateiPfad + ".tmp2");
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(out_tmp)));
        Object text = in.readLine();
        if (text != null) {
            String tt;
            if (((String)text).endsWith("\\") && (tt = in.readLine()) != null) {
                text = (String)text + tt;
                while (tt.endsWith("\\")) {
                    tt = in.readLine();
                    if (tt == null) continue;
                    text = (String)text + tt + "\n";
                }
            }
            if (!_tabelle.equals("") && !_tabelle.equals("null")) {
                int numFelder = 0;
                try {
                    numFelder = SxDBUtils.fieldCount(_tabelle);
                }
                catch (Exception e) {
                    System.err.println("Fehler beim Abfragen der Tabellen-Metadaten: " + e.toString());
                }
                int k = 0;
                int i = 0;
                int p = 0;
                do {
                    if ((p = ((String)text).indexOf(DELIMITER, i)) <= 0) continue;
                    ++k;
                    i = p + 1;
                } while (p > 0);
                if (k != numFelder) {
                    throw new Exception("unl-Datei entspricht nicht der Tabelle in der Datenbank;\nDie Tabelle hat " + numFelder + " Felder, die unl-Datei hat " + k + " Felder ");
                }
            }
            while (text != null) {
                if (((String)text).endsWith("\\") && (tt = in.readLine()) != null) {
                    text = (String)text + tt;
                    while (tt != null && tt.endsWith("\\")) {
                        tt = in.readLine();
                        if (tt == null) continue;
                        text = (String)text + tt + "\n";
                    }
                }
                if ((text = this.reorgString(((String)text).trim())) == "-0") {
                    throw new Exception("Datei: " + inDateiPfad + " hat falsches Format: ");
                }
                out.write((String)text, 0, ((String)text).length());
                out.write("\n");
                out.flush();
                text = in.readLine();
                if (text != null) continue;
            }
        }
        in.close();
        out.close();
        File neuFile = new File(outDateiPfad);
        out_tmp.renameTo(neuFile);
        if (!this.chmode("u=rw,g=rw,o=rw", outDateiPfad)) {
            System.out.println("Kann Berechtigung nicht \u00e4ndern " + outDateiPfad);
        }
        in.close();
        out.close();
        out_tmp.delete();
    }

    private boolean chmode(String inBerechtigung, String inDat) {
        String befehl = "chmod " + inBerechtigung + " " + inDat;
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(befehl);
            int n = p.waitFor();
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
            return false;
        }
        return true;
    }

    private String reorgString(String inS) throws Exception {
        int ldPos = inS.lastIndexOf(DELIMITER);
        if (ldPos + 1 < inS.length() || ldPos == -1) {
            return inS;
        }
        return inS.substring(0, ldPos);
    }

    public boolean check_param_ok(String[] inTab) {
        if (inTab.length < 2) {
            System.out.println("Mindestens 2 Parameter erwartet! Mit -h oder ? rufen sie Hilfe auf.");
            return false;
        }
        _dateiPfad = inTab[0].trim();
        _outDateiPfad = inTab[1].trim();
        if (inTab.length >= 3) {
            DELIMITER = inTab[2].trim();
        }
        if (inTab.length > 3) {
            _tabelle = inTab[3].toString().trim();
        }
        return true;
    }

    private boolean check_Directory(File inFile) {
        if (inFile.exists()) {
            if (!inFile.isDirectory()) {
                System.out.println(String.valueOf(inFile) + " ist kein Verzeichnis!");
                return false;
            }
        } else {
            System.out.println(String.valueOf(inFile) + " Verzeichniss nicht gefunden!");
            return false;
        }
        return true;
    }

    private void progEnde() {
        System.runFinalization();
        System.exit(0);
    }

    private void zeige_hilfe() {
        System.out.println("\n Diese Klasse bereinigt die Zeilen der angegebenen ASCII-Dateien.");
        System.out.println(" Es wird der letzte Delimeter-Zeichen aus jeder Zeile entfernt.");
        System.out.println("\n Parameter: ");
        System.out.println("1. Eingabe-Dateiname mit Pfadangabe ");
        System.out.println("2. Ausgabe-Dateiname mit Pfadangabe");
        System.out.println("3. Delimiter-Zeichen(optional)");
        System.out.println("4. Tabellenname in der Datenbank, der auf \u00dcbereistimmung der Felderanzahl gepr\u00fcft werden soll (optional, wenn keine \u00dcberpr\u00fcfung, dann 'none').");
        System.out.println(" Defaultwert fuer Delimiter ist ^. \n");
    }
}

