/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.sqlgeneration;

import de.superx.bianalysis.ReportMetadata;
import de.superx.bianalysis.models.DimensionAttribute;
import de.superx.bianalysis.models.Filter;
import de.superx.bianalysis.models.Measure;
import de.superx.bianalysis.sqlgeneration.SQLGenerator;
import java.util.List;
import java.util.StringJoiner;

public class SQLGeneratorTotals {
    public static String buildTotalsColumnSQL(SQLGenerator generator, int maxBridgeLvlOfReport) {
        ReportMetadata metadata = generator.reportMetadata;
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT ");
        statement.append(SQLGeneratorTotals.buildSelectSectionForTotalsCol(generator, metadata, maxBridgeLvlOfReport));
        statement.append(generator.formatSql + "FROM presentation." + metadata.factTable.getTablename());
        statement.append(generator.buildJoinSection());
        statement.append(SQLGeneratorTotals.buildFilterSectionForTotalsCol(generator, metadata));
        statement.append(generator.buildGroupBySection());
        return statement.toString();
    }

    private static String buildFilterSectionForTotalsCol(SQLGenerator generator, ReportMetadata metadata) {
        if (metadata.topDimensionAttributes.size() == 0 && metadata.filters.size() == 0) {
            return "";
        }
        StringBuilder where = new StringBuilder(" WHERE ");
        StringJoiner groups = new StringJoiner(" AND ");
        for (DimensionAttribute attribute : metadata.topDimensionAttributes) {
            groups.add(attribute.getDimensionTableAlias() + "." + attribute.getColumnname() + " IN (" + SQLGeneratorTotals.getValues(attribute.getDimensionAttributeValues()) + ")");
        }
        for (Filter filter : generator.reportMetadata.filters) {
            groups.add(filter.dimensionTableAlias + "." + filter.columnname + " IN (" + filter.getValues() + ")");
        }
        where.append(groups);
        return where.toString();
    }

    private static String buildSelectSectionForTotalsCol(SQLGenerator generator, ReportMetadata metadata, int maxBridgeLvlOfReport) {
        StringJoiner columns = new StringJoiner(", ");
        columns.add(generator.selectDimensionAttributes());
        int numCols = generator.reportMetadata.maxBridgeLvl;
        for (Measure measure : metadata.measures) {
            Object value = generator.getMeasureTablePart(metadata.factTable.getTablename(), measure, metadata.leftDimensionAttributes);
            if (measure.filterCondition != null) {
                value = (String)value + " FILTER (WHERE " + measure.filterCondition + ")";
            }
            value = (String)value + " AS \"col" + numCols++ + "\"";
            columns.add((CharSequence)value);
        }
        String selectSection = columns.toString();
        return selectSection;
    }

    private static String getValues(List<String> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (String value : values) {
            joiner.add("'" + value + "'");
        }
        return joiner.toString();
    }

    public static String generateTotalsColumnSQL(ReportMetadata metadata) {
        return SQLGeneratorTotals.generateTotalsColumnSQL(metadata, null);
    }

    public static String generateTotalsColumnSQL(ReportMetadata metadata, String presentationSchema) {
        if (metadata.topDimensionAttributes.isEmpty()) {
            return "";
        }
        SQLGenerator generator = new SQLGenerator(metadata, null, presentationSchema);
        String finalSQL = SQLGeneratorTotals.buildTotalsColumnSQL(generator, metadata.maxBridgeLvl) + String.valueOf(generator.buildOrderBySection());
        return finalSQL;
    }
}

