/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.service;

import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.Right;
import de.superx.bianalysis.models.RightParam;
import de.superx.bianalysis.service.DbMetaAdapter;
import de.superx.common.AccessDeniedException;
import de.superx.common.SxUser;
import de.superx.spring.service.UserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BiAnalysisRightService {
    @Autowired
    DbMetaAdapter dbAdapter;
    @Autowired
    UserService userService;

    public void checkCreateRights() {
        SxUser user = (SxUser)this.userService.currentUserDetails();
        if (user != null && !user.getHis1Rights().contains("RIGHT_CS_BIA_ANALYSIS_CREATE_ANALYSIS")) {
            throw new AccessDeniedException("No right to access Create functions");
        }
    }

    public boolean isCreateRight() {
        SxUser user = (SxUser)this.userService.currentUserDetails();
        return user == null || user.getHis1Rights().contains("RIGHT_CS_BIA_ANALYSIS_CREATE_ANALYSIS");
    }

    public void checkCreateOrViewRights() {
        SxUser user = (SxUser)this.userService.currentUserDetails();
        if (user != null && !user.getHis1Rights().contains("RIGHT_CS_BIA_ANALYSIS_CREATE_ANALYSIS") && !user.getHis1Rights().contains("RIGHT_CS_BIA_ANALYSIS_VIEW_ANALYSIS_TABLE")) {
            throw new AccessDeniedException("No right to access Create and View functions");
        }
    }

    public void checkDeleteRights() {
        SxUser user = (SxUser)this.userService.currentUserDetails();
        if (user != null && !user.getHis1Rights().contains("RIGHT_CS_BIA_ANALYSIS_DELETE_ANALYSIS")) {
            throw new AccessDeniedException("No right to delete analysis");
        }
    }

    public List<Integer> getSachgebiete(Right ... rights) {
        List<String> values = this.getRightParamValues(RightParam.TOPIC_AREA, rights);
        List<String> valuesForTopics = this.dbAdapter.getSachgebieteForFactTables(this.getRightParamValues(RightParam.TOPIC, rights));
        values.addAll(valuesForTopics);
        if (values.isEmpty()) {
            return new ArrayList<Integer>();
        }
        List<Integer> sachgebietValues = values.stream().map(Integer::parseInt).collect(Collectors.toList());
        return sachgebietValues;
    }

    public List<Identifier> getFactTables(Right ... rights) {
        List<String> values = this.getRightParamValues(RightParam.TOPIC, rights);
        if (values.isEmpty()) {
            return new ArrayList<Identifier>();
        }
        List<Identifier> factsValues = values.stream().map(value -> new Identifier((String)value)).collect(Collectors.toList());
        return factsValues;
    }

    public void checkSachgebiet(int sachgebiet, Right ... rights) {
        List<Integer> sachgebiete = this.getSachgebiete(rights);
        if (sachgebiete.isEmpty()) {
            return;
        }
        if (!sachgebiete.contains(sachgebiet)) {
            throw new AccessDeniedException("No right to access Sachgebiet " + sachgebiet);
        }
    }

    public void checkFactTable(Identifier fact, Right ... rights) {
        List<Identifier> factTables = this.getFactTables(rights);
        if (factTables.isEmpty()) {
            return;
        }
        if (!factTables.contains(fact)) {
            throw new AccessDeniedException("No right to access Fact Table " + fact.composedId);
        }
    }

    public List<String> getRightParamValues(RightParam param, Right ... rights) {
        SxUser user = (SxUser)this.userService.currentUserDetails();
        if (user == null) {
            return new ArrayList<String>();
        }
        Map<String, Map<String, String>> rightsMap = user.getRightsMap();
        Map<String, String> rightParamMap = null;
        boolean noRights = true;
        for (Right right : rights) {
            if (!rightsMap.containsKey(right.getString())) continue;
            rightParamMap = rightsMap.get(right.getString());
            noRights = false;
            if (rightParamMap != null) break;
        }
        if (noRights) {
            throw new AccessDeniedException("Missing rights: " + Right.getPrintableRights(rights));
        }
        if (rightParamMap == null || rightParamMap.isEmpty()) {
            return new ArrayList<String>();
        }
        String paramValues = (String)rightParamMap.get(param.getString());
        if (paramValues != null) {
            ArrayList<String> paramValuesResult = new ArrayList<String>();
            for (String string : StringUtils.split((String)paramValues, (char)',')) {
                paramValuesResult.add(string);
            }
            return paramValuesResult;
        }
        return new ArrayList<String>();
    }
}

