/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.repository.dto;

import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.service.DbMetaAdapter;
import de.superx.jdbc.entity.EntityBase;
import de.superx.jdbc.model.DynamicFieldType;
import de.superx.jdbc.model.EntityDescriptor;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.Item;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.jdbc.core.JdbcTemplate;

@Table(schema="metadata", value="measure_filter")
public class MeasureFilterDto
extends EntityBase {
    @Id
    @DynamicFieldType(label="ID", readOnly=true, visibleInSimplifiedForm=false)
    public Identifier id;
    @EntityDescriptor
    @DynamicFieldType(label="Kennzahlenfilterbezeichnung")
    public String caption;
    @DynamicFieldType(label="Beschreibung", editControlType=FieldType.TextArea)
    public String description;
    @DynamicFieldType(label="Attribute", readOnly=false, visibleInSimplifiedForm=true)
    @Column(value="dimension_attribute_id")
    public Identifier dimensionAttributeId;
    @DynamicFieldType(label="Faktenspalte Filter", readOnly=true)
    @Column(value="fact_column_filter")
    public String factColumnFilter;
    @DynamicFieldType(label="Einbezogene Werte", readOnly=true)
    @Column(value="included_values")
    public String includedValues;
    @DynamicFieldType(label="Ausgeschlossene Werte", readOnly=true)
    @Column(value="excluded_values")
    public String excludedValues;
    @DynamicFieldType(label="Auslieferungsversion", visibleInSimplifiedForm=false)
    @Column(value="default_release")
    public String defaultRelease;

    @Override
    public boolean canBeCreatedByUser() {
        return false;
    }

    @Override
    public boolean canBeDeletedByUser() {
        return false;
    }

    @Override
    public List<Item> getCellSpecificItems(String fieldName, DataSource ds) {
        ArrayList<Item> items = new ArrayList();
        if (fieldName.equals("defaultRelease")) {
            items = DbMetaAdapter.getDefaultReleaseValues(ds);
        } else if (fieldName.equals("dimensionAttributeId")) {
            try {
                JdbcTemplate jt = new JdbcTemplate(ds);
                String sql = "SELECT d.caption || ' - ' || da.caption || ' (' || da.id || ')' AS label,       da.id AS value FROM metadata.dimension_attribute da LEFT JOIN metadata.dimension d   ON d.id = da.dimension_id ORDER BY 1 ASC";
                return jt.query(sql, (rs, rowNum) -> new Item(rs.getString("label"), rs.getString("value")));
            }
            catch (DataAccessException dae) {
                System.err.println("Database error while retrieving table or columns: " + dae.getMessage());
            }
            catch (Exception ex) {
                System.err.println("Unexpected error: " + ex.getMessage());
            }
        }
        return items;
    }
}

