/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.repository.dto;

import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.service.DbMetaAdapter;
import de.superx.jdbc.entity.EntityBase;
import de.superx.jdbc.model.DynamicFieldType;
import de.superx.jdbc.model.EntityDescriptor;
import de.superx.jdbc.model.TableRef;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.Item;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;

@Table(schema="metadata", value="facttable")
public class FactDto
extends EntityBase {
    @Id
    @DynamicFieldType(label="ID", readOnly=true, visibleInSimplifiedForm=false)
    public Identifier id;
    @EntityDescriptor
    @DynamicFieldType(label="Faktentabellenbezeichnug")
    public String caption;
    @DynamicFieldType(label="Beschreibung", editControlType=FieldType.TextArea)
    public String description;
    @DynamicFieldType(label="Sachgebiet", editControlType=FieldType.Select, readOnly=true)
    @TableRef(table="sachgebiete", keyField="tid", labelField="name")
    public Integer sachgebiettid;
    @DynamicFieldType(label="Tabellenname", readOnly=true)
    public String tablename;
    @DynamicFieldType(label="Auslieferungsversion", visibleInSimplifiedForm=false)
    @Column(value="default_release")
    public String defaultRelease;

    @Override
    public boolean canBeCreatedByUser() {
        return false;
    }

    @Override
    public boolean canBeDeletedByUser() {
        return false;
    }

    @Override
    public List<Item> getCellSpecificItems(String fieldName, DataSource ds) {
        List<Item> items = new ArrayList<Item>();
        if (fieldName.equals("defaultRelease")) {
            items = DbMetaAdapter.getDefaultReleaseValues(ds);
        }
        return items;
    }
}

