/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.repository.dto;

import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.service.DbMetaAdapter;
import de.superx.jdbc.entity.EntityBase;
import de.superx.jdbc.model.DynamicFieldType;
import de.superx.jdbc.model.EntityDescriptor;
import de.superx.jdbc.model.TableRef;
import de.superx.rest.model.ColumnType;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.Item;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;

@Table(schema="metadata", value="dimension")
public class DimensionDto
extends EntityBase {
    @Id
    @DynamicFieldType(label="ID", readOnly=true, visibleInSimplifiedForm=false)
    public Identifier id;
    @EntityDescriptor
    @DynamicFieldType(label="Dimensionsbezeichnung")
    public String caption;
    @DynamicFieldType(label="Beschreibung", editControlType=FieldType.TextArea)
    public String description;
    @DynamicFieldType(label="Faktentabelle", readOnly=true, visibleInSimplifiedForm=true)
    @TableRef(schema="metadata", table="facttable", keyField="id", labelField="caption")
    @Column(value="facttable_id")
    public Identifier factTableId;
    @DynamicFieldType(label="Tabellenname", readOnly=true)
    public String tablename;
    @DynamicFieldType(label="Join-Spalte", readOnly=true, visibleInSimplifiedForm=false)
    public String joincolumn;
    @DynamicFieldType(label="Join-Alias", readOnly=true, visibleInSimplifiedForm=false)
    public String alias;
    @DynamicFieldType(label="Hierarchie", editControlType=FieldType.Select, columnType=ColumnType.BooleanColumnBiAnalysis, readOnly=true, visibleInSimplifiedForm=false)
    @Column(value="is_hierarchy")
    public Boolean isHierarchy;
    @DynamicFieldType(label="Historisch", editControlType=FieldType.Select, columnType=ColumnType.BooleanColumnBiAnalysis, readOnly=true, visibleInSimplifiedForm=false)
    @Column(value="is_historical")
    public Boolean isHistorical;
    @DynamicFieldType(label="Gemeinsame Dimension", readOnly=true, visibleInSimplifiedForm=true)
    @TableRef(schema="metadata", table="dimension", keyField="id", labelField="caption")
    public String conformed;
    @DynamicFieldType(label="ID Spalte", readOnly=true, visibleInSimplifiedForm=false)
    @Column(value="id_column")
    public String idColumn;
    @DynamicFieldType(label="Auslieferungsversion", visibleInSimplifiedForm=false)
    @Column(value="default_release")
    public String defaultRelease;
    @DynamicFieldType(label="Ausgeblendet", editControlType=FieldType.Select, columnType=ColumnType.BooleanColumnBiAnalysis, visibleInSimplifiedForm=false)
    @Column(value="is_hidden")
    public Boolean isHidden;
    @DynamicFieldType(label="Position", visibleInSimplifiedForm=false)
    public Integer position;

    @Override
    public boolean canBeCreatedByUser() {
        return false;
    }

    @Override
    public boolean canBeDeletedByUser() {
        return false;
    }

    @Override
    public List<Item> getCellSpecificItems(String fieldName, DataSource ds) {
        List<Item> items = new ArrayList<Item>();
        if (fieldName.equals("defaultRelease")) {
            items = DbMetaAdapter.getDefaultReleaseValues(ds);
        }
        return items;
    }
}

