/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.models;

import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.DimensionAttribute;
import de.superx.bianalysis.repository.dto.DimensionDto;
import java.util.List;
import org.springframework.data.annotation.Transient;

public class Dimension {
    private DimensionDto dimensionDto;
    @Transient
    public String conformedCaption;
    @Transient
    public String conformedDescription;
    @Transient
    public List<DimensionAttribute> dimensionAttributes;

    public Dimension(DimensionDto dimDto) {
        this.setDimensionDto(dimDto);
    }

    public void setDimensionAttributes(List<DimensionAttribute> lda) {
        for (DimensionAttribute dimensionAttribute : lda) {
            dimensionAttribute.setDimensionColumnAlias(dimensionAttribute.getColumnname() + "_" + this.getId().value);
        }
        this.dimensionAttributes = lda;
    }

    public List<DimensionAttribute> getDimensionAttributes() {
        return this.dimensionAttributes;
    }

    public boolean isHidden() {
        if (this.dimensionDto.isHidden == null) {
            return false;
        }
        return this.dimensionDto.isHidden;
    }

    public DimensionDto getDimensionDto() {
        return this.dimensionDto;
    }

    public void setDimensionDto(DimensionDto dimensionDto) {
        this.dimensionDto = dimensionDto;
    }

    public Identifier getId() {
        return this.dimensionDto.id;
    }

    public String getCaption() {
        return this.dimensionDto.caption;
    }

    public Identifier getFactTableId() {
        return this.dimensionDto.factTableId;
    }

    public String getTablename() {
        return this.dimensionDto.tablename;
    }

    public String getJoincolumn() {
        return this.dimensionDto.joincolumn;
    }

    public String getAlias() {
        return this.dimensionDto.alias;
    }

    public String getDescription() {
        return this.dimensionDto.description;
    }

    public boolean isHierarchy() {
        if (this.dimensionDto.isHierarchy == null) {
            return false;
        }
        return this.dimensionDto.isHierarchy;
    }

    public boolean isHistorical() {
        if (this.dimensionDto.isHistorical == null) {
            return false;
        }
        return this.dimensionDto.isHistorical;
    }

    public String getConformed() {
        return this.dimensionDto.conformed;
    }

    public String getIdColumn() {
        return this.dimensionDto.idColumn;
    }

    public Integer getPosition() {
        return this.dimensionDto.position;
    }
}

