/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.event.PrintJobListener;
import javax.print.event.PrintServiceAttributeListener;
import javax.swing.JEditorPane;
import javax.swing.text.View;

public class PrintUtils {
    public static int DEFAULT_DPI = 72;
    public static float DEFAULT_PAGE_WIDTH_INCH = 8.5f;
    public static float DEFAULT_PAGE_HEIGHT_INCH = 11.0f;
    int x = 100;
    int y = 80;
    GraphicsConfiguration gc = null;
    PrintService[] services;
    PrintService defaultService;
    DocFlavor flavor = null;
    PrintRequestAttributeSet attributes;
    Vector pjlListeners = new Vector();
    Vector pjalListeners = new Vector();
    Vector psalListeners = new Vector();

    public PrintUtils() {
        this.attributes = new HashPrintRequestAttributeSet();
        this.defaultService = PrintServiceLookup.lookupDefaultPrintService();
        this.services = PrintServiceLookup.lookupPrintServices(this.flavor, this.attributes);
        DocFlavor[] df = this.defaultService.getSupportedDocFlavors();
        for (int i = 0; i < df.length; ++i) {
            if (this.defaultService == null || this.services != null && this.services.length != 0) continue;
            this.services = new PrintService[1];
            this.services[0] = this.defaultService;
        }
    }

    public void setGraphicsConfiguration(GraphicsConfiguration gc) {
        this.gc = gc;
    }

    public void setServices(PrintService[] services) {
        this.services = services;
    }

    public void setDefaultService(PrintService service) {
        this.defaultService = service;
    }

    public void setDocFlavor(DocFlavor flavor) {
        this.flavor = flavor;
    }

    public void setPrintRequestAttributes(PrintRequestAttributeSet attributes) {
        this.attributes = attributes;
    }

    public void setPrintDialogLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void addPrintJobListener(PrintJobListener pjl) {
        this.pjlListeners.addElement(pjl);
    }

    public void removePrintJobListener(PrintJobListener pjl) {
        this.pjlListeners.removeElement(pjl);
    }

    public void addPrintServiceAttributeListener(PrintServiceAttributeListener psal) {
        this.psalListeners.addElement(psal);
    }

    public void removePrintServiceAttributeListener(PrintServiceAttributeListener psal) {
        this.psalListeners.removeElement(psal);
    }

    public boolean printJEditorPane(JEditorPane jep, PrintService ps) {
        float pageY;
        if (ps == null || jep == null) {
            return false;
        }
        View rv = jep.getUI().getRootView(jep);
        int x = (int)rv.getPreferredSpan(0);
        int y = (int)rv.getPreferredSpan(1);
        DocPrintJob dpj = ps.createPrintJob();
        PrintJobAttributeSet pjas = dpj.getAttributes();
        PrinterResolution pr = (PrinterResolution)pjas.get(PrinterResolution.class);
        int dpi = pr != null ? pr.getFeedResolution(100) : DEFAULT_DPI;
        MediaPrintableArea mpa = (MediaPrintableArea)pjas.get(MediaPrintableArea.class);
        if (mpa != null) {
            pageX = mpa.getX(25400);
            pageY = mpa.getX(25400);
        } else {
            pageX = DEFAULT_PAGE_WIDTH_INCH;
            pageY = DEFAULT_PAGE_HEIGHT_INCH;
        }
        int pixelsPerPageY = (int)((float)dpi * pageY);
        boolean colour = pjas.containsValue(Chromaticity.COLOR);
        int imgMode = (colour &= ps.getAttribute(ColorSupported.class) == ColorSupported.SUPPORTED) ? 5 : 10;
        BufferedImage img = new BufferedImage(x, y, imgMode);
        Graphics myGraphics = img.getGraphics();
        myGraphics.setClip(0, 0, x, y);
        myGraphics.setColor(Color.WHITE);
        myGraphics.fillRect(0, 0, x, y);
        rv.paint(myGraphics, new Rectangle(0, 0, x, y));
        try {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = writers.next();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageOutputStream ios = ImageIO.createImageOutputStream(out);
            writer.setOutput(ios);
            int imageHeight = img.getHeight();
            int numberOfPages = (int)((double)(imageHeight / pixelsPerPageY) + 0.5);
            for (int i = 0; i < numberOfPages; ++i) {
                int startY = i * pixelsPerPageY;
                BufferedImage subImg = img.getSubimage(0, startY, x, pixelsPerPageY);
                writer.write(subImg);
                SimpleDoc sd = new SimpleDoc(out.toByteArray(), DocFlavor.BYTE_ARRAY.JPEG, null);
                this.printDocument(sd, ps);
                out.reset();
            }
        }
        catch (PrintException e) {
            System.out.println("Error printing document.");
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("Error creating ImageOutputStream or writing to it.");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean printDocument(Doc doc, PrintService ps) throws PrintException {
        if (ps == null) {
            return false;
        }
        this.addAllPrintServiceAttributeListeners(ps);
        DocPrintJob dpj = ps.createPrintJob();
        this.addAllPrintJobListeners(dpj);
        dpj.print(doc, this.attributes);
        return true;
    }

    public PrintService showPrintDialog() {
        return ServiceUI.printDialog(this.gc, this.x, this.y, this.services, this.defaultService, this.flavor, this.attributes);
    }

    private void addAllPrintServiceAttributeListeners(PrintService ps) {
        for (int i = 0; i < this.psalListeners.size(); ++i) {
            PrintServiceAttributeListener p = (PrintServiceAttributeListener)this.psalListeners.get(i);
            ps.addPrintServiceAttributeListener(p);
        }
    }

    private void addAllPrintJobListeners(DocPrintJob dpj) {
        for (int i = 0; i < this.pjlListeners.size(); ++i) {
            PrintJobListener p = (PrintJobListener)this.pjlListeners.get(i);
            dpj.addPrintJobListener(p);
        }
    }
}

