/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping.schema;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.data.jdbc.core.mapping.schema.Column;
import org.springframework.data.jdbc.core.mapping.schema.Table;
import org.springframework.data.jdbc.core.mapping.schema.TableDiff;
import org.springframework.data.jdbc.core.mapping.schema.Tables;

record SchemaDiff(List<Table> tableAdditions, List<Table> tableDeletions, List<TableDiff> tableDiffs) {
    public static SchemaDiff diff(Tables mappedEntities, Tables existingTables, Comparator<String> nameComparator) {
        SortedMap<String, Table> existingIndex = SchemaDiff.createMapping(existingTables.tables(), SchemaDiff::getKey, nameComparator);
        SortedMap<String, Table> mappedIndex = SchemaDiff.createMapping(mappedEntities.tables(), SchemaDiff::getKey, nameComparator);
        List<Table> toCreate = SchemaDiff.getTablesToCreate(mappedEntities, SchemaDiff.withTableKey(existingIndex::containsKey));
        List<Table> toDrop = SchemaDiff.getTablesToDrop(existingTables, SchemaDiff.withTableKey(mappedIndex::containsKey));
        List<TableDiff> tableDiffs = SchemaDiff.diffTable(mappedEntities, existingIndex, SchemaDiff.withTableKey(existingIndex::containsKey), nameComparator);
        return new SchemaDiff(toCreate, toDrop, tableDiffs);
    }

    private static List<Table> getTablesToCreate(Tables mappedEntities, Predicate<Table> excludeTable) {
        ArrayList<Table> toCreate = new ArrayList<Table>(mappedEntities.tables().size());
        for (Table table : mappedEntities.tables()) {
            if (excludeTable.test(table)) continue;
            toCreate.add(table);
        }
        return toCreate;
    }

    private static List<Table> getTablesToDrop(Tables existingTables, Predicate<Table> excludeTable) {
        ArrayList<Table> toDrop = new ArrayList<Table>(existingTables.tables().size());
        for (Table table : existingTables.tables()) {
            if (excludeTable.test(table)) continue;
            toDrop.add(table);
        }
        return toDrop;
    }

    private static List<TableDiff> diffTable(Tables mappedEntities, Map<String, Table> existingIndex, Predicate<Table> includeTable, Comparator<String> nameComparator) {
        ArrayList<TableDiff> tableDiffs = new ArrayList<TableDiff>();
        for (Table mappedEntity : mappedEntities.tables()) {
            if (!includeTable.test(mappedEntity)) continue;
            Table existingTable = existingIndex.get(SchemaDiff.getKey(mappedEntity));
            TableDiff tableDiff = new TableDiff(mappedEntity);
            SortedMap<String, Column> mappedColumns = SchemaDiff.createMapping(mappedEntity.columns(), Column::name, nameComparator);
            mappedEntity.keyColumns().forEach(it -> mappedColumns.put(it.name(), (Column)it));
            SortedMap<String, Column> existingColumns = SchemaDiff.createMapping(existingTable.columns(), Column::name, nameComparator);
            existingTable.keyColumns().forEach(it -> existingColumns.put(it.name(), (Column)it));
            TreeMap<String, Column> toDelete = new TreeMap<String, Column>(nameComparator);
            toDelete.putAll(existingColumns);
            mappedColumns.keySet().forEach(toDelete::remove);
            tableDiff.columnsToDrop().addAll(toDelete.values());
            TreeMap<String, Column> addedColumns = new TreeMap<String, Column>(nameComparator);
            addedColumns.putAll(mappedColumns);
            existingColumns.keySet().forEach(addedColumns::remove);
            for (Column column : mappedEntity.keyColumns()) {
                if (!addedColumns.containsKey(column.name())) continue;
                tableDiff.columnsToAdd().add(column);
            }
            for (Column column : mappedEntity.columns()) {
                if (!addedColumns.containsKey(column.name())) continue;
                tableDiff.columnsToAdd().add(column);
            }
            tableDiffs.add(tableDiff);
        }
        return tableDiffs;
    }

    private static <T> SortedMap<String, T> createMapping(List<T> items, Function<T, String> keyFunction, Comparator<String> nameComparator) {
        TreeMap mapping = new TreeMap(nameComparator);
        items.forEach(it -> mapping.put((String)keyFunction.apply(it), it));
        return mapping;
    }

    private static String getKey(Table table) {
        return table.schema() + "." + table.name();
    }

    private static Predicate<Table> withTableKey(Predicate<String> predicate) {
        return it -> predicate.test(SchemaDiff.getKey(it));
    }
}

