/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.support;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.JobRepository;

public class ResourcelessJobRepository
implements JobRepository {
    private JobInstance jobInstance;
    private JobExecution jobExecution;

    @Override
    public boolean isJobInstanceExists(String jobName, JobParameters jobParameters) {
        return false;
    }

    @Override
    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        this.jobInstance = new JobInstance(1L, jobName);
        return this.jobInstance;
    }

    @Override
    public JobExecution createJobExecution(String jobName, JobParameters jobParameters) {
        if (this.jobInstance == null) {
            this.createJobInstance(jobName, jobParameters);
        }
        this.jobExecution = new JobExecution(this.jobInstance, 1L, jobParameters);
        return this.jobExecution;
    }

    @Override
    public void update(JobExecution jobExecution) {
        jobExecution.setLastUpdated(LocalDateTime.now());
        this.jobExecution = jobExecution;
    }

    @Override
    public void add(StepExecution stepExecution) {
        this.addAll(Collections.singletonList(stepExecution));
    }

    @Override
    public void addAll(Collection<StepExecution> stepExecutions) {
        this.jobExecution.addStepExecutions(new ArrayList<StepExecution>(stepExecutions));
    }

    @Override
    public void update(StepExecution stepExecution) {
        stepExecution.setLastUpdated(LocalDateTime.now());
        if (this.jobExecution.isStopping()) {
            stepExecution.setTerminateOnly();
        }
    }

    @Override
    public void updateExecutionContext(StepExecution stepExecution) {
        stepExecution.setLastUpdated(LocalDateTime.now());
    }

    @Override
    public void updateExecutionContext(JobExecution jobExecution) {
        jobExecution.setLastUpdated(LocalDateTime.now());
    }

    @Override
    public StepExecution getLastStepExecution(JobInstance jobInstance, String stepName) {
        return this.jobExecution.getStepExecutions().stream().filter(stepExecution -> stepExecution.getStepName().equals(stepName)).findFirst().orElse(null);
    }

    @Override
    public long getStepExecutionCount(JobInstance jobInstance, String stepName) {
        return this.jobExecution.getStepExecutions().stream().filter(stepExecution -> stepExecution.getStepName().equals(stepName)).count();
    }

    @Override
    public JobExecution getLastJobExecution(String jobName, JobParameters jobParameters) {
        return this.jobExecution;
    }
}

