/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.MongoSequenceIncrementer;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.core.repository.persistence.converter.JobExecutionConverter;
import org.springframework.batch.core.repository.persistence.converter.StepExecutionConverter;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class MongoStepExecutionDao
implements StepExecutionDao {
    private static final String STEP_EXECUTIONS_COLLECTION_NAME = "BATCH_STEP_EXECUTION";
    private static final String STEP_EXECUTIONS_SEQUENCE_NAME = "BATCH_STEP_EXECUTION_SEQ";
    private static final String JOB_EXECUTIONS_COLLECTION_NAME = "BATCH_JOB_EXECUTION";
    private final StepExecutionConverter stepExecutionConverter = new StepExecutionConverter();
    private final JobExecutionConverter jobExecutionConverter = new JobExecutionConverter();
    private final MongoOperations mongoOperations;
    private DataFieldMaxValueIncrementer stepExecutionIncrementer;

    public MongoStepExecutionDao(MongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
        this.stepExecutionIncrementer = new MongoSequenceIncrementer(mongoOperations, STEP_EXECUTIONS_SEQUENCE_NAME);
    }

    public void setStepExecutionIncrementer(DataFieldMaxValueIncrementer stepExecutionIncrementer) {
        this.stepExecutionIncrementer = stepExecutionIncrementer;
    }

    @Override
    public void saveStepExecution(StepExecution stepExecution) {
        org.springframework.batch.core.repository.persistence.StepExecution stepExecutionToSave = this.stepExecutionConverter.fromStepExecution(stepExecution);
        long stepExecutionId = this.stepExecutionIncrementer.nextLongValue();
        stepExecutionToSave.setStepExecutionId(stepExecutionId);
        this.mongoOperations.insert((Object)stepExecutionToSave, STEP_EXECUTIONS_COLLECTION_NAME);
        stepExecution.setId(stepExecutionId);
    }

    @Override
    public void saveStepExecutions(Collection<StepExecution> stepExecutions) {
        for (StepExecution stepExecution : stepExecutions) {
            this.saveStepExecution(stepExecution);
        }
    }

    @Override
    public void updateStepExecution(StepExecution stepExecution) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"stepExecutionId").is((Object)stepExecution.getId()));
        org.springframework.batch.core.repository.persistence.StepExecution stepExecutionToUpdate = this.stepExecutionConverter.fromStepExecution(stepExecution);
        this.mongoOperations.findAndReplace(query, (Object)stepExecutionToUpdate, STEP_EXECUTIONS_COLLECTION_NAME);
    }

    @Override
    public StepExecution getStepExecution(JobExecution jobExecution, Long stepExecutionId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"stepExecutionId").is((Object)stepExecutionId));
        org.springframework.batch.core.repository.persistence.StepExecution stepExecution = (org.springframework.batch.core.repository.persistence.StepExecution)this.mongoOperations.findOne(query, org.springframework.batch.core.repository.persistence.StepExecution.class, STEP_EXECUTIONS_COLLECTION_NAME);
        return stepExecution != null ? this.stepExecutionConverter.toStepExecution(stepExecution, jobExecution) : null;
    }

    @Override
    public StepExecution getLastStepExecution(JobInstance jobInstance, String stepName) {
        ArrayList<org.springframework.batch.core.repository.persistence.StepExecution> stepExecutions = new ArrayList<org.springframework.batch.core.repository.persistence.StepExecution>();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobInstanceId").is((Object)jobInstance.getId()));
        List jobExecutions = this.mongoOperations.find(query, org.springframework.batch.core.repository.persistence.JobExecution.class, JOB_EXECUTIONS_COLLECTION_NAME);
        for (org.springframework.batch.core.repository.persistence.JobExecution jobExecution : jobExecutions) {
            stepExecutions.addAll(jobExecution.getStepExecutions());
        }
        Optional<org.springframework.batch.core.repository.persistence.StepExecution> lastStepExecution = stepExecutions.stream().filter(stepExecution -> stepExecution.getName().equals(stepName)).min(Comparator.comparing(org.springframework.batch.core.repository.persistence.StepExecution::getCreateTime).thenComparing(org.springframework.batch.core.repository.persistence.StepExecution::getId));
        if (lastStepExecution.isPresent()) {
            org.springframework.batch.core.repository.persistence.StepExecution stepExecution2 = lastStepExecution.get();
            JobExecution jobExecution = this.jobExecutionConverter.toJobExecution(jobExecutions.stream().filter(execution -> execution.getJobExecutionId().equals(stepExecution2.getJobExecutionId())).findFirst().get(), jobInstance);
            return this.stepExecutionConverter.toStepExecution(stepExecution2, jobExecution);
        }
        return null;
    }

    @Override
    public void addStepExecutions(JobExecution jobExecution) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobExecutionId").is((Object)jobExecution.getId()));
        List<StepExecution> stepExecutions = this.mongoOperations.find(query, org.springframework.batch.core.repository.persistence.StepExecution.class, STEP_EXECUTIONS_COLLECTION_NAME).stream().map(stepExecution -> this.stepExecutionConverter.toStepExecution((org.springframework.batch.core.repository.persistence.StepExecution)stepExecution, jobExecution)).toList();
        jobExecution.addStepExecutions(stepExecutions);
    }

    @Override
    public long countStepExecutions(JobInstance jobInstance, String stepName) {
        long count = 0L;
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"jobInstanceId").is((Object)jobInstance.getId()));
        List jobExecutions = this.mongoOperations.find(query, org.springframework.batch.core.repository.persistence.JobExecution.class, JOB_EXECUTIONS_COLLECTION_NAME);
        for (org.springframework.batch.core.repository.persistence.JobExecution jobExecution : jobExecutions) {
            List<org.springframework.batch.core.repository.persistence.StepExecution> stepExecutions = jobExecution.getStepExecutions();
            for (org.springframework.batch.core.repository.persistence.StepExecution stepExecution : stepExecutions) {
                if (!stepExecution.getName().equals(stepName)) continue;
                ++count;
            }
        }
        return count;
    }
}

