/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow;

import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.SimpleStepHandler;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecutionException;
import org.springframework.batch.core.job.flow.JobFlowExecutor;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.util.Assert;

public class FlowStep
extends AbstractStep {
    private Flow flow;

    public FlowStep() {
        super(null);
    }

    public FlowStep(Flow flow) {
        super(flow.getName());
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state((this.flow != null ? 1 : 0) != 0, (String)"A Flow must be provided");
        if (this.getName() == null) {
            this.setName(this.flow.getName());
        }
        super.afterPropertiesSet();
    }

    @Override
    protected void doExecute(StepExecution stepExecution) throws Exception {
        try {
            stepExecution.getExecutionContext().put("batch.stepType", (Object)this.getClass().getName());
            SimpleStepHandler stepHandler = new SimpleStepHandler(this.getJobRepository(), stepExecution.getExecutionContext());
            JobFlowExecutor executor = new JobFlowExecutor(this.getJobRepository(), stepHandler, stepExecution.getJobExecution());
            executor.updateJobExecutionStatus(this.flow.start(executor).getStatus());
            stepExecution.upgradeStatus(executor.getJobExecution().getStatus());
            stepExecution.setExitStatus(executor.getJobExecution().getExitStatus());
        }
        catch (FlowExecutionException e) {
            if (e.getCause() instanceof JobExecutionException) {
                throw (JobExecutionException)e.getCause();
            }
            throw new JobExecutionException("Flow execution ended unexpectedly", e);
        }
    }
}

