/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.explore.support;

import java.util.Properties;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.SimpleJobExplorer;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;

public abstract class AbstractJobExplorerFactoryBean
implements FactoryBean<JobExplorer>,
InitializingBean {
    private static final String TRANSACTION_ISOLATION_LEVEL_PREFIX = "ISOLATION_";
    private static final String TRANSACTION_PROPAGATION_PREFIX = "PROPAGATION_";
    private PlatformTransactionManager transactionManager;
    private TransactionAttributeSource transactionAttributeSource;
    private final ProxyFactory proxyFactory = new ProxyFactory();

    protected abstract JobInstanceDao createJobInstanceDao() throws Exception;

    protected abstract JobExecutionDao createJobExecutionDao() throws Exception;

    protected abstract StepExecutionDao createStepExecutionDao() throws Exception;

    protected abstract ExecutionContextDao createExecutionContextDao() throws Exception;

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        Assert.notNull((Object)transactionAttributeSource, (String)"transactionAttributeSource must not be null.");
        this.transactionAttributeSource = transactionAttributeSource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.transactionManager, (String)"TransactionManager must not be null.");
        if (this.transactionAttributeSource == null) {
            Properties transactionAttributes = new Properties();
            String transactionProperties = String.join((CharSequence)",", TRANSACTION_PROPAGATION_PREFIX + String.valueOf(Propagation.SUPPORTS), TRANSACTION_ISOLATION_LEVEL_PREFIX + String.valueOf(Isolation.DEFAULT));
            transactionAttributes.setProperty("get*", transactionProperties);
            transactionAttributes.setProperty("find*", transactionProperties);
            this.transactionAttributeSource = new NameMatchTransactionAttributeSource();
            ((NameMatchTransactionAttributeSource)this.transactionAttributeSource).setProperties(transactionAttributes);
        }
    }

    public Class<JobExplorer> getObjectType() {
        return JobExplorer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public JobExplorer getObject() throws Exception {
        TransactionInterceptor advice = new TransactionInterceptor((TransactionManager)this.transactionManager, this.transactionAttributeSource);
        this.proxyFactory.addAdvice((Advice)advice);
        this.proxyFactory.setProxyTargetClass(false);
        this.proxyFactory.addInterface(JobExplorer.class);
        this.proxyFactory.setTarget((Object)this.getTarget());
        return (JobExplorer)this.proxyFactory.getProxy(this.getClass().getClassLoader());
    }

    private JobExplorer getTarget() throws Exception {
        return new SimpleJobExplorer(this.createJobInstanceDao(), this.createJobExecutionDao(), this.createStepExecutionDao(), this.createExecutionContextDao());
    }
}

