/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.converter;

import java.util.Map;
import java.util.Properties;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.converter.DateToStringConverter;
import org.springframework.batch.core.converter.JobParametersConversionException;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.converter.LocalDateTimeToStringConverter;
import org.springframework.batch.core.converter.LocalDateToStringConverter;
import org.springframework.batch.core.converter.LocalTimeToStringConverter;
import org.springframework.batch.core.converter.StringToDateConverter;
import org.springframework.batch.core.converter.StringToLocalDateConverter;
import org.springframework.batch.core.converter.StringToLocalDateTimeConverter;
import org.springframework.batch.core.converter.StringToLocalTimeConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultJobParametersConverter
implements JobParametersConverter {
    protected ConfigurableConversionService conversionService;

    public DefaultJobParametersConverter() {
        DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.addConverter((Converter)new DateToStringConverter());
        conversionService.addConverter((Converter)new StringToDateConverter());
        conversionService.addConverter((Converter)new LocalDateToStringConverter());
        conversionService.addConverter((Converter)new StringToLocalDateConverter());
        conversionService.addConverter((Converter)new LocalTimeToStringConverter());
        conversionService.addConverter((Converter)new StringToLocalTimeConverter());
        conversionService.addConverter((Converter)new LocalDateTimeToStringConverter());
        conversionService.addConverter((Converter)new StringToLocalDateTimeConverter());
        this.conversionService = conversionService;
    }

    @Override
    public JobParameters getJobParameters(@Nullable Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return new JobParameters();
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String parameterName = (String)entry.getKey();
            String encodedJobParameter = (String)entry.getValue();
            JobParameter<?> jobParameter = this.decode(encodedJobParameter);
            jobParametersBuilder.addJobParameter(parameterName, jobParameter);
        }
        return jobParametersBuilder.toJobParameters();
    }

    @Override
    public Properties getProperties(@Nullable JobParameters jobParameters) {
        if (jobParameters == null || jobParameters.isEmpty()) {
            return new Properties();
        }
        Map<String, JobParameter<?>> parameters = jobParameters.getParameters();
        Properties properties = new Properties();
        for (Map.Entry<String, JobParameter<?>> entry : parameters.entrySet()) {
            String parameterName = entry.getKey();
            JobParameter<?> jobParameter = entry.getValue();
            properties.setProperty(parameterName, this.encode(jobParameter));
        }
        return properties;
    }

    public void setConversionService(@NonNull ConfigurableConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"The conversionService must not be null");
        this.conversionService = conversionService;
    }

    protected String encode(JobParameter<?> jobParameter) {
        Class<?> parameterType = jobParameter.getType();
        boolean parameterIdentifying = jobParameter.isIdentifying();
        Object parameterTypedValue = jobParameter.getValue();
        String parameterStringValue = (String)this.conversionService.convert(parameterTypedValue, String.class);
        return String.join((CharSequence)",", parameterStringValue, parameterType.getName(), Boolean.toString(parameterIdentifying));
    }

    protected JobParameter<?> decode(String encodedJobParameter) {
        String parameterStringValue = this.parseValue(encodedJobParameter);
        Class<?> parameterType = this.parseType(encodedJobParameter);
        boolean parameterIdentifying = this.parseIdentifying(encodedJobParameter);
        try {
            Object typedValue = this.conversionService.convert((Object)parameterStringValue, parameterType);
            return new JobParameter<Object>(typedValue, parameterType, parameterIdentifying);
        }
        catch (Exception e) {
            throw new JobParametersConversionException("Unable to convert job parameter " + parameterStringValue + " to type " + String.valueOf(parameterType), e);
        }
    }

    private String parseValue(String encodedJobParameter) {
        String[] tokens = StringUtils.commaDelimitedListToStringArray((String)encodedJobParameter);
        if (tokens.length == 0) {
            return "";
        }
        return tokens[0];
    }

    private Class<?> parseType(String encodedJobParameter) {
        String[] tokens = StringUtils.commaDelimitedListToStringArray((String)encodedJobParameter);
        if (tokens.length <= 1) {
            return String.class;
        }
        try {
            Class<?> type = Class.forName(tokens[1]);
            return type;
        }
        catch (ClassNotFoundException e) {
            throw new JobParametersConversionException("Unable to parse job parameter " + encodedJobParameter, e);
        }
    }

    private boolean parseIdentifying(String encodedJobParameter) {
        String[] tokens = StringUtils.commaDelimitedListToStringArray((String)encodedJobParameter);
        if (tokens.length <= 2) {
            return true;
        }
        return Boolean.parseBoolean(tokens[2]);
    }
}

