/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.GroupAwareJob;
import org.springframework.batch.core.configuration.support.ReferenceJobFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.util.Assert;

public class JobRegistrySmartInitializingSingleton
implements SmartInitializingSingleton,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    private static final Log logger = LogFactory.getLog(JobRegistrySmartInitializingSingleton.class);
    private JobRegistry jobRegistry = null;
    private final Collection<String> jobNames = new HashSet<String>();
    private String groupName = null;
    private ListableBeanFactory beanFactory;

    public JobRegistrySmartInitializingSingleton() {
    }

    public JobRegistrySmartInitializingSingleton(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory;
            this.beanFactory = listableBeanFactory = (ListableBeanFactory)beanFactory;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.jobRegistry != null ? 1 : 0) != 0, (String)"JobRegistry must not be null");
    }

    public void destroy() throws Exception {
        for (String name : this.jobNames) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unregistering job: " + name));
            }
            this.jobRegistry.unregister(name);
        }
        this.jobNames.clear();
    }

    public void afterSingletonsInstantiated() {
        if (this.beanFactory == null) {
            return;
        }
        Map jobs = this.beanFactory.getBeansOfType(Job.class, false, false);
        for (Map.Entry entry : jobs.entrySet()) {
            this.postProcessAfterInitialization((Job)entry.getValue(), (String)entry.getKey());
        }
    }

    private void postProcessAfterInitialization(Job job, String beanName) {
        try {
            String groupName = this.groupName;
            ListableBeanFactory listableBeanFactory = this.beanFactory;
            if (listableBeanFactory instanceof DefaultListableBeanFactory) {
                DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)listableBeanFactory;
                if (this.beanFactory.containsBean(beanName)) {
                    groupName = this.getGroupName(defaultListableBeanFactory.getBeanDefinition(beanName), job);
                }
            }
            job = groupName == null ? job : new GroupAwareJob(groupName, job);
            ReferenceJobFactory jobFactory = new ReferenceJobFactory(job);
            String name = jobFactory.getJobName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registering job: " + name));
            }
            this.jobRegistry.register(jobFactory);
            this.jobNames.add(name);
        }
        catch (DuplicateJobException e) {
            throw new FatalBeanException("Cannot register job configuration", (Throwable)e);
        }
    }

    protected String getGroupName(BeanDefinition beanDefinition, Job job) {
        return this.groupName;
    }
}

