/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.annotation;

import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.support.AutomaticJobRegistrar;
import org.springframework.batch.core.configuration.support.DefaultJobLoader;
import org.springframework.batch.core.configuration.support.JobRegistrySmartInitializingSingleton;
import org.springframework.batch.core.configuration.support.MapJobRegistry;
import org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.springframework.batch.core.launch.support.JobOperatorFactoryBean;
import org.springframework.batch.core.launch.support.TaskExecutorJobLauncher;
import org.springframework.batch.core.repository.support.JobRepositoryFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.log.LogMessage;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

class BatchRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Log LOGGER = LogFactory.getLog(BatchRegistrar.class);
    private static final String MISSING_ANNOTATION_ERROR_MESSAGE = "EnableBatchProcessing is not present on importing class '%s' as expected";
    private static final String JOB_REPOSITORY = "jobRepository";
    private static final String JOB_EXPLORER = "jobExplorer";
    private static final String JOB_LAUNCHER = "jobLauncher";
    private static final String JOB_REGISTRY = "jobRegistry";
    private static final String JOB_LOADER = "jobLoader";

    BatchRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        StopWatch watch = new StopWatch();
        watch.start();
        this.validateState(importingClassMetadata);
        EnableBatchProcessing batchAnnotation = (EnableBatchProcessing)importingClassMetadata.getAnnotations().get(EnableBatchProcessing.class).synthesize();
        this.registerJobRepository(registry, batchAnnotation);
        this.registerJobExplorer(registry, batchAnnotation);
        this.registerJobLauncher(registry, batchAnnotation);
        this.registerJobRegistry(registry);
        this.registerJobRegistrySmartInitializingSingleton(registry);
        this.registerJobOperator(registry, batchAnnotation);
        this.registerAutomaticJobRegistrar(registry, batchAnnotation);
        watch.stop();
        LOGGER.info((Object)LogMessage.format((String)"Finished Spring Batch infrastructure beans configuration in %s ms.", (Object)watch.lastTaskInfo().getTimeMillis()));
    }

    private void validateState(AnnotationMetadata importingClassMetadata) {
        if (!importingClassMetadata.isAnnotated(EnableBatchProcessing.class.getName())) {
            String className = importingClassMetadata.getClassName();
            String errorMessage = String.format(MISSING_ANNOTATION_ERROR_MESSAGE, className);
            throw new IllegalStateException(errorMessage);
        }
    }

    private void registerJobRepository(BeanDefinitionRegistry registry, EnableBatchProcessing batchAnnotation) {
        String databaseType;
        String isolationLevelForCreate;
        String tablePrefix;
        String charset;
        String jobKeyGeneratorRef;
        String incrementerFactoryRef;
        String conversionServiceRef;
        String lobHandlerRef;
        if (registry.containsBeanDefinition(JOB_REPOSITORY)) {
            LOGGER.info((Object)"Bean jobRepository already defined in the application context, skipping the registration of a jobRepository");
            return;
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(JobRepositoryFactoryBean.class);
        String dataSourceRef = batchAnnotation.dataSourceRef();
        beanDefinitionBuilder.addPropertyReference("dataSource", dataSourceRef);
        String transactionManagerRef = batchAnnotation.transactionManagerRef();
        beanDefinitionBuilder.addPropertyReference("transactionManager", transactionManagerRef);
        String executionContextSerializerRef = batchAnnotation.executionContextSerializerRef();
        if (registry.containsBeanDefinition(executionContextSerializerRef)) {
            beanDefinitionBuilder.addPropertyReference("serializer", executionContextSerializerRef);
        }
        if (registry.containsBeanDefinition(lobHandlerRef = batchAnnotation.lobHandlerRef())) {
            beanDefinitionBuilder.addPropertyReference("lobHandler", lobHandlerRef);
        }
        if (registry.containsBeanDefinition(conversionServiceRef = batchAnnotation.conversionServiceRef())) {
            beanDefinitionBuilder.addPropertyReference("conversionService", conversionServiceRef);
        }
        if (registry.containsBeanDefinition(incrementerFactoryRef = batchAnnotation.incrementerFactoryRef())) {
            beanDefinitionBuilder.addPropertyReference("incrementerFactory", incrementerFactoryRef);
        }
        if (registry.containsBeanDefinition(jobKeyGeneratorRef = batchAnnotation.jobKeyGeneratorRef())) {
            beanDefinitionBuilder.addPropertyReference("jobKeyGenerator", jobKeyGeneratorRef);
        }
        if ((charset = batchAnnotation.charset()) != null) {
            beanDefinitionBuilder.addPropertyValue("charset", (Object)Charset.forName(charset));
        }
        if ((tablePrefix = batchAnnotation.tablePrefix()) != null) {
            beanDefinitionBuilder.addPropertyValue("tablePrefix", (Object)tablePrefix);
        }
        if ((isolationLevelForCreate = batchAnnotation.isolationLevelForCreate()) != null) {
            beanDefinitionBuilder.addPropertyValue("isolationLevelForCreate", (Object)isolationLevelForCreate);
        }
        if (StringUtils.hasText((String)(databaseType = batchAnnotation.databaseType()))) {
            beanDefinitionBuilder.addPropertyValue("databaseType", (Object)databaseType);
        }
        beanDefinitionBuilder.addPropertyValue("maxVarCharLength", (Object)batchAnnotation.maxVarCharLength());
        beanDefinitionBuilder.addPropertyValue("clobType", (Object)batchAnnotation.clobType());
        registry.registerBeanDefinition(JOB_REPOSITORY, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    private void registerJobExplorer(BeanDefinitionRegistry registry, EnableBatchProcessing batchAnnotation) {
        String tablePrefix;
        String charset;
        String jobKeyGeneratorRef;
        String conversionServiceRef;
        String lobHandlerRef;
        if (registry.containsBeanDefinition(JOB_EXPLORER)) {
            LOGGER.info((Object)"Bean jobExplorer already defined in the application context, skipping the registration of a jobExplorer");
            return;
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(JobExplorerFactoryBean.class);
        String dataSourceRef = batchAnnotation.dataSourceRef();
        beanDefinitionBuilder.addPropertyReference("dataSource", dataSourceRef);
        String transactionManagerRef = batchAnnotation.transactionManagerRef();
        beanDefinitionBuilder.addPropertyReference("transactionManager", transactionManagerRef);
        String executionContextSerializerRef = batchAnnotation.executionContextSerializerRef();
        if (registry.containsBeanDefinition(executionContextSerializerRef)) {
            beanDefinitionBuilder.addPropertyReference("serializer", executionContextSerializerRef);
        }
        if (registry.containsBeanDefinition(lobHandlerRef = batchAnnotation.lobHandlerRef())) {
            beanDefinitionBuilder.addPropertyReference("lobHandler", lobHandlerRef);
        }
        if (registry.containsBeanDefinition(conversionServiceRef = batchAnnotation.conversionServiceRef())) {
            beanDefinitionBuilder.addPropertyReference("conversionService", conversionServiceRef);
        }
        if (registry.containsBeanDefinition(jobKeyGeneratorRef = batchAnnotation.jobKeyGeneratorRef())) {
            beanDefinitionBuilder.addPropertyReference("jobKeyGenerator", jobKeyGeneratorRef);
        }
        if ((charset = batchAnnotation.charset()) != null) {
            beanDefinitionBuilder.addPropertyValue("charset", (Object)Charset.forName(charset));
        }
        if ((tablePrefix = batchAnnotation.tablePrefix()) != null) {
            beanDefinitionBuilder.addPropertyValue("tablePrefix", (Object)tablePrefix);
        }
        registry.registerBeanDefinition(JOB_EXPLORER, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    private void registerJobLauncher(BeanDefinitionRegistry registry, EnableBatchProcessing batchAnnotation) {
        if (registry.containsBeanDefinition(JOB_LAUNCHER)) {
            LOGGER.info((Object)"Bean jobLauncher already defined in the application context, skipping the registration of a jobLauncher");
            return;
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(TaskExecutorJobLauncher.class);
        beanDefinitionBuilder.addPropertyReference(JOB_REPOSITORY, JOB_REPOSITORY);
        String taskExecutorRef = batchAnnotation.taskExecutorRef();
        if (registry.containsBeanDefinition(taskExecutorRef)) {
            beanDefinitionBuilder.addPropertyReference("taskExecutor", taskExecutorRef);
        }
        registry.registerBeanDefinition(JOB_LAUNCHER, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    private void registerJobRegistry(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(JOB_REGISTRY)) {
            LOGGER.info((Object)"Bean jobRegistry already defined in the application context, skipping the registration of a jobRegistry");
            return;
        }
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(MapJobRegistry.class).getBeanDefinition();
        registry.registerBeanDefinition(JOB_REGISTRY, (BeanDefinition)beanDefinition);
    }

    private void registerJobRegistrySmartInitializingSingleton(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition("jobRegistrySmartInitializingSingleton")) {
            LOGGER.info((Object)"Bean jobRegistrySmartInitializingSingleton already defined in the application context, skipping the registration of a jobRegistrySmartInitializingSingleton");
            return;
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(JobRegistrySmartInitializingSingleton.class);
        beanDefinitionBuilder.addPropertyReference(JOB_REGISTRY, JOB_REGISTRY);
        registry.registerBeanDefinition("jobRegistrySmartInitializingSingleton", (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    private void registerJobOperator(BeanDefinitionRegistry registry, EnableBatchProcessing batchAnnotation) {
        if (registry.containsBeanDefinition("jobOperator")) {
            LOGGER.info((Object)"Bean jobOperator already defined in the application context, skipping the registration of a jobOperator");
            return;
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(JobOperatorFactoryBean.class);
        String transactionManagerRef = batchAnnotation.transactionManagerRef();
        beanDefinitionBuilder.addPropertyReference("transactionManager", transactionManagerRef);
        beanDefinitionBuilder.addPropertyReference(JOB_REPOSITORY, JOB_REPOSITORY);
        beanDefinitionBuilder.addPropertyReference(JOB_LAUNCHER, JOB_LAUNCHER);
        beanDefinitionBuilder.addPropertyReference(JOB_EXPLORER, JOB_EXPLORER);
        beanDefinitionBuilder.addPropertyReference(JOB_REGISTRY, JOB_REGISTRY);
        String jobParametersConverterRef = batchAnnotation.jobParametersConverterRef();
        if (registry.containsBeanDefinition(jobParametersConverterRef)) {
            beanDefinitionBuilder.addPropertyReference("jobParametersConverter", jobParametersConverterRef);
        }
        registry.registerBeanDefinition("jobOperator", (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    private void registerAutomaticJobRegistrar(BeanDefinitionRegistry registry, EnableBatchProcessing batchAnnotation) {
        if (!batchAnnotation.modular()) {
            return;
        }
        if (registry.containsBeanDefinition("jobRegistrar")) {
            LOGGER.info((Object)"Bean jobRegistrar already defined in the application context, skipping the registration of a jobRegistrar");
            return;
        }
        AbstractBeanDefinition jobLoaderBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(DefaultJobLoader.class).addPropertyReference(JOB_REGISTRY, JOB_REGISTRY).getBeanDefinition();
        registry.registerBeanDefinition(JOB_LOADER, (BeanDefinition)jobLoaderBeanDefinition);
        AbstractBeanDefinition jobRegistrarBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(AutomaticJobRegistrar.class).addPropertyReference(JOB_LOADER, JOB_LOADER).getBeanDefinition();
        registry.registerBeanDefinition("jobRegistrar", (BeanDefinition)jobRegistrarBeanDefinition);
    }
}

