/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import com.qmino.miredot.annotations.ReturnType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.service.datasource.DatasourceService;
import org.saiku.service.user.UserService;
import org.saiku.service.util.exception.SaikuServiceException;
import org.saiku.web.rest.objects.DataSourceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="/saiku/{username}/org.saiku.datasources")
public class DataSourceResource {
    private static final Logger log = LoggerFactory.getLogger(DataSourceResource.class);
    private DatasourceService datasourceService;
    private UserService userService;

    public void setDatasourceService(DatasourceService ds) {
        this.datasourceService = ds;
    }

    @GET
    @Produces(value={"application/json"})
    public Collection<SaikuDatasource> getDatasources() {
        try {
            return this.datasourceService.getDatasources(this.userService.getCurrentUserRoles()).values();
        }
        catch (SaikuServiceException e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuDatasource>();
        }
    }

    @DELETE
    @Path(value="/{datasource}")
    public Response.Status deleteDatasource(@PathParam(value="datasource") String datasourceName) {
        this.datasourceService.removeDatasource(datasourceName);
        return Response.Status.GONE;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @ReturnType(value="org.saiku.web.rest.objects.DataSourceMapper")
    public Response getDatasourceById(@PathParam(value="id") String id) {
        try {
            SaikuDatasource saikuDatasource = null;
            Map datasources = this.datasourceService.getDatasources(this.userService.getCurrentUserRoles());
            for (SaikuDatasource currentDatasource : datasources.values()) {
                if (!currentDatasource.getProperties().getProperty("id").equals(id)) continue;
                saikuDatasource = currentDatasource;
                break;
            }
            return Response.ok().type("application/json").entity((Object)new DataSourceMapper(saikuDatasource)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).type("text/plain").build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{id}")
    @ReturnType(value="org.saiku.web.rest.objects.DataSourceMapper")
    public Response updateDatasourceLocale(String locale, @PathParam(value="id") String id) {
        boolean overwrite = true;
        try {
            SaikuDatasource saikuDatasource = null;
            Map datasources = this.datasourceService.getDatasources(this.userService.getCurrentUserRoles());
            for (SaikuDatasource currentDatasource : datasources.values()) {
                if (!currentDatasource.getProperties().getProperty("id").equals(id)) continue;
                saikuDatasource = currentDatasource;
                this.changeLocale(saikuDatasource, locale);
                this.datasourceService.addDatasource(saikuDatasource, overwrite, this.userService.getCurrentUserRoles());
                break;
            }
            return Response.ok().type("application/json").entity(saikuDatasource).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).type("text/plain").build();
        }
    }

    private void changeLocale(SaikuDatasource saikuDatasource, String newLocale) {
        String location = saikuDatasource.getProperties().getProperty("location");
        String oldLocale = this.getOldLocale(location);
        String newLocation = location.replace(oldLocale, newLocale);
        saikuDatasource.getProperties().setProperty("location", newLocation);
    }

    private String getOldLocale(String location) {
        String referenceText = "locale=";
        int start = location.toLowerCase().indexOf(referenceText);
        if (start == -1) {
            return "no locale!";
        }
        int end = location.indexOf(";", start += referenceText.length());
        return location.substring(start, end);
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

