/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.olap;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import mondrian.olap4j.SaikuMondrianHelper;
import org.apache.commons.lang.StringUtils;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.parser.impl.DefaultMdxParserImpl;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.dto.SaikuHierarchy;
import org.saiku.olap.dto.SaikuLevel;
import org.saiku.olap.dto.SaikuMember;
import org.saiku.olap.dto.SimpleCubeElement;
import org.saiku.olap.dto.resultset.AbstractBaseCell;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.query.IQuery;
import org.saiku.olap.query.OlapQuery;
import org.saiku.olap.query.QueryDeserializer;
import org.saiku.olap.query2.ThinAxis;
import org.saiku.olap.query2.ThinCalculatedMember;
import org.saiku.olap.query2.ThinHierarchy;
import org.saiku.olap.query2.ThinLevel;
import org.saiku.olap.query2.ThinMeasure;
import org.saiku.olap.query2.ThinMember;
import org.saiku.olap.query2.ThinQuery;
import org.saiku.olap.query2.ThinQueryModel;
import org.saiku.olap.query2.util.Fat;
import org.saiku.olap.query2.util.Thin;
import org.saiku.olap.util.ObjectUtil;
import org.saiku.olap.util.OlapResultSetUtil;
import org.saiku.olap.util.QueryConverter;
import org.saiku.olap.util.SaikuProperties;
import org.saiku.olap.util.SaikuUniqueNameComparator;
import org.saiku.olap.util.formatter.CellSetFormatterFactory;
import org.saiku.olap.util.formatter.FlattenedCellSetFormatter;
import org.saiku.olap.util.formatter.ICellSetFormatter;
import org.saiku.query.Query;
import org.saiku.query.QueryDetails;
import org.saiku.query.QueryHierarchy;
import org.saiku.query.QueryLevel;
import org.saiku.query.util.QueryUtil;
import org.saiku.service.olap.OlapDiscoverService;
import org.saiku.service.olap.drillthrough.DimensionResultInfo;
import org.saiku.service.olap.drillthrough.DrillThroughResult;
import org.saiku.service.olap.drillthrough.DrillthroughUtils;
import org.saiku.service.olap.drillthrough.MeasureResultInfo;
import org.saiku.service.olap.drillthrough.ResultInfo;
import org.saiku.service.olap.totals.AxisInfo;
import org.saiku.service.olap.totals.TotalsListsBuilder;
import org.saiku.service.olap.totals.aggregators.TotalAggregator;
import org.saiku.service.util.KeyValue;
import org.saiku.service.util.QueryContext;
import org.saiku.service.util.exception.SaikuServiceException;
import org.saiku.service.util.export.CsvExporter;
import org.saiku.service.util.export.ExcelExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThinQueryService
implements Serializable {
    private static final long serialVersionUID = -7615296596528274904L;
    private static final Logger log = LoggerFactory.getLogger(ThinQueryService.class);
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private OlapDiscoverService olapDiscoverService;
    private CellSetFormatterFactory cff = new CellSetFormatterFactory();
    private final Map<String, QueryContext> context = new HashMap<String, QueryContext>();

    public void setOlapDiscoverService(OlapDiscoverService os) {
        this.olapDiscoverService = os;
    }

    public void setCellSetFormatterFactory(CellSetFormatterFactory cff) {
        this.cff = cff;
    }

    public ThinQuery createQuery(ThinQuery tq) {
        if (StringUtils.isBlank((String)tq.getName())) {
            tq.setName(UUID.randomUUID().toString());
        }
        Map<String, Object> cubeProperties = this.olapDiscoverService.getProperties(tq.getCube());
        tq.getProperties().putAll(cubeProperties);
        if (!this.context.containsKey(tq.getName())) {
            QueryContext qt = new QueryContext(QueryContext.Type.OLAP, tq);
            qt.store(QueryContext.ObjectKey.QUERY, tq);
            this.context.put(tq.getName(), qt);
        }
        return tq;
    }

    public QueryContext getContext(String name) {
        return this.context.get(name);
    }

    @Deprecated
    public ThinQuery createEmpty(String name, SaikuCube cube) {
        try {
            Cube cub = this.olapDiscoverService.getNativeCube(cube);
            Query query = new Query(name, cub);
            return Thin.convert(query, cube);
        }
        catch (Exception e) {
            log.error("Cannot create new query for cube :" + cube, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CellSet executeInternalQuery(ThinQuery query) throws Exception {
        String runId = "RUN#:" + ID_GENERATOR.getAndIncrement();
        QueryContext queryContext = this.context.get(query.getName());
        if (queryContext == null) {
            queryContext = new QueryContext(QueryContext.Type.OLAP, query);
            this.context.put(query.getName(), queryContext);
        }
        OlapConnection con = this.olapDiscoverService.getNativeConnection(query.getCube().getConnection());
        if (StringUtils.isNotBlank((String)query.getCube().getCatalog())) {
            con.setCatalog(query.getCube().getCatalog());
        }
        if (queryContext.contains(QueryContext.ObjectKey.STATEMENT)) {
            Statement s = queryContext.getStatement();
            s.cancel();
            s.close();
            s = null;
            queryContext.remove(QueryContext.ObjectKey.STATEMENT);
        }
        OlapStatement stmt = con.createStatement();
        queryContext.store(QueryContext.ObjectKey.STATEMENT, stmt);
        query = this.updateQuery(query);
        try {
            String mdx = query.getParameterResolvedMdx();
            log.info(runId + "\tType:" + (Object)((Object)query.getType()) + ":\n" + mdx);
            CellSet cs = stmt.executeOlapQuery(mdx);
            queryContext.store(QueryContext.ObjectKey.RESULT, cs);
            if (query != null) {
                queryContext.store(QueryContext.ObjectKey.QUERY, query);
            }
            CellSet cellSet = cs;
            return cellSet;
        }
        finally {
            stmt.close();
            queryContext.remove(QueryContext.ObjectKey.STATEMENT);
        }
    }

    public CellDataSet execute(ThinQuery tq) {
        if (tq.getProperties().containsKey("saiku.olap.result.formatter")) {
            return this.execute(tq, tq.getProperties().get("saiku.olap.result.formatter").toString());
        }
        return this.execute(tq, "");
    }

    public CellDataSet execute(ThinQuery tq, String formatter) {
        String formatterName = formatter == null ? "" : formatter.toLowerCase();
        ICellSetFormatter cf = this.cff.forName(formatterName);
        return this.execute(tq, cf);
    }

    public CellDataSet getFormattedResult(String query, String format) throws Exception {
        QueryContext qc = this.getContext(query);
        ThinQuery tq = qc.getOlapQuery();
        CellSet cs = qc.getOlapResult();
        String formatterName = StringUtils.isBlank((String)format) ? "" : format.toLowerCase();
        ICellSetFormatter cf = this.cff.forName(formatterName);
        CellDataSet result = OlapResultSetUtil.cellSet2Matrix(cs, cf);
        if (ThinQuery.Type.QUERYMODEL.equals((Object)tq.getType()) && cf instanceof FlattenedCellSetFormatter && tq.hasAggregators()) {
            this.calculateTotals(tq, result, cs, cf);
        }
        return result;
    }

    private CellDataSet execute(ThinQuery tq, ICellSetFormatter formatter) {
        try {
            Long start = new Date().getTime();
            log.debug("Query Start");
            CellSet cellSet = this.executeInternalQuery(tq);
            log.debug("Query End");
            String runId = "RUN#:" + ID_GENERATOR.get();
            Long exec = new Date().getTime();
            CellDataSet result = OlapResultSetUtil.cellSet2Matrix(cellSet, formatter);
            Long format = new Date().getTime();
            if (ThinQuery.Type.QUERYMODEL.equals((Object)tq.getType()) && formatter instanceof FlattenedCellSetFormatter && tq.hasAggregators()) {
                this.calculateTotals(tq, result, cellSet, formatter);
            }
            Long totals = new Date().getTime();
            log.info(runId + "\tSize: " + result.getWidth() + "/" + result.getHeight() + "\tExecute:\t" + (exec - start) + "ms\tFormat:\t" + (format - exec) + "ms\tTotals:\t" + (totals - format) + "ms\t Total: " + (totals - start) + "ms");
            result.setRuntime(new Double(format - start).intValue());
            return result;
        }
        catch (Error | Exception e) {
            throw new SaikuServiceException("Can't execute query: " + tq.getName(), e);
        }
    }

    public void cancel(String name) throws SQLException {
        QueryContext queryContext;
        if (this.context.containsKey(name) && (queryContext = this.context.get(name)).contains(QueryContext.ObjectKey.STATEMENT)) {
            Statement stmt = queryContext.getStatement();
            if (stmt != null && !stmt.isClosed()) {
                stmt.cancel();
                stmt.close();
            }
            stmt = null;
            queryContext.remove(QueryContext.ObjectKey.STATEMENT);
        }
    }

    private void getEnabledCMembers(ThinQueryModel qm, ThinQueryModel queryModel) {
        int i = 0;
        for (Map.Entry<ThinQueryModel.AxisLocation, ThinAxis> entry : qm.getAxes().entrySet()) {
            ThinAxis v = entry.getValue();
            for (ThinHierarchy h : v.getHierarchies()) {
                for (Map.Entry<String, ThinLevel> entry1 : h.getLevels().entrySet()) {
                    ThinLevel v2 = entry1.getValue();
                    if (v2.getSelection() == null) continue;
                    for (ThinMember m : v2.getSelection().getMembers()) {
                        if (m.getType() == null || !m.getType().equals("calculatedmember")) continue;
                        Map<ThinQueryModel.AxisLocation, ThinAxis> ax = queryModel.getAxes();
                        ThinAxis sax = ax.get((Object)entry.getKey());
                        List<ThinHierarchy> h2 = sax.getHierarchies();
                        Map<String, ThinLevel> l = h2.get(i).getLevels();
                        ThinLevel l2 = l.get(entry1.getKey());
                        l2.getSelection().getMembers().add(m);
                        queryModel.getAxes().get((Object)entry.getKey()).getHierarchies().get(i).getLevels().get(entry1.getKey()).getSelection().getMembers().add(m);
                    }
                }
                ++i;
            }
        }
    }

    public ThinQuery updateQuery(ThinQuery old) throws Exception {
        if (ThinQuery.Type.QUERYMODEL.equals((Object)old.getType())) {
            Cube cub = this.olapDiscoverService.getNativeCube(old.getCube());
            Query q = Fat.convert(old, cub);
            List<ThinCalculatedMember> cms = old.getQueryModel().getCalculatedMembers();
            ThinQuery tqAfter = Thin.convert(q, old.getCube());
            tqAfter.getQueryModel().setCalculatedMembers(cms);
            this.getEnabledCMembers(old.getQueryModel(), tqAfter.getQueryModel());
            block0: for (ThinMeasure measure : tqAfter.getQueryModel().getDetails().getMeasures()) {
                for (ThinMeasure oldMeasure : old.getQueryModel().getDetails().getMeasures()) {
                    if (!measure.getUniqueName().equals(oldMeasure.getUniqueName())) continue;
                    measure.getAggregators().addAll(oldMeasure.getAggregators());
                    continue block0;
                }
            }
            old.setQueryModel(tqAfter.getQueryModel());
            old.setMdx(tqAfter.getMdx());
        }
        if (this.context.containsKey(old.getName())) {
            QueryContext qc = this.context.get(old.getName());
            qc.store(QueryContext.ObjectKey.QUERY, old);
        }
        String mdx = old.getMdx();
        List params = QueryUtil.parseParameters((String)mdx);
        old.addParameters(params);
        Map<String, Object> cubeProperties = this.olapDiscoverService.getProperties(old.getCube());
        old.getProperties().putAll(cubeProperties);
        old = this.removeDupSelections(old);
        return old;
    }

    private ThinQuery removeDupSelections(ThinQuery old) {
        Map<ThinQueryModel.AxisLocation, ThinAxis> map = old.getQueryModel().getAxes();
        for (Map.Entry<ThinQueryModel.AxisLocation, ThinAxis> entry : map.entrySet()) {
            for (ThinHierarchy h : entry.getValue().getHierarchies()) {
                Map<String, ThinLevel> map2 = h.getLevels();
                for (Map.Entry<String, ThinLevel> levelentry : map2.entrySet()) {
                    List<ThinMember> members = levelentry.getValue().getSelection().getMembers();
                    ArrayList<ThinMember> uniqueMembers = new ArrayList<ThinMember>();
                    HashMap<String, ThinMember> temp = new HashMap<String, ThinMember>();
                    for (ThinMember tm : members) {
                        temp.put(tm.getUniqueName(), tm);
                    }
                    for (ThinMember tm : members) {
                        if (!temp.containsKey(tm.getUniqueName())) continue;
                        uniqueMembers.add(tm);
                        temp.remove(tm.getUniqueName());
                    }
                    levelentry.getValue().getSelection().setMembers(uniqueMembers);
                }
            }
        }
        return old;
    }

    public void deleteQuery(String queryName) {
        try {
            if (this.context.containsKey(queryName)) {
                QueryContext qc = this.context.remove(queryName);
                qc.destroy();
            }
        }
        catch (Exception e) {
            throw new SaikuServiceException(e);
        }
    }

    public byte[] getExport(String queryName, String type) {
        return this.getExport(queryName, type, new FlattenedCellSetFormatter());
    }

    public byte[] getExport(String queryName, String type, String formatter) {
        String formatterName = formatter == null ? "" : formatter.toLowerCase();
        ICellSetFormatter cf = this.cff.forName(formatterName);
        return this.getExport(queryName, type, cf);
    }

    private byte[] getExport(String queryName, String type, ICellSetFormatter formatter) {
        if (StringUtils.isNotBlank((String)type) && this.context.containsKey(queryName)) {
            QueryContext qc = this.context.get(queryName);
            ThinQuery tq = qc.getOlapQuery();
            CellSet rs = qc.getOlapResult();
            CellDataSet table = OlapResultSetUtil.cellSet2Matrix(rs, formatter);
            if (ThinQuery.Type.QUERYMODEL.equals((Object)tq.getType()) && formatter instanceof FlattenedCellSetFormatter && tq.hasAggregators()) {
                try {
                    this.calculateTotals(tq, table, rs, formatter);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            List<ThinHierarchy> filterHierarchies = null;
            if (ThinQuery.Type.QUERYMODEL.equals((Object)tq.getType())) {
                filterHierarchies = tq.getQueryModel().getAxes().get((Object)ThinQueryModel.AxisLocation.FILTER).getHierarchies();
            }
            if (type.equalsIgnoreCase("xls")) {
                return ExcelExporter.exportExcel(table, formatter, filterHierarchies);
            }
            if (type.equalsIgnoreCase("csv")) {
                return CsvExporter.exportCsv(rs, SaikuProperties.webExportCsvDelimiter, SaikuProperties.webExportCsvTextEscape, formatter);
            }
        }
        return new byte[0];
    }

    public ResultSet drillthrough(String queryName, int maxrows, String returns) {
        OlapStatement stmt = null;
        try {
            ThinQuery query = this.context.get(queryName).getOlapQuery();
            OlapConnection con = this.olapDiscoverService.getNativeConnection(query.getCube().getConnection());
            stmt = con.createStatement();
            String mdx = query.getMdx();
            mdx = maxrows > 0 ? "DRILLTHROUGH MAXROWS " + maxrows + " " + mdx : "DRILLTHROUGH " + mdx;
            if (StringUtils.isNotBlank((String)returns)) {
                mdx = mdx + "\r\n RETURN " + returns;
            }
            ResultSet resultSet = stmt.executeQuery(mdx);
            return resultSet;
        }
        catch (SQLException e) {
            throw new SaikuServiceException("Error DRILLTHROUGH: " + queryName, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isMdxDrillthrough(ThinQuery query) {
        try {
            if (ThinQuery.Type.MDX.equals((Object)query.getType())) {
                SaikuCube cube = query.getCube();
                OlapConnection con = this.olapDiscoverService.getNativeConnection(cube.getConnection());
                return SaikuMondrianHelper.isMondrianDrillthrough((OlapConnection)con, (String)query.getMdx());
            }
        }
        catch (Error | Exception e) {
            log.warn("Error checking for DRILLTHROUGH: " + query.getName() + " DRILLTHROUGH MDX:" + query.getMdx(), e);
        }
        return false;
    }

    public ResultSet drillthrough(ThinQuery query) {
        OlapStatement stmt = null;
        try {
            SaikuCube cube = query.getCube();
            OlapConnection con = this.olapDiscoverService.getNativeConnection(cube.getConnection());
            stmt = con.createStatement();
            ResultSet resultSet = stmt.executeQuery(query.getMdx());
            return resultSet;
        }
        catch (SQLException e) {
            throw new SaikuServiceException("Error DRILLTHROUGH: " + query.getMdx() + " DRILLTHROUGH MDX:" + query.getMdx(), e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public DrillThroughResult drillthroughWithCaptions(String queryName, List<Integer> cellPosition, Integer maxrows, String returns) {
        int width;
        QueryContext queryContext = this.context.get(queryName);
        SaikuCube saikuCube = queryContext.getOlapQuery().getCube();
        List<SaikuMember> measures = this.olapDiscoverService.getMeasures(saikuCube);
        CellSet cs = queryContext.getOlapResult();
        ResultSet drillthrough = this.drillthrough(queryName, cellPosition, maxrows, returns);
        try {
            width = drillthrough.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        String[] simpleHeader = new String[width];
        AbstractBaseCell[][] cellHeaders = null;
        if (StringUtils.isBlank((String)returns)) {
            CellDataSet result = OlapResultSetUtil.cellSet2Matrix(cs, this.cff.forName(""));
            cellHeaders = result.getCellSetHeaders();
        } else {
            List<ResultInfo> results = DrillthroughUtils.extractResultInfo(returns);
            for (int i = 0; i < results.size(); ++i) {
                ResultInfo ri = results.get(i);
                if (ri instanceof MeasureResultInfo) {
                    simpleHeader[i] = DrillthroughUtils.findMeasure(measures, ((MeasureResultInfo)ri).getName()).getCaption();
                    continue;
                }
                if (!(ri instanceof DimensionResultInfo)) continue;
                DimensionResultInfo dri = (DimensionResultInfo)ri;
                List<SaikuHierarchy> hierarchies = this.olapDiscoverService.getDimension(saikuCube, dri.getDimension()).getHierarchies();
                SaikuHierarchy hierarchy = null;
                try {
                    hierarchy = DrillthroughUtils.findHierarchy(hierarchies, dri.getHierarchy());
                }
                catch (Exception e) {
                    hierarchy = DrillthroughUtils.findHierarchy(hierarchies, dri.getDimension() + "." + dri.getHierarchy());
                }
                SaikuLevel level = DrillthroughUtils.findLevel(hierarchy.getLevels(), dri.getLevel());
                simpleHeader[i] = level.getCaption();
            }
        }
        return new DrillThroughResult(drillthrough, simpleHeader, cellHeaders);
    }

    public ResultSet drillthrough(String queryName, List<Integer> cellPosition, Integer maxrows, String returns) {
        OlapStatement stmt = null;
        try {
            QueryContext queryContext = this.context.get(queryName);
            ThinQuery query = queryContext.getOlapQuery();
            CellSet cs = queryContext.getOlapResult();
            SaikuCube cube = query.getCube();
            OlapConnection con = this.olapDiscoverService.getNativeConnection(cube.getConnection());
            stmt = con.createStatement();
            SelectNode sn = new DefaultMdxParserImpl().parseSelect(query.getMdx());
            String select = null;
            StringBuilder buf = new StringBuilder();
            if (sn.getWithList() != null && sn.getWithList().size() > 0) {
                buf.append("WITH \n");
                StringWriter sw = new StringWriter();
                ParseTreeWriter ptw = new ParseTreeWriter((Writer)sw);
                PrintWriter pw = ptw.getPrintWriter();
                for (ParseTreeNode with : sn.getWithList()) {
                    with.unparse(ptw);
                    pw.println();
                }
                buf.append(sw.toString());
            }
            buf.append("SELECT (");
            for (int i = 0; i < cellPosition.size(); ++i) {
                List members = ((Position)((CellSetAxis)cs.getAxes().get(i)).getPositions().get(cellPosition.get(i))).getMembers();
                for (int k = 0; k < members.size(); ++k) {
                    Member m = (Member)members.get(k);
                    if (k > 0 || i > 0) {
                        buf.append(", ");
                    }
                    buf.append(m.getUniqueName());
                }
            }
            buf.append(") ON COLUMNS \r\n");
            buf.append("FROM [").append(cube.getName()).append("]\r\n");
            StringWriter writer = new StringWriter();
            sn.getFilterAxis().unparse(new ParseTreeWriter(new PrintWriter(writer)));
            if (StringUtils.isNotBlank((String)((Object)writer).toString())) {
                buf.append("WHERE ").append(((Object)writer).toString());
            }
            select = buf.toString();
            select = maxrows > 0 ? "DRILLTHROUGH MAXROWS " + maxrows + " " + select + "\r\n" : "DRILLTHROUGH " + select + "\r\n";
            if (StringUtils.isNotBlank((String)returns)) {
                select = select + "\r\n RETURN " + returns;
            }
            log.debug("Drill Through for query (" + queryName + ") : \r\n" + select);
            ResultSet resultSet = stmt.executeQuery(select);
            return resultSet;
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error DRILLTHROUGH: " + queryName, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public byte[] exportDrillthroughCsv(String queryName, int maxrows) {
        OlapStatement stmt = null;
        try {
            QueryContext queryContext = this.context.get(queryName);
            ThinQuery query = queryContext.getOlapQuery();
            OlapConnection con = this.olapDiscoverService.getNativeConnection(query.getCube().getConnection());
            stmt = con.createStatement();
            String mdx = query.getMdx();
            mdx = maxrows > 0 ? "DRILLTHROUGH MAXROWS " + maxrows + " " + mdx : "DRILLTHROUGH " + mdx;
            ResultSet rs = stmt.executeQuery(mdx);
            byte[] byArray = CsvExporter.exportCsv(rs);
            return byArray;
        }
        catch (SQLException e) {
            throw new SaikuServiceException("Error DRILLTHROUGH: " + queryName, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public byte[] exportResultSetCsv(ResultSet rs) {
        return CsvExporter.exportCsv(rs);
    }

    public byte[] exportResultSetCsv(ResultSet rs, String delimiter, String enclosing, boolean printHeader, List<KeyValue<String, String>> additionalColumns) {
        return CsvExporter.exportCsv(rs, delimiter, enclosing, printHeader, additionalColumns);
    }

    public List<SimpleCubeElement> getResultMetadataMembers(String queryName, boolean preferResult, String hierarchyName, String levelName, String searchString, int searchLimit) {
        if (this.context.containsKey(queryName)) {
            CellSet cs = this.context.get(queryName).getOlapResult();
            List<SimpleCubeElement> members = new ArrayList<SimpleCubeElement>();
            HashSet<Level> levels = new HashSet<Level>();
            boolean search = StringUtils.isNotBlank((String)searchString);
            preferResult = preferResult && !search;
            String string = searchString = search ? searchString.toLowerCase() : null;
            if (cs != null && preferResult) {
                block0: for (CellSetAxis axis : cs.getAxes()) {
                    int posIndex = 0;
                    for (Hierarchy h : axis.getAxisMetaData().getHierarchies()) {
                        if (h != null && (h.getUniqueName().equals(hierarchyName) || h.getName().equals(hierarchyName))) {
                            log.debug("Found hierarchy in the result: " + hierarchyName);
                            if (h.getLevels().size() == 1) continue block0;
                            HashSet<Member> mset = new HashSet<Member>();
                            for (Position pos : axis.getPositions()) {
                                Member m = (Member)pos.getMembers().get(posIndex);
                                if (!m.getLevel().getLevelType().equals((Object)Level.Type.ALL)) {
                                    levels.add(m.getLevel());
                                }
                                if (!m.getLevel().getUniqueName().equals(levelName) && !m.getLevel().getName().equals(levelName)) continue;
                                Member.Type t = m.getMemberType();
                                mset.add(m);
                            }
                            members = ObjectUtil.convert2Simple(mset);
                            Collections.sort(members, new SaikuUniqueNameComparator());
                            continue block0;
                        }
                        ++posIndex;
                    }
                }
                log.debug("Found members in the result: " + members.size());
            }
            if (cs == null || !preferResult || members.size() == 0 || levels.size() == 1) {
                members = this.olapDiscoverService.getLevelMembers(this.context.get(queryName).getOlapQuery().getCube(), hierarchyName, levelName, searchString, searchLimit);
            }
            return members;
        }
        return null;
    }

    private void calculateTotals(ThinQuery tq, CellDataSet result, CellSet cellSet, ICellSetFormatter formatter) throws Exception {
        if (ThinQuery.Type.QUERYMODEL.equals((Object)tq.getType()) && formatter instanceof FlattenedCellSetFormatter) {
            Cube cub = this.olapDiscoverService.getNativeCube(tq.getCube());
            Query query = Fat.convert(tq, cub);
            QueryDetails details = query.getDetails();
            Measure[] selectedMeasures = new Measure[details.getMeasures().size()];
            for (int i = 0; i < selectedMeasures.length; ++i) {
                selectedMeasures[i] = (Measure)details.getMeasures().get(i);
            }
            result.setSelectedMeasures(selectedMeasures);
            int rowsIndex = 0;
            if (!((CellSetAxis)cellSet.getAxes().get(0)).getAxisOrdinal().equals(Axis.ROWS)) {
                rowsIndex = rowsIndex + 1 & 1;
            }
            AxisInfo[] axisInfos = new AxisInfo[]{new AxisInfo((CellSetAxis)cellSet.getAxes().get(rowsIndex)), new AxisInfo((CellSetAxis)cellSet.getAxes().get(rowsIndex + 1 & 1))};
            List[][] totals = new List[2][];
            TotalsListsBuilder builder = null;
            for (int index = 0; index < 2; ++index) {
                int second = index + 1 & 1;
                TotalAggregator[] aggregators = new TotalAggregator[axisInfos[second].maxDepth + 1];
                for (int i = 1; i < aggregators.length - 1; ++i) {
                    List aggs = query.getAggregators(axisInfos[second].uniqueLevelNames.get(i - 1));
                    String totalFunctionName = aggs != null && aggs.size() > 0 ? (String)aggs.get(0) : null;
                    aggregators[i] = StringUtils.isNotBlank(totalFunctionName) ? TotalAggregator.newInstanceByFunctionName(totalFunctionName) : null;
                }
                List aggs = query.getAggregators(axisInfos[second].axis.getAxisOrdinal().name());
                String totalFunctionName = aggs != null && aggs.size() > 0 ? (String)aggs.get(0) : null;
                aggregators[0] = TotalAggregator.newInstanceByFunctionName(totalFunctionName);
                builder = new TotalsListsBuilder(selectedMeasures, aggregators, cellSet, axisInfos[index], axisInfos[second], tq);
                totals[index] = builder.buildTotalsLists();
            }
            result.setLeftOffset(axisInfos[0].maxDepth);
            result.setRowTotalsLists(totals[1]);
            result.setColTotalsLists(totals[0]);
        }
    }

    public ThinQuery zoomIn(String queryName, List<List<Integer>> realPositions) {
        try {
            if (this.context.containsKey(queryName)) {
                CellSet cs = this.context.get(queryName).getOlapResult();
                ThinQuery old = this.context.get(queryName).getOlapQuery();
                Cube cub = this.olapDiscoverService.getNativeCube(old.getCube());
                Query q = Fat.convert(old, cub);
                if (cs == null) {
                    throw new SaikuServiceException("Cannot zoom in if last cellset is null");
                }
                if (realPositions == null || realPositions.size() == 0) {
                    throw new SaikuServiceException("Cannot zoom in if zoom in position is empty");
                }
                HashMap memberSelection = new HashMap();
                for (List<Integer> position : realPositions) {
                    for (int k = 0; k < position.size(); ++k) {
                        Position p = (Position)((CellSetAxis)cs.getAxes().get(k)).getPositions().get(position.get(k));
                        List members = p.getMembers();
                        for (Member m : members) {
                            Hierarchy h = m.getHierarchy();
                            if (!memberSelection.containsKey(h)) {
                                HashSet mset = new HashSet();
                                memberSelection.put(h, mset);
                            }
                            ((Set)memberSelection.get(h)).add(m);
                        }
                    }
                }
                for (Hierarchy h : memberSelection.keySet()) {
                    QueryHierarchy qh = q.getHierarchy(h);
                    for (QueryLevel ql : qh.getActiveQueryLevels()) {
                        ql.getInclusions().clear();
                        ql.getExclusions().clear();
                        ql.setMdxSetExpression(null);
                    }
                    for (Member m : (Set)memberSelection.get(h)) {
                        qh.includeMember(m);
                    }
                }
                ThinQuery tqAfter = Thin.convert(q, old.getCube());
                q = null;
                return tqAfter;
            }
            throw new SaikuServiceException("Cannot get query result from context: " + queryName);
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error zoom in on query: " + queryName, e);
        }
    }

    public ThinQuery drillacross(String queryName, List<Integer> cellPosition, Map<String, List<String>> levels) {
        try {
            ThinQuery old = this.context.get(queryName).getOlapQuery();
            Cube cub = this.olapDiscoverService.getNativeCube(old.getCube());
            Query query = Fat.convert(old, cub);
            CellSet cs = this.context.get(queryName).getOlapResult();
            HashSet<Level> levelSet = new HashSet<Level>();
            if (cs == null) {
                throw new SaikuServiceException("Cannot drill across. Last CellSet empty");
            }
            for (int i = 0; i < cellPosition.size(); ++i) {
                List members = ((Position)((CellSetAxis)cs.getAxes().get(i)).getPositions().get(cellPosition.get(i))).getMembers();
                Iterator iterator = members.iterator();
                while (iterator.hasNext()) {
                    Member m = (Member)iterator.next();
                    QueryHierarchy qh = query.getHierarchy(m.getHierarchy());
                    if (qh.getHierarchy().getDimension().getName().equals("Measures")) {
                        Measure measure = query.getMeasure(m.getName());
                        boolean contains = false;
                        for (Measure existMeasure : query.getDetails().getMeasures()) {
                            if (!existMeasure.getUniqueName().equals(measure.getUniqueName())) continue;
                            contains = true;
                            break;
                        }
                        if (contains) continue;
                        query.getDetails().add(measure);
                        continue;
                    }
                    qh.clearSelection();
                    qh.clearFilters();
                    qh.clearSort();
                    query.moveHierarchy(qh, (Axis)Axis.FILTER);
                    qh.includeMember(m);
                    levelSet.add(m.getLevel());
                }
            }
            boolean clearedMeasures = false;
            if (levels != null) {
                for (String key : levels.keySet()) {
                    String dimensionName = key.split("###")[0];
                    if ("Measures".equals(dimensionName)) {
                        if (!clearedMeasures) {
                            query.getDetails().getMeasures().clear();
                            clearedMeasures = true;
                        }
                        for (String measureName : levels.get(key)) {
                            Measure measure = query.getMeasure(measureName);
                            if (measure != null) {
                                query.getDetails().add(measure);
                                continue;
                            }
                            for (Measure m : cub.getMeasures()) {
                                if (!m.getUniqueName().equals(measureName)) continue;
                                query.getDetails().add(m);
                            }
                        }
                        continue;
                    }
                    String hierarchyName = key.split("###")[1];
                    Dimension d = (Dimension)cub.getDimensions().get(dimensionName);
                    Hierarchy h = (Hierarchy)d.getHierarchies().get(hierarchyName);
                    QueryHierarchy qh = query.getHierarchy(h);
                    for (Level l : h.getLevels()) {
                        for (String levelU : levels.get(key)) {
                            if (!l.getUniqueName().equals(levelU) && !l.getName().equals(levelU)) continue;
                            qh.includeLevel(l);
                        }
                    }
                    if (qh.getActiveQueryLevels().size() <= 0) continue;
                    query.moveHierarchy(qh, (Axis)Axis.ROWS);
                }
            }
            if (query.getDetails().getMeasures().size() == 0) {
                QueryHierarchy qh = query.getHierarchy("Measures");
                Member defaultMeasure = qh.getHierarchy().getDefaultMember();
                query.getDetails().add(query.getMeasure(defaultMeasure.getName()));
            }
            return Thin.convert(query, old.getCube());
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error drilling across: " + queryName, e);
        }
    }

    public boolean isOldQuery(String xml) {
        return StringUtils.isNotBlank((String)xml) && xml.trim().startsWith("<?xml");
    }

    public ThinQuery convertQuery(String xml) throws Exception {
        if (StringUtils.isNotBlank((String)xml) && xml.trim().startsWith("<?xml")) {
            QueryDeserializer qd = new QueryDeserializer();
            SaikuCube scube = qd.getFakeCube(xml);
            OlapConnection con = this.olapDiscoverService.getNativeConnection(scube.getConnection());
            IQuery query = qd.unparse(xml, con);
            if (IQuery.QueryType.QM.equals((Object)query.getType())) {
                OlapQuery qr = (OlapQuery)query;
                Query sQ = QueryConverter.convertQuery(qr.getQuery());
                SaikuCube converted = ObjectUtil.convert(scube.getConnection(), sQ.getCube());
                return Thin.convert(sQ, converted);
            }
            SaikuCube converted = ObjectUtil.convert(scube.getConnection(), this.olapDiscoverService.getNativeCube(scube));
            return new ThinQuery(query.getName(), converted, query.getMdx());
        }
        return null;
    }
}

