/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.datasource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.saiku.database.dto.MondrianSchema;
import org.saiku.datasources.connection.IConnectionManager;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.repository.AclEntry;
import org.saiku.repository.IRepositoryObject;
import org.saiku.service.datasource.IDatasourceManager;
import org.saiku.service.util.exception.SaikuDataSourceException;
import org.saiku.service.util.exception.SaikuDataSourceNotFoundException;

public class DatasourceService
implements Serializable {
    private static final long serialVersionUID = -4407446633148181669L;
    private transient IDatasourceManager datasources;
    private IConnectionManager connectionManager;

    public void setConnectionManager(IConnectionManager ic) {
        this.connectionManager = ic;
        this.datasources = ic.getDataSourceManager();
    }

    public IConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void addDatasource(SaikuDatasource datasource, boolean overwrite, String[] roles) throws Exception {
        SaikuDatasource ds = this.getDatasources(roles).get(datasource.getName());
        if (ds == null) {
            this.datasources.addDatasource(datasource);
        } else if (overwrite) {
            this.datasources.removeDatasource(ds.getProperties().getProperty("id"));
            this.datasources.addDatasource(datasource);
        } else {
            throw new Exception("Datasource Name Already Exists!");
        }
    }

    public SaikuDatasource fetchDataSourceById(String id, String[] roles) throws SaikuDataSourceNotFoundException {
        SaikuDatasource saikuDatasource = null;
        Map<String, SaikuDatasource> datasources = this.getDatasources(roles);
        for (SaikuDatasource currentDatasource : datasources.values()) {
            if (!currentDatasource.getProperties().getProperty("id").equals(id)) continue;
            saikuDatasource = currentDatasource;
            break;
        }
        if (saikuDatasource == null) {
            throw new SaikuDataSourceException("Could not find data source with id: " + id);
        }
        return saikuDatasource;
    }

    public void setLocaleOfDataSource(SaikuDatasource dataSource, String newLocale) throws SaikuDataSourceException {
        String location = dataSource.getProperties().getProperty("location");
        String oldLocale = this.getOldLocale(location);
        String newLocation = location.replace(oldLocale, newLocale);
        dataSource.getProperties().setProperty("location", newLocation);
    }

    private String getOldLocale(String location) throws SaikuDataSourceException {
        String referenceText = "locale=";
        int start = location.toLowerCase().indexOf(referenceText);
        if (start == -1) {
            throw new SaikuDataSourceException("Could not find old locale because there is currently no locale defined in the data source");
        }
        int end = location.indexOf(";", start += referenceText.length());
        return location.substring(start, end);
    }

    public void setDatasource(SaikuDatasource datasource) throws Exception {
        this.datasources.setDatasource(datasource);
    }

    public void removeDatasource(String datasourceId) {
        this.datasources.removeDatasource(datasourceId);
    }

    public void removeSchema(String schemaId) {
        this.datasources.removeSchema(schemaId);
    }

    public SaikuDatasource getDatasource(String datasourceName) {
        return this.datasources.getDatasource(datasourceName);
    }

    public Map<String, SaikuDatasource> getDatasources(String[] roles) {
        return this.datasources.getDatasources(roles);
    }

    public List<MondrianSchema> getAvailableSchema() {
        return this.datasources.getMondrianSchema();
    }

    public void addSchema(String schema, String path, String name) throws Exception {
        this.datasources.addSchema(schema, path, name);
    }

    public String saveFile(String content, String path, String name, List<String> roles) {
        return this.datasources.saveFile(path, content, name, roles);
    }

    public String removeFile(String path, String name, List<String> roles) {
        return this.datasources.removeFile(path, name, roles);
    }

    public String moveFile(String source, String target, String name, List<String> roles) {
        return this.datasources.moveFile(source, target, name, roles);
    }

    public List<IRepositoryObject> getFiles(List<String> type, String username, List<String> roles) {
        return this.datasources.getFiles(type, username, roles);
    }

    public List<IRepositoryObject> getFiles(List<String> type, String username, List<String> roles, String path) {
        return this.datasources.getFiles(type, username, roles, path);
    }

    public String getFileData(String path, String username, List<String> roles) {
        return this.datasources.getFileData(path, username, roles);
    }

    public void importLegacySchema() {
    }

    public void importLegacyDatasources() {
    }

    public void importLegacyUsers() {
    }

    public void setResourceACL(String file, String acl, String username, List<String> roles) {
        this.datasources.setACL(file, acl, username, roles);
    }

    public AclEntry getResourceACL(String file, String username, List<String> roles) {
        return this.datasources.getACL(file, username, roles);
    }

    public byte[] exportRepository() {
        return this.datasources.exportRepository();
    }

    public void restoreRepository(byte[] data) {
        this.datasources.restoreRepository(data);
    }

    public void restoreLegacyFiles(byte[] data) {
        this.datasources.restoreLegacyFiles(data);
    }

    public boolean hasHomeDirectory(String name) {
        return this.datasources.hasHomeDirectory(name);
    }

    public void createUserHome(String user) {
        this.datasources.createUser(user);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.datasources = this.connectionManager.getDataSourceManager();
    }
}

