/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.discover;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mondrian.olap4j.SaikuMondrianHelper;
import mondrian.rolap.RolapConnection;
import org.apache.commons.lang.StringUtils;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDatabaseMetaData;
import org.olap4j.OlapException;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Database;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.Schema;
import org.saiku.datasources.connection.IConnectionManager;
import org.saiku.olap.dto.SaikuCatalog;
import org.saiku.olap.dto.SaikuConnection;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.dto.SaikuDimension;
import org.saiku.olap.dto.SaikuHierarchy;
import org.saiku.olap.dto.SaikuLevel;
import org.saiku.olap.dto.SaikuMember;
import org.saiku.olap.dto.SaikuSchema;
import org.saiku.olap.dto.SimpleCubeElement;
import org.saiku.olap.util.ObjectUtil;
import org.saiku.olap.util.SaikuCubeCaptionComparator;
import org.saiku.olap.util.SaikuDimensionCaptionComparator;
import org.saiku.olap.util.exception.SaikuOlapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlapMetaExplorer {
    private static final Logger log = LoggerFactory.getLogger(OlapMetaExplorer.class);
    private final IConnectionManager connections;

    public OlapMetaExplorer(IConnectionManager ic) {
        this.connections = ic;
    }

    public SaikuConnection getConnection(String connectionName) throws SaikuOlapException {
        OlapConnection olapcon = this.connections.getOlapConnection(connectionName);
        if (olapcon != null) {
            ArrayList<SaikuCatalog> catalogs = new ArrayList<SaikuCatalog>();
            try {
                for (Catalog cat : olapcon.getOlapCatalogs()) {
                    ArrayList<SaikuCube> cubes;
                    ArrayList<SaikuSchema> schemas = new ArrayList<SaikuSchema>();
                    for (Schema schem : cat.getSchemas()) {
                        cubes = new ArrayList<SaikuCube>();
                        for (Cube cub : schem.getCubes()) {
                            cubes.add(new SaikuCube(connectionName, cub.getUniqueName(), cub.getName(), cub.getCaption(), cat.getName(), schem.getName(), cub.isVisible()));
                        }
                        Collections.sort(cubes, new SaikuCubeCaptionComparator());
                        schemas.add(new SaikuSchema(schem.getName(), cubes));
                    }
                    if (schemas.size() == 0) {
                        OlapDatabaseMetaData olapDbMeta = olapcon.getMetaData();
                        ResultSet cubesResult = olapDbMeta.getCubes(cat.getName(), null, null);
                        try {
                            cubes = new ArrayList();
                            while (cubesResult.next()) {
                                cubes.add(new SaikuCube(connectionName, cubesResult.getString("CUBE_NAME"), cubesResult.getString("CUBE_NAME"), cubesResult.getString("CUBE_NAME"), cubesResult.getString("CATALOG_NAME"), cubesResult.getString("SCHEMA_NAME")));
                            }
                            Collections.sort(cubes, new SaikuCubeCaptionComparator());
                            schemas.add(new SaikuSchema("", cubes));
                        }
                        catch (SQLException e) {
                            throw new OlapException(e.getMessage(), (Throwable)e);
                        }
                        finally {
                            try {
                                cubesResult.close();
                            }
                            catch (SQLException e) {
                                log.error("Could not close cubesResult", (Throwable)e.getNextException());
                            }
                        }
                    }
                    Collections.sort(schemas);
                    catalogs.add(new SaikuCatalog(cat.getName(), schemas));
                }
            }
            catch (OlapException e) {
                throw new SaikuOlapException("Error getting objects of connection (" + connectionName + ")", e);
            }
            Collections.sort(catalogs);
            SaikuConnection connection = new SaikuConnection(connectionName, catalogs);
            return connection;
        }
        throw new SaikuOlapException("Cannot find connection: (" + connectionName + ")");
    }

    public List<SaikuConnection> getConnections(List<String> connectionNames) throws SaikuOlapException {
        ArrayList<SaikuConnection> connectionList = new ArrayList<SaikuConnection>();
        for (String connectionName : connectionNames) {
            connectionList.add(this.getConnection(connectionName));
        }
        return connectionList;
    }

    public List<SaikuConnection> getAllConnections() throws SaikuOlapException {
        ArrayList<SaikuConnection> cubesList = new ArrayList<SaikuConnection>();
        for (String connectionName : this.connections.getAllOlapConnections().keySet()) {
            cubesList.add(this.getConnection(connectionName));
        }
        Collections.sort(cubesList);
        return cubesList;
    }

    public List<SaikuCube> getCubes(String connectionName) throws SaikuOlapException {
        OlapConnection olapcon = this.connections.getOlapConnection(connectionName);
        ArrayList<SaikuCube> cubes = new ArrayList<SaikuCube>();
        if (olapcon != null) {
            try {
                for (Catalog cat : olapcon.getOlapCatalogs()) {
                    for (Schema schem : cat.getSchemas()) {
                        for (Cube cub : schem.getCubes()) {
                            cubes.add(new SaikuCube(connectionName, cub.getUniqueName(), cub.getName(), cub.getCaption(), cat.getName(), schem.getName(), cub.isVisible()));
                        }
                    }
                }
            }
            catch (OlapException e) {
                log.error("Olap Exception", e.getCause());
            }
        }
        Collections.sort(cubes, new SaikuCubeCaptionComparator());
        return cubes;
    }

    public List<SaikuCube> getCubes(List<String> connectionNames) throws SaikuOlapException {
        ArrayList<SaikuCube> cubesList = new ArrayList<SaikuCube>();
        for (String connectionName : connectionNames) {
            cubesList.addAll(this.getCubes(connectionName));
        }
        Collections.sort(cubesList, new SaikuCubeCaptionComparator());
        return cubesList;
    }

    public List<SaikuCube> getAllCubes() throws SaikuOlapException {
        ArrayList<SaikuCube> cubes = new ArrayList<SaikuCube>();
        for (String connectionName : this.connections.getAllOlapConnections().keySet()) {
            cubes.addAll(this.getCubes(connectionName));
        }
        Collections.sort(cubes, new SaikuCubeCaptionComparator());
        return cubes;
    }

    public Cube getNativeCube(SaikuCube cube) throws SaikuOlapException {
        try {
            OlapConnection con = this.connections.getOlapConnection(cube.getConnection());
            if (con != null) {
                for (Database db : con.getOlapDatabases()) {
                    Catalog cat = (Catalog)db.getCatalogs().get(cube.getCatalog());
                    if (cat == null) continue;
                    for (Schema schema : cat.getSchemas()) {
                        if ((!StringUtils.isBlank((String)cube.getSchema()) || !StringUtils.isBlank((String)schema.getName())) && !schema.getName().equals(cube.getSchema())) continue;
                        for (Cube cub : schema.getCubes()) {
                            if (!cub.getName().equals(cube.getName()) && !cub.getUniqueName().equals(cube.getName())) continue;
                            return cub;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SaikuOlapException("Cannot get native cube for ( " + cube + " )", e);
        }
        throw new SaikuOlapException("Cannot get native cube for ( " + cube + " )");
    }

    public OlapConnection getNativeConnection(String name) throws SaikuOlapException {
        try {
            OlapConnection con = this.connections.getOlapConnection(name);
            if (con != null) {
                return con;
            }
        }
        catch (Exception e) {
            throw new SaikuOlapException("Cannot get native connection for ( " + name + " )", e);
        }
        return null;
    }

    public List<SaikuDimension> getAllDimensions(SaikuCube cube) throws SaikuOlapException {
        Cube nativeCube = this.getNativeCube(cube);
        List<SaikuDimension> dimensions = ObjectUtil.convertDimensions((List<Dimension>)nativeCube.getDimensions());
        for (int i = 0; i < dimensions.size(); ++i) {
            SaikuDimension dim = dimensions.get(i);
            if (!dim.getName().equals("Measures") && !dim.getUniqueName().equals("[Measures]")) continue;
            dimensions.remove(i);
            break;
        }
        Collections.sort(dimensions, new SaikuDimensionCaptionComparator());
        return dimensions;
    }

    public SaikuDimension getDimension(SaikuCube cube, String dimensionName) throws SaikuOlapException {
        Cube nativeCube = this.getNativeCube(cube);
        Dimension dim = (Dimension)nativeCube.getDimensions().get(dimensionName);
        if (dim != null) {
            return ObjectUtil.convert(dim);
        }
        return null;
    }

    public List<SaikuHierarchy> getAllHierarchies(SaikuCube cube) throws SaikuOlapException {
        Cube nativeCube = this.getNativeCube(cube);
        return ObjectUtil.convertHierarchies((List<Hierarchy>)nativeCube.getHierarchies());
    }

    public SaikuHierarchy getHierarchy(SaikuCube cube, String hierarchyName) throws SaikuOlapException {
        Cube nativeCube = this.getNativeCube(cube);
        Hierarchy h = this.findHierarchy(hierarchyName, nativeCube);
        if (h != null) {
            return ObjectUtil.convert(h);
        }
        return null;
    }

    public List<SaikuMember> getHierarchyRootMembers(SaikuCube cube, String hierarchyName) throws SaikuOlapException {
        Cube nativeCube = this.getNativeCube(cube);
        List<SaikuMember> members = new ArrayList<SaikuMember>();
        Hierarchy h = this.findHierarchy(hierarchyName, nativeCube);
        if (h == null) {
            for (Hierarchy hlist : nativeCube.getHierarchies()) {
                if (!hlist.getUniqueName().equals(hierarchyName) && !hlist.getName().equals(hierarchyName)) continue;
                h = hlist;
            }
        }
        if (h != null) {
            try {
                members = ObjectUtil.convertMembers((Collection<Member>)h.getRootMembers());
            }
            catch (OlapException e) {
                throw new SaikuOlapException("Cannot retrieve root members of hierarchy: " + hierarchyName, e);
            }
        }
        return members;
    }

    public List<SaikuLevel> getAllLevels(SaikuCube cube, String dimension, String hierarchy) throws SaikuOlapException {
        Cube nativeCube = this.getNativeCube(cube);
        Dimension dim = (Dimension)nativeCube.getDimensions().get(dimension);
        if (dim != null) {
            Hierarchy h = (Hierarchy)dim.getHierarchies().get(hierarchy);
            if (h == null) {
                for (Hierarchy hlist : dim.getHierarchies()) {
                    if (!hlist.getUniqueName().equals(hierarchy) && !hlist.getName().equals(hierarchy)) continue;
                    h = hlist;
                }
            }
            if (h != null) {
                return ObjectUtil.convertLevels((List<Level>)h.getLevels());
            }
        }
        return new ArrayList<SaikuLevel>();
    }

    public List<SimpleCubeElement> getAllMembers(SaikuCube cube, String hierarchy, String level) throws SaikuOlapException {
        return this.getAllMembers(cube, hierarchy, level, null, -1);
    }

    public List<SimpleCubeElement> getAllMembers(SaikuCube cube, String hierarchy, String level, String searchString, int searchLimit) throws SaikuOlapException {
        try {
            Cube nativeCube = this.getNativeCube(cube);
            OlapConnection con = nativeCube.getSchema().getCatalog().getDatabase().getOlapConnection();
            Hierarchy h = this.findHierarchy(hierarchy, nativeCube);
            boolean search = StringUtils.isNotBlank((String)searchString);
            int found = 0;
            if (h != null) {
                List<SimpleCubeElement> simpleMembers;
                Level l = (Level)h.getLevels().get(level);
                if (l == null) {
                    for (Level lvl : h.getLevels()) {
                        if (!lvl.getUniqueName().equals(level) && !lvl.getName().equals(level)) continue;
                        l = lvl;
                        break;
                    }
                }
                if (l == null) {
                    throw new SaikuOlapException("Cannot find level " + level + " in hierarchy " + hierarchy + " of cube " + cube.getName());
                }
                if (this.isMondrian(nativeCube) && SaikuMondrianHelper.hasAnnotation((Level)l, (String)"SQLMemberLookup")) {
                    if (search) {
                        ResultSet rs = SaikuMondrianHelper.getSQLMemberLookup((OlapConnection)con, (String)"SQLMemberLookup", (Level)l, (String)searchString);
                        List<SimpleCubeElement> simpleMembers2 = ObjectUtil.convert2simple(rs);
                        log.debug("Found " + simpleMembers2.size() + " members using SQL lookup for level " + level);
                        return simpleMembers2;
                    }
                    return new ArrayList<SimpleCubeElement>();
                }
                if (search || searchLimit > 0) {
                    ArrayList<Member> foundMembers = new ArrayList<Member>();
                    List lokuplist = SaikuMondrianHelper.isMondrianConnection((OlapConnection)con) && SaikuMondrianHelper.getMondrianServer((OlapConnection)con).getVersion().getMajorVersion() >= 4 ? SaikuMondrianHelper.getMDXMemberLookup((OlapConnection)con, (String)cube.getName(), (Level)l) : l.getMembers();
                    for (Member m : lokuplist) {
                        if (search) {
                            if (m.getName().toLowerCase().contains(searchString) || m.getCaption().toLowerCase().contains(searchString)) {
                                foundMembers.add(m);
                                ++found;
                            }
                        } else {
                            foundMembers.add(m);
                            ++found;
                        }
                        if (searchLimit <= 0 || found < searchLimit) continue;
                        break;
                    }
                    simpleMembers = ObjectUtil.convert2Simple(foundMembers);
                } else {
                    List lookuplist = null;
                    lookuplist = SaikuMondrianHelper.isMondrianConnection((OlapConnection)con) && SaikuMondrianHelper.getMondrianServer((OlapConnection)con).getVersion().getMajorVersion() >= 4 ? SaikuMondrianHelper.getMDXMemberLookup((OlapConnection)con, (String)cube.getName(), (Level)l) : l.getMembers();
                    simpleMembers = ObjectUtil.convert2Simple(lookuplist);
                }
                return simpleMembers;
            }
        }
        catch (Exception e) {
            throw new SaikuOlapException("Cannot get all members", e);
        }
        return new ArrayList<SimpleCubeElement>();
    }

    public List<SaikuMember> getMemberChildren(SaikuCube cube, String uniqueMemberName) throws SaikuOlapException {
        ArrayList<SaikuMember> members = new ArrayList<SaikuMember>();
        try {
            Cube nativeCube = this.getNativeCube(cube);
            List memberList = IdentifierNode.parseIdentifier((String)uniqueMemberName).getSegmentList();
            Member m = nativeCube.lookupMember(memberList);
            if (m != null) {
                for (Member c : m.getChildMembers()) {
                    SaikuMember sm = ObjectUtil.convert(c);
                    members.add(sm);
                }
            }
        }
        catch (OlapException e) {
            throw new SaikuOlapException("Cannot get child members of member:" + uniqueMemberName, e);
        }
        return members;
    }

    public List<SaikuMember> getAllMeasures(SaikuCube cube) throws SaikuOlapException {
        List<SaikuMember> measures = new ArrayList<SaikuMember>();
        try {
            Cube nativeCube = this.getNativeCube(cube);
            for (Measure measure : nativeCube.getMeasures()) {
                if (!measure.isVisible()) continue;
                measures.add(ObjectUtil.convertMeasure(measure));
            }
            if (measures.size() == 0) {
                Hierarchy hierarchy = ((Dimension)nativeCube.getDimensions().get("Measures")).getDefaultHierarchy();
                measures = ObjectUtil.convertMembers((Collection<Member>)hierarchy.getRootMembers());
            }
        }
        catch (OlapException e) {
            throw new SaikuOlapException("Cannot get measures for cube:" + cube.getName(), e);
        }
        return measures;
    }

    public SaikuMember getMember(SaikuCube cube, String uniqueMemberName) throws SaikuOlapException {
        try {
            Cube nativeCube = this.getNativeCube(cube);
            Member m = nativeCube.lookupMember(IdentifierNode.parseIdentifier((String)uniqueMemberName).getSegmentList());
            if (m != null) {
                return ObjectUtil.convert(m);
            }
            return null;
        }
        catch (Exception e) {
            throw new SaikuOlapException("Cannot find member: " + uniqueMemberName + " in cube:" + cube.getName(), e);
        }
    }

    private boolean isMondrian(Cube cube) {
        OlapConnection con = cube.getSchema().getCatalog().getDatabase().getOlapConnection();
        try {
            return con.isWrapperFor(RolapConnection.class);
        }
        catch (SQLException e) {
            log.error("SQLException", (Throwable)e.getNextException());
            return false;
        }
    }

    private Hierarchy findHierarchy(String name, Cube cube) {
        Hierarchy h = (Hierarchy)cube.getHierarchies().get(name);
        if (h != null) {
            return h;
        }
        for (Hierarchy hierarchy : cube.getHierarchies()) {
            if (!hierarchy.getUniqueName().equals(name)) continue;
            return hierarchy;
        }
        return null;
    }
}

