/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.LiteralNode;
import org.olap4j.mdx.MemberNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.PropertyValueNode;
import org.olap4j.mdx.Syntax;
import org.olap4j.mdx.WithMemberNode;
import org.olap4j.mdx.parser.impl.DefaultMdxParserImpl;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.saiku.query.metadata.Calculated;

public class NodeConverter {
    protected static CallNode generateSetCall(ParseTreeNode ... args) {
        return new CallNode(null, "{}", Syntax.Braces, args);
    }

    protected static CallNode generateListSetCall(List<ParseTreeNode> cnodes) {
        return new CallNode(null, "{}", Syntax.Braces, cnodes);
    }

    protected static CallNode generateListTupleCall(List<ParseTreeNode> cnodes) {
        return new CallNode(null, "()", Syntax.Parentheses, cnodes);
    }

    protected static CallNode generateCrossJoin(List<ParseTreeNode> selections) {
        return NodeConverter.generateCrossJoin(selections, false, true);
    }

    protected static CallNode generateCrossJoin(List<ParseTreeNode> selections, boolean nonEmpty, boolean asterisk) {
        String crossJoinFun;
        String string = crossJoinFun = nonEmpty ? "NonEmptyCrossJoin" : "CrossJoin";
        if (selections == null || selections.size() == 0) {
            return null;
        }
        ParseTreeNode sel1 = selections.get(0);
        if (sel1 instanceof MemberNode) {
            sel1 = NodeConverter.generateSetCall(sel1);
        }
        if (selections.size() == 2) {
            ParseTreeNode sel2 = selections.get(1);
            if (sel2 instanceof MemberNode) {
                sel2 = NodeConverter.generateSetCall(sel2);
            }
            return new CallNode(null, crossJoinFun, Syntax.Function, new ParseTreeNode[]{sel1, sel2});
        }
        if (asterisk) {
            return new CallNode(null, " * ", Syntax.Infix, selections);
        }
        selections.remove(0);
        return new CallNode(null, crossJoinFun, Syntax.Function, new ParseTreeNode[]{sel1, NodeConverter.generateCrossJoin(selections, nonEmpty, asterisk)});
    }

    protected static CallNode generateUnion(List<List<ParseTreeNode>> unions) {
        if (unions.size() > 2) {
            List<ParseTreeNode> first = unions.remove(0);
            return new CallNode(null, "Union", Syntax.Function, new ParseTreeNode[]{NodeConverter.generateCrossJoin(first), NodeConverter.generateUnion(unions)});
        }
        return new CallNode(null, "Union", Syntax.Function, new ParseTreeNode[]{NodeConverter.generateCrossJoin(unions.get(0)), NodeConverter.generateCrossJoin(unions.get(1))});
    }

    protected static CallNode generateHierarchizeUnion(List<List<ParseTreeNode>> unions) {
        return new CallNode(null, "Hierarchize", Syntax.Function, new ParseTreeNode[]{NodeConverter.generateUnion(unions)});
    }

    protected static ParseTreeNode toOlap4jMemberSet(List<Member> members) {
        ArrayList<ParseTreeNode> membernodes = new ArrayList<ParseTreeNode>();
        for (Member m : members) {
            membernodes.add((ParseTreeNode)new MemberNode(null, m));
        }
        return NodeConverter.generateListSetCall(membernodes);
    }

    protected static ParseTreeNode toOlap4jMeasureSet(List<Measure> measures) {
        ArrayList<ParseTreeNode> membernodes = new ArrayList<ParseTreeNode>();
        for (Measure m : measures) {
            membernodes.add((ParseTreeNode)new MemberNode(null, (Member)m));
        }
        return NodeConverter.generateListSetCall(membernodes);
    }

    protected static WithMemberNode toOlap4jCalculatedMember(Calculated cm) {
        DefaultMdxParserImpl parser = new DefaultMdxParserImpl();
        ParseTreeNode formula = parser.parseExpression(cm.getFormula());
        ArrayList<PropertyValueNode> propertyList = new ArrayList<PropertyValueNode>();
        for (Map.Entry<String, String> entry : cm.getFormatProperties().entrySet()) {
            LiteralNode exp = LiteralNode.createString(null, (String)entry.getValue());
            String name = entry.getKey();
            PropertyValueNode prop = new PropertyValueNode(null, name, (ParseTreeNode)exp);
            propertyList.add(prop);
        }
        WithMemberNode wm = new WithMemberNode(null, IdentifierNode.parseIdentifier((String)cm.getUniqueName()), formula, propertyList);
        return wm;
    }

    protected static IdentifierNode getIdentifier(String ... identifiers) {
        String identifier = "";
        for (int i = 0; i < identifiers.length; ++i) {
            identifier = i == 0 ? "~" + identifiers[0] : identifier + "_" + identifiers[i];
        }
        return IdentifierNode.ofNames((String[])new String[]{identifier});
    }
}

