/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.common.DefaultMessageContext;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.common.ErrorMessage;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ObjectContextParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PropertiesParser;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FeldParser
extends SubParser
implements SuperParser {
    private MetaCustomTBFeld currentFeld = null;
    private ParserChain parserChain = new ParserChain();
    private PropertiesParser propertiesParser;
    private ObjectContextParser objectContextParser;

    public FeldParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.propertiesParser = new PropertiesParser(this, resolver);
        this.parserChain.addParser(this.propertiesParser);
        this.objectContextParser = new ObjectContextParser(this, resolver);
        this.parserChain.addParser(this.objectContextParser);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "field".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("field".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentFeld = new MetaCustomTBFeld();
            this.propertiesParser.setCurrentElement(this.currentFeld);
            this.objectContextParser.setCurrentElement(this.currentFeld);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("field".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentFeld;
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("field".equalsIgnoreCase(localName)) {
            String freiwilligeFrage;
            String state;
            String multi_auswahl;
            String merkmalFeldType;
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("F\u00fcr das Feld ist kein Name definiert!");
            }
            this.currentFeld.setName(name.trim());
            String str = atts.getValue("id");
            if (str != null && str.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentFeld.setId(str.trim());
            } else {
                this.currentFeld.setId(name);
            }
            String type = atts.getValue("type");
            if (type == null) {
                throw new ILParseException("F\u00fcr das Feld " + name + " ist kein Typ definiert!");
            }
            if (type.equals("statisticVariable")) {
                this.currentFeld.setArt((short)2);
            } else if (type.equals("topic")) {
                this.currentFeld.setArt((short)1);
            } else {
                throw new ILParseException("Der Typ '" + type + "' des Feldes " + name + " ist ung\u00fcltig!");
            }
            String clazz = atts.getValue("class");
            String clazz_id = atts.getValue("class-id");
            String key = null;
            if (clazz_id != null && clazz_id.length() > 0 && this.resolver().isUseIDasRef()) {
                key = clazz_id;
            } else if (clazz != null && clazz.length() > 0) {
                key = clazz;
            }
            if (key != null) {
                if (this.currentFeld.getArt() == 2) {
                    this.resolver().registerForResolve(this.currentFeld, key, clazz, MetaCustomMerkmal.class);
                } else {
                    this.resolver().registerForResolve(this.currentFeld, key, clazz, MetaCustomThemenbereich.class);
                }
            } else if (this.superParser() != null && this.superParser().getParserKontext() != null && this.superParser().getParserKontext().isTbFelderMuessenReferenzHaben()) {
                String kontext = "Themenbereich ";
                this.superParser().error(new ErrorMessage(new DefaultMessageContext(this.getKontextPath()), "TB-Feld '" + name + "' referenziert kein Merkmal oder Themenbereich.", -1, -1));
            }
            String dimensions = atts.getValue("dimensions");
            if (dimensions != null) {
                this.currentFeld.setListe(true);
                this.currentFeld.setDimensionLaenge(dimensions);
                this.currentFeld.setDimensions(Helper.parseDimensionSpec(dimensions.trim()));
            }
            if ((merkmalFeldType = atts.getValue("statistic-variable-type")) != null) {
                // empty if block
            }
            if ((multi_auswahl = atts.getValue("multi-auswahl")) != null && multi_auswahl.trim().equals("1")) {
                this.currentFeld.setListe(true);
                this.currentFeld.setMehrfachantworten(true);
            }
            if ((state = atts.getValue("state")) != null && state.trim().equals("approved")) {
                this.currentFeld.setFreigabeStatus((short)1);
            }
            if ((freiwilligeFrage = atts.getValue("voluntary-question")) != null && freiwilligeFrage.trim().equals("1")) {
                this.currentFeld.setFreiwilligeFrage(true);
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if (!"code".equalsIgnoreCase(localName)) {
            if ("displayName".equalsIgnoreCase(localName)) {
                this.currentFeld.setBezeichnung(chars);
                if (this.superParser().getParserKontext().getVersion() < 3.6) {
                    this.currentFeld.setTooltip(chars);
                }
            } else if ("tooltip".equalsIgnoreCase(localName)) {
                this.currentFeld.setTooltip(chars);
            } else if ("explanations".equalsIgnoreCase(localName)) {
                this.currentFeld.setErlaeuterungen(chars);
            } else if ("instruction".equalsIgnoreCase(localName)) {
                this.currentFeld.setRegieanweisung(chars);
            } else if ("infolink".equalsIgnoreCase(localName)) {
                this.currentFeld.setInfolink(chars);
            } else if ("infotext".equalsIgnoreCase(localName)) {
                this.currentFeld.setInfotext(chars);
            } else if ("errorShort".equalsIgnoreCase(localName)) {
                this.currentFeld.setFehlertextKurz(chars);
                this.currentFeld.setFehlerTextKurzProgram(Helper.getFehlerTextAlsMetaProgram(chars, this.getMessageContext("(Fehlertext kurz)")));
            } else if ("errorLong".equalsIgnoreCase(localName)) {
                this.currentFeld.setFehlertextLang(chars);
                this.currentFeld.setFehlerTextLangProgram(Helper.getFehlerTextAlsMetaProgram(chars, this.getMessageContext("(Fehlertext lang)")));
            } else if ("correctionDescription".equalsIgnoreCase(localName)) {
                this.currentFeld.setKorrekturhinweis(chars);
                this.currentFeld.setKorrekturhinweisProgram(Helper.getFehlerTextAlsMetaProgram(chars, this.getMessageContext("(Korrekturhinweis)")));
            } else if ("shortName".equalsIgnoreCase(localName)) {
                this.currentFeld.setKurzbezeichnung(chars);
            } else {
                handled = false;
            }
        }
        return handled;
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        return "code".equalsIgnoreCase(tag) || "displayName".equalsIgnoreCase(tag) || "tooltip".equalsIgnoreCase(tag) || "explanations".equalsIgnoreCase(tag) || "instruction".equalsIgnoreCase(tag) || "infolink".equalsIgnoreCase(tag) || "infotext".equalsIgnoreCase(tag) || "errorShort".equalsIgnoreCase(tag) || "errorLong".equalsIgnoreCase(tag) || "correctionDescription".equalsIgnoreCase(tag) || "shortName".equalsIgnoreCase(tag);
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }

    private MessageContextInterface getMessageContext(String hint) {
        return new ElementMessageContext(8, this.currentFeld.getId(), this.currentFeld.getName(), hint);
    }
}

