/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2.ui;

import de.statspez.pleditor.generator.compare2.ComparedNode;
import de.statspez.pleditor.generator.compare2.ui.ComboBoxValue;
import de.statspez.pleditor.generator.compare2.ui.TreeTable;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.StringValue;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.util.ArrayList;
import java.util.List;

public class MultipleFieldUtil {
    public static final String MULTIPLE_SEPARATOR = " ";

    public static boolean isDifferent(String str1, String str2) {
        boolean result = str1 != null && str2 != null ? !str1.equals(str2) : str1 != null || str2 != null;
        return result;
    }

    public static Long calculateMaxLengthForMultipleString(ComparedNode node) {
        Long missingValueMaxLength = 0L;
        Long multipleValueMaxLength = 0L;
        MetaAuspraegungsgruppe classifications = node.getClassifications();
        List<ComboBoxValue> auspraegungen = TreeTable.getComboBoxValues(classifications, false);
        for (ComboBoxValue tmp : auspraegungen) {
            if (multipleValueMaxLength > 0L) {
                multipleValueMaxLength = multipleValueMaxLength + (long)MULTIPLE_SEPARATOR.length();
            }
            multipleValueMaxLength = multipleValueMaxLength + (long)((StringValue)tmp.getValue()).asString().length();
        }
        MetaCustomTBFeld tbfield = node.getMetaTBFeld();
        MetaAuspraegungsgruppe missingValuesApg = ((MetaMerkmal)tbfield.getKlasse()).getKlasseFehlwerte();
        if (missingValuesApg != null) {
            List<ComboBoxValue> items = TreeTable.getComboBoxValues(missingValuesApg, false);
            for (ComboBoxValue item : items) {
                int tmpLength = ((StringValue)item.getValue()).asString().length();
                if ((long)tmpLength <= missingValueMaxLength) continue;
                missingValueMaxLength = new Long(tmpLength);
            }
        }
        return missingValueMaxLength > multipleValueMaxLength ? missingValueMaxLength : multipleValueMaxLength;
    }

    public static String[] getSavedValues(FeldDeskriptorImpl feldDeskriptor, Integer dim, SatzInterface satz) {
        int[] indizesOrig = feldDeskriptor.getIndizes();
        String[] result = new String[dim.intValue()];
        for (int index = 0; index < dim; ++index) {
            String value;
            feldDeskriptor.setIndizes(new int[]{index});
            result[index] = value = feldDeskriptor.getValueFrom(satz, true).asString();
        }
        feldDeskriptor.setIndizes(indizesOrig);
        return result;
    }

    public static String getSavedValuesAsString(String[] savedValues) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; savedValues != null && i < savedValues.length; ++i) {
            String tmp = savedValues[i];
            if (tmp == null) continue;
            if (buf.length() > 0) {
                buf.append(MULTIPLE_SEPARATOR);
            }
            buf.append(tmp);
        }
        return buf.toString();
    }

    public static boolean setValues(String[] valuesToSet, String[] savedValues, SatzInterface dataset, List<ComboBoxValue> valueItems, List<ComboBoxValue> missingValueItems, FeldDeskriptorImpl feldDeskriptor, Integer dimension) {
        List<String> newValues;
        if (valuesToSet == null) {
            throw new IllegalArgumentException("Werte nicht angegeben");
        }
        String missingValue = null;
        if (missingValueItems != null) {
            for (String tmp : valuesToSet) {
                if (!MultipleFieldUtil.isFehlwert(tmp, missingValueItems)) continue;
                missingValue = tmp;
                break;
            }
        }
        if (missingValue != null) {
            newValues = new ArrayList<String>(valuesToSet.length);
            newValues.add(missingValue);
        } else {
            newValues = MultipleFieldUtil.doSortValuesAndGetAsList(valuesToSet, valueItems);
        }
        while (newValues.size() < dimension) {
            newValues.add(InvalidValue.instance().asString());
        }
        return MultipleFieldUtil.setValues(newValues.toArray(new String[valuesToSet.length]), savedValues, dataset, feldDeskriptor);
    }

    public static void setEmptyValues(SatzInterface dataset, FeldDeskriptorImpl feldDeskriptor, Integer dim) {
        int[] indizesOrig = feldDeskriptor.getIndizes();
        int index = 0;
        while (index < dim) {
            feldDeskriptor.setIndizes(new int[]{index++});
            feldDeskriptor.setValueWith(dataset, InvalidValue.instance());
        }
        feldDeskriptor.setIndizes(indizesOrig);
    }

    private static boolean isFehlwert(String value, List<ComboBoxValue> klasseFehlwerteItems) {
        boolean result = false;
        if (klasseFehlwerteItems != null) {
            for (ComboBoxValue item : klasseFehlwerteItems) {
                if (!(item.getValue() instanceof StringValue) || !((StringValue)item.getValue()).toString().equals(value)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static List<String> doSortValuesAndGetAsList(String[] valuesToSet, List<ComboBoxValue> klasseWertebereichItems) {
        ArrayList<String> valuesToSetAsList = new ArrayList<String>(valuesToSet.length);
        for (String tmp : valuesToSet) {
            if (valuesToSetAsList.contains(tmp)) continue;
            valuesToSetAsList.add(tmp);
        }
        ArrayList<String> result = new ArrayList<String>(valuesToSet.length);
        for (ComboBoxValue klasseWertebereichItem : klasseWertebereichItems) {
            String code;
            Object obj = klasseWertebereichItem.getValue();
            if (!(obj instanceof StringValue) || !valuesToSetAsList.contains(code = ((StringValue)obj).asString())) continue;
            result.add(code);
            valuesToSetAsList.remove(code);
        }
        while (result.size() < valuesToSet.length && valuesToSetAsList.size() > 0) {
            String notCorrectValue = (String)valuesToSetAsList.remove(0);
            result.add(notCorrectValue);
        }
        return result;
    }

    private static boolean setValues(String[] newValues, String[] savedValues, SatzInterface dataset, FeldDeskriptorImpl feldDeskriptor) {
        boolean setToDataset = false;
        if (savedValues == null) {
            setToDataset = true;
        } else {
            for (int i = 0; i < savedValues.length; ++i) {
                String str1 = savedValues[i];
                String str2 = newValues[i];
                if (!MultipleFieldUtil.isDifferent(str1, str2)) continue;
                setToDataset = true;
                break;
            }
        }
        if (setToDataset) {
            for (int index = 0; index < newValues.length; ++index) {
                feldDeskriptor.setIndizes(new int[]{index});
                if (newValues[index] == null) {
                    feldDeskriptor.setValueWith(dataset, InvalidValue.instance());
                    continue;
                }
                feldDeskriptor.setValueWith(dataset, ValueFactory.instance().valueFor(newValues[index]), true);
            }
        }
        return setToDataset;
    }
}

