/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import de.statspez.pleditor.generator.compare2.CompareResult;
import de.statspez.pleditor.generator.compare2.ComparedNode;
import de.statspez.pleditor.generator.compare2.pdf.ITextElementGenerator;
import de.statspez.pleditor.generator.compare2.pdf.ITextUtil;
import de.statspez.pleditor.generator.compare2.pdf.PdfConfig;
import de.statspez.pleditor.generator.compare2.pdf.PdfContext;
import de.statspez.pleditor.generator.compare2.pdf.PdfEventHelper;
import de.statspez.pleditor.generator.compare2.pdf.TableOfContents;
import de.statspez.pleditor.generator.compare2.ui.CompareEditor;
import de.statspez.pleditor.generator.compare2.ui.TreeColorRenderer;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;

public class PdfGenerator
extends ITextElementGenerator {
    private static URL TOPIC_ICON = TreeColorRenderer.class.getResource("/de/statspez/pleditor/generator/images/themenbereich.gif");
    private static URL TOPICFIELD_ICON = TreeColorRenderer.class.getResource("/de/statspez/pleditor/generator/images/subthemenbereich.gif");
    private static URL FEATURE_ICON = TreeColorRenderer.class.getResource("/de/statspez/pleditor/generator/images/tbfeld.gif");
    private static final Color COLOR_DIFFERENCES = CompareEditor.COLOR_DIFFERENCES;
    private static final float levelPadding = 10.0f;
    private PdfContext pdfKontext;
    private PdfConfig pdfConfig;
    private TableOfContents tableOfContents;

    public void generate(OutputStream out, CompareResult compareResult, String[] columnNamen, PdfConfig pdfConfig) {
        this.pdfKontext = new PdfContext();
        this.pdfConfig = pdfConfig;
        try {
            PdfEventHelper pdfEventHelper = new PdfEventHelper(this.pdfKontext, this.pdfConfig);
            OutputStream outputStream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            };
            this.pdfKontext.setInitRun(true);
            this.generatePdf(pdfEventHelper, outputStream, this.pdfKontext, compareResult, columnNamen);
            this.pdfKontext.setInitRun(false);
            this.generatePdf(pdfEventHelper, out, this.pdfKontext, compareResult, columnNamen);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private void generatePdf(PdfEventHelper pdfEventHelper, OutputStream outputStream, PdfContext genKontext, CompareResult compareResult, String[] columnNamen) throws DocumentException {
        int count;
        float marginBottom;
        float marginTop;
        float marginRight;
        float marginLeft;
        Rectangle pageSize;
        if (this.pdfConfig.isGenerateToc() && genKontext.isInitRun()) {
            this.tableOfContents = new TableOfContents("_dummy_", "0");
        }
        if (this.pdfConfig.isPortraitPageFormat()) {
            pageSize = PageSize.A4;
            marginLeft = this.getMarginLeft();
            marginRight = this.getMarginRight();
            marginTop = this.getMarginTop();
            marginBottom = this.getMarginBottom();
        } else {
            pageSize = PageSize.A4.rotate();
            marginLeft = this.getMarginBottom();
            marginRight = this.getMarginTop();
            marginTop = this.getMarginLeft();
            marginBottom = this.getMarginRight();
        }
        this.setDocument(new Document(pageSize, marginLeft, marginRight, marginTop, marginBottom));
        PdfWriter writer = PdfWriter.getInstance((Document)this.document, (OutputStream)outputStream);
        writer.setPageEvent((PdfPageEvent)pdfEventHelper);
        ITextUtil.passeSeitenraenderAn(this.document, this.pdfConfig, genKontext, this.getMarginLeft(), this.getMarginRight(), this.getMarginTop(), this.getMarginBottom());
        this.document.open();
        if (this.pdfConfig.getTitel() != null && this.pdfConfig.getTitel().trim().length() > 0) {
            this.document.add((Element)this.createTableTitle(genKontext));
        }
        if (this.pdfConfig.isGenerateToc()) {
            this.document.add((Element)this.createTableOfContents());
            this.document.newPage();
        }
        String text = (count = compareResult.getDifferingCount(compareResult.getRootNode())) == 0 ? "Kein Unterschied" : count + " Unterschied" + (count > 1 ? "e" : "");
        Paragraph p = this.printValue(text);
        p.setSpacingAfter(5.0f);
        this.document.add((Element)p);
        PdfPTable pdfPTable = this.printCompareResult(compareResult, columnNamen, this.tableOfContents);
        this.document.add((Element)pdfPTable);
        this.document.close();
    }

    private PdfPTable createTableOfContents() throws DocumentException {
        PdfPTable table = new PdfPTable(2);
        table.setSpacingBefore(30.0f);
        table.setWidthPercentage(100.0f);
        table.setWidths(new float[]{0.95f, 0.05f});
        Iterator it = this.tableOfContents.getElementIterator();
        int zeile = 0;
        while (it.hasNext()) {
            TableOfContents subItem = (TableOfContents)it.next();
            zeile = this.addElementToTableOfContents(table, subItem, 0, zeile);
        }
        return table;
    }

    private int addElementToTableOfContents(PdfPTable table, TableOfContents item, int stufe, int zeileNr) throws DocumentException {
        Chunk title = this.createChunk(item.getTitel(), this.pdfConfig.getTocFont(), Color.black, null, 0, false);
        title.setLocalGoto(item.getLocalGoto());
        PdfPCell cell_1 = this.createPdfPCellForTOC((Element)title, stufe);
        Chunk seitenNr = this.createChunk(item.getSite(), this.pdfConfig.getTocFont(), Color.black, null, 0, false);
        PdfPCell cell_2 = this.createPdfPCellForTOC((Element)seitenNr, 0);
        table.addCell(cell_1);
        table.addCell(cell_2);
        ++zeileNr;
        Iterator it = item.getElementIterator();
        while (it.hasNext()) {
            TableOfContents subItem = (TableOfContents)it.next();
            zeileNr = this.addElementToTableOfContents(table, subItem, stufe + 1, zeileNr++);
        }
        return zeileNr;
    }

    private PdfPCell createPdfPCellForTOC(Element element, int level) {
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        cell.setPaddingLeft((float)level * 10.0f);
        cell.setVerticalAlignment(6);
        cell.setHorizontalAlignment(0);
        cell.addElement(element);
        return cell;
    }

    private PdfPTable printCompareResult(CompareResult compareResult, String[] columnNamen, TableOfContents tableOfContents) {
        int columnCount = 2;
        if (compareResult.getRootNode().getVergleichssaetze() != null) {
            columnCount += compareResult.getRootNode().getVergleichssaetze().size();
        }
        float[] relativeWidths = new float[columnCount];
        for (int col = 0; col < columnCount; ++col) {
            relativeWidths[col] = col == 0 ? 1.0f / (float)(columnCount + 1) * 2.0f : (1.0f - relativeWidths[0]) / (float)(columnCount - 1);
        }
        PdfPTable pdfPTable = new PdfPTable(relativeWidths);
        pdfPTable.setSpacingBefore(0.0f);
        pdfPTable.setSpacingAfter(0.0f);
        pdfPTable.setWidthPercentage(100.0f);
        pdfPTable.setHorizontalAlignment(1);
        pdfPTable.setSpacingBefore(0.0f);
        pdfPTable.setSpacingAfter(0.0f);
        pdfPTable.setHeaderRows(0);
        pdfPTable.setTotalWidth(this.document.right() - this.document.leftMargin());
        for (int col = 0; col < columnCount; ++col) {
            PdfPCell cell = this.initHeaderPdfPCell(col == 0, col == columnCount - 1);
            cell.addElement((Element)this.printHeaderValue(columnNamen[col]));
            pdfPTable.addCell(cell);
        }
        this.printComparedNode(compareResult.getRootNode(), pdfPTable, 0);
        return pdfPTable;
    }

    private void printComparedNode(ComparedNode comparedNode, PdfPTable pdfPTable, int level) {
        Color bg = comparedNode.hasDifferentValues() ? COLOR_DIFFERENCES : null;
        PdfPCell cell = this.initPdfPCell(true, bg);
        cell.addElement((Element)this.printStructurValue(comparedNode));
        cell.setPaddingLeft((float)level * 10.0f);
        pdfPTable.addCell(cell);
        String text = comparedNode.getDisplayvalueOfHauptsatz();
        cell = this.initPdfPCell(false, bg);
        cell.addElement((Element)this.printValue(text));
        pdfPTable.addCell(cell);
        int vergleichssatzCount = comparedNode.getVergleichssaetze() != null ? comparedNode.getVergleichssaetze().size() : 0;
        for (int i = 0; i < vergleichssatzCount; ++i) {
            text = comparedNode.getDisplayvalueOfVergleichssatz(i + 1);
            cell = this.initPdfPCell(false, bg);
            cell.addElement((Element)this.printValue(text));
            pdfPTable.addCell(cell);
        }
        int childCount = comparedNode.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            this.printComparedNode(comparedNode.getChild(childIndex), pdfPTable, level + 1);
        }
    }

    private Paragraph initParagraph() {
        Paragraph result = new Paragraph();
        result.setAlignment(0);
        result.setLeading(1.0f, 1.0f);
        result.setSpacingAfter(2.0f);
        return result;
    }

    private PdfPCell initPdfPCell(boolean firstColumn, Color bgcolor) {
        PdfPCell result = new PdfPCell();
        result.setBackgroundColor(bgcolor);
        result.setBorderWidthBottom(this.pdfConfig.getBorderWidth());
        result.setBorderColorBottom(this.pdfConfig.getBorderColor());
        result.setBorderWidthRight(this.pdfConfig.getBorderWidth());
        result.setBorderColorRight(this.pdfConfig.getBorderColor());
        result.setBorderWidthLeft(firstColumn ? this.pdfConfig.getBorderWidth() : 0.0f);
        result.setBorderColorLeft(this.pdfConfig.getBorderColor());
        result.setBorderWidthTop(0.0f);
        result.setBorderColorTop(this.pdfConfig.getBorderColor());
        return result;
    }

    private PdfPCell initHeaderPdfPCell(boolean firstColumn, boolean lastColumn) {
        PdfPCell result = new PdfPCell();
        result.setBackgroundColor(this.pdfConfig.getHeaderBGColor());
        result.setBorderWidthTop(this.pdfConfig.getBorderWidth());
        result.setBorderColorTop(this.pdfConfig.getHeaderBGColor());
        result.setBorderWidthLeft(firstColumn ? this.pdfConfig.getBorderWidth() : 0.0f);
        result.setBorderColorLeft(this.pdfConfig.getHeaderBGColor());
        result.setBorderWidthBottom(0.0f);
        result.setBorderColorBottom(this.pdfConfig.getBorderColor());
        result.setBorderWidthRight(this.pdfConfig.getBorderWidth());
        result.setBorderColorRight(lastColumn ? this.pdfConfig.getHeaderBGColor() : this.pdfConfig.getHeaderBorderColor());
        return result;
    }

    private Paragraph printValue(String text) {
        Paragraph paragraph = this.initParagraph();
        this.pushElementArrays((TextElementArray)paragraph);
        if (text == null) {
            text = "";
        }
        this.writeChunkToCurrentElementArray(text, this.pdfConfig.getFont(), this.pdfConfig.getValueColor(), null);
        this.popElementArrays();
        return paragraph;
    }

    private Paragraph printHeaderValue(String text) {
        Paragraph paragraph = this.initParagraph();
        this.pushElementArrays((TextElementArray)paragraph);
        if (text == null) {
            text = "";
        }
        this.writeChunkToCurrentElementArray(text, this.pdfConfig.getFont(), this.pdfConfig.getHeaderTextColor(), null);
        this.popElementArrays();
        return paragraph;
    }

    private Paragraph printStructurValue(ComparedNode comparedNode) {
        Paragraph paragraph = this.initParagraph();
        this.pushElementArrays((TextElementArray)paragraph);
        try {
            Image image = comparedNode.getElement() instanceof MetaThemenbereich ? Image.getInstance((URL)TOPIC_ICON) : (((MetaTBFeld)comparedNode.getElement()).getKlasse() instanceof MetaThemenbereich ? Image.getInstance((URL)TOPICFIELD_ICON) : Image.getInstance((URL)FEATURE_ICON));
            this.peekElementArrays().add((Object)image);
            this.peekElementArrays().add((Object)new Chunk(image, 0.0f, 0.0f, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String text = comparedNode.toString();
        if (text == null) {
            text = "";
        }
        this.writeChunkToCurrentElementArray(text, this.pdfConfig.getFont(), this.pdfConfig.getHeaderTextColor(), null);
        this.popElementArrays();
        return paragraph;
    }

    private PdfPTable createTableTitle(PdfContext pdfContext) {
        PdfPTable table = new PdfPTable(new float[]{100.0f});
        table.setWidthPercentage(100.0f);
        table.setTotalWidth(this.document.right() - this.document.leftMargin());
        Paragraph paragraph = new Paragraph();
        paragraph.setSpacingBefore(0.0f);
        paragraph.setSpacingAfter(5.0f);
        paragraph.setExtraParagraphSpace(0.0f);
        paragraph.setAlignment(1);
        paragraph.setLeading(1.0f, 1.0f);
        this.pushElementArrays((TextElementArray)paragraph);
        this.writeChunkToCurrentElementArray(this.pdfConfig.getTitel(), this.pdfConfig.getFont(), Color.black, null);
        this.popElementArrays();
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setBorder(0);
        pdfPCell.setVerticalAlignment(4);
        pdfPCell.addElement((Element)paragraph);
        pdfPCell.setPaddingTop(15.0f);
        pdfPCell.setPaddingLeft(0.0f);
        pdfPCell.setPaddingRight(0.0f);
        pdfPCell.setPaddingBottom(0.0f);
        table.addCell(pdfPCell);
        return table;
    }
}

