/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.codegen.pl.HierarchicalCodeConverter;
import de.statspez.pleditor.generator.codegen.support.TextResource;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaForEachIndexOperator;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaWithOperator;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppeComps;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class CodegenUtil {
    public static String getValueSpaceAsString(MetaCustomMerkmal merkmal) {
        StringBuffer buffer = new StringBuffer();
        if (merkmal.getKlasseWertebereich() != null) {
            int num = merkmal.getKlasseWertebereich().getAuspraegungsComps().sizeOfAuspraegungen();
            if (num > 0) {
                Iterator iter = merkmal.getKlasseWertebereich().getAuspraegungsComps().getAuspraegungen();
                while (iter.hasNext()) {
                    MetaAuspraegung auspraegung = (MetaAuspraegung)iter.next();
                    buffer.append(auspraegung.getFachschluessel());
                    if (num <= 3) {
                        buffer.append(" - ");
                        buffer.append(auspraegung.getKurztext());
                    } else if (buffer.length() > 40) {
                        buffer.append(" ...");
                        break;
                    }
                    if (!iter.hasNext()) continue;
                    buffer.append(", ");
                }
            }
        } else if (merkmal.getWertebereich() != null && merkmal.getWertebereich().length() > 0) {
            String wertebereich = "";
            for (int i = 0; i < merkmal.getWertebereich().length(); ++i) {
                if (merkmal.getWertebereich().startsWith("--", i)) {
                    if (!wertebereich.endsWith(" ")) {
                        wertebereich = wertebereich + " ";
                    }
                    wertebereich = wertebereich + "< x < ";
                    ++i;
                    continue;
                }
                if (merkmal.getWertebereich().startsWith("++", i)) {
                    if (!wertebereich.endsWith(" ")) {
                        wertebereich = wertebereich + " ";
                    }
                    wertebereich = wertebereich + "<= x <= ";
                    ++i;
                    continue;
                }
                if (merkmal.getWertebereich().startsWith("+-", i)) {
                    if (!wertebereich.endsWith(" ")) {
                        wertebereich = wertebereich + " ";
                    }
                    wertebereich = wertebereich + "<= x < ";
                    ++i;
                    continue;
                }
                if (merkmal.getWertebereich().startsWith("-+", i)) {
                    if (!wertebereich.endsWith(" ")) {
                        wertebereich = wertebereich + " ";
                    }
                    wertebereich = wertebereich + "< x <= ";
                    ++i;
                    continue;
                }
                char charAtI = merkmal.getWertebereich().charAt(i);
                if (charAtI == ' ') {
                    if (wertebereich.endsWith(" ")) continue;
                    wertebereich = wertebereich + " ";
                    continue;
                }
                wertebereich = wertebereich + charAtI;
            }
            if (wertebereich.length() > 40) {
                String[] bereiche = wertebereich.split(",");
                for (int i = 0; i < bereiche.length; ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    if (buffer.length() >= 40) {
                        buffer.append("...");
                        break;
                    }
                    buffer.append(bereiche[i].trim());
                }
            } else {
                buffer.append(wertebereich);
            }
        }
        String valueSpace = buffer.length() > 0 ? buffer.toString() : null;
        return valueSpace;
    }

    public static String getDisplayName(TextResource textResource, MetaCustomMerkmal merkmal) {
        String displayName = textResource.getBezeichnung(merkmal);
        if (displayName == null || displayName.length() == 0) {
            displayName = merkmal.getName();
        }
        return displayName;
    }

    public static String getDisplayName(TextResource textResource, MetaCustomTBFeld feld) {
        String displayName = textResource.getBezeichnung(feld);
        if (displayName == null || displayName.length() == 0) {
            if (feld.getKlasse() instanceof MetaCustomMerkmal) {
                displayName = textResource.getBezeichnung((MetaCustomMerkmal)feld.getKlasse());
                if (displayName == null || displayName.length() == 0) {
                    displayName = feld.getName();
                }
            } else {
                displayName = feld.getName();
            }
        }
        return displayName;
    }

    public static MetaPLMaterial[] getUsedMaterials(MetaPlausibilisierung plausi) {
        final Vector usedMaterials = new Vector();
        Traverser traverser = new Traverser(){

            @Override
            public void visitThemenbereich(MetaThemenbereich aTb) {
                this.visitElements(aTb.getMaterialreferenzen());
                super.visitThemenbereich(aTb);
            }

            @Override
            public void visitTBMaterialReferenz(MetaTBMaterialReferenz anObject) {
                if (!usedMaterials.contains(anObject.getMaterialbeschreibung())) {
                    usedMaterials.add(anObject.getMaterialbeschreibung());
                }
            }
        };
        plausi.accept(traverser);
        return usedMaterials.toArray(new MetaPLMaterial[0]);
    }

    public static boolean referencedByUsedMaterial(MetaPlausibilisierung plausi, final MetaThemenbereich tb) {
        MetaPLMaterial[] usedMaterials;
        boolean referencedByMaterial = false;
        if ((((MetaCustomThemenbereich)tb).describesMaterial() || ((MetaCustomThemenbereich)tb).referencedByMaterial()) && (usedMaterials = CodegenUtil.getUsedMaterials(plausi)) != null && usedMaterials.length > 0) {
            for (int i = 0; i < usedMaterials.length; ++i) {
                if (usedMaterials[i].getThemenbereich() == tb) {
                    referencedByMaterial = true;
                    break;
                }
                Traverser traverser = new Traverser(){

                    @Override
                    public void visitThemenbereich(MetaThemenbereich aTb) {
                        if (aTb == tb) {
                            throw new ElementFound();
                        }
                        super.visitThemenbereich(aTb);
                    }
                };
                try {
                    plausi.accept(traverser);
                    continue;
                }
                catch (ElementFound e) {
                    referencedByMaterial = true;
                    break;
                }
            }
        }
        return referencedByMaterial;
    }

    public static String getEscapedStringLiteral(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer escapedValue = new StringBuffer();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\'': {
                    escapedValue.append("\\");
                }
            }
            escapedValue.append(chars[i]);
        }
        return escapedValue.toString();
    }

    public static boolean containsHierarchicalCode(MetaFactor operand) {
        Traverser traverser = new Traverser(){

            @Override
            public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
                Iterator iter = anArrayAccess.indices();
                while (iter != null && iter.hasNext()) {
                    MetaFactor index = (MetaFactor)iter.next();
                    if (!(index.adaptedObject() instanceof MetaForEachIndexOperator) && !(index.adaptedObject() instanceof MetaWithOperator) && !(index.adaptedObject() instanceof MetaRangeSeries)) continue;
                    throw new ElementFound();
                }
            }
        };
        boolean hierarchicalCodeFound = false;
        try {
            operand.accept(traverser);
        }
        catch (ElementFound e) {
            hierarchicalCodeFound = true;
        }
        return hierarchicalCodeFound;
    }

    public static MetaProgram convertProgramWithHierarchicalCode(MetaProgram program) {
        MetaProgram programWithoutHierarchicalCode;
        if (program.containsHierarchicalFunction()) {
            HierarchicalCodeConverter converter = new HierarchicalCodeConverter();
            programWithoutHierarchicalCode = Helper.metaStructureFor(converter.generate(program));
            programWithoutHierarchicalCode.setName(program.name());
            programWithoutHierarchicalCode.setContextInfos(program.contextInfos());
            programWithoutHierarchicalCode.setCanHaveSelfAccess(program.isCanHaveSelfAccess());
            programWithoutHierarchicalCode.setHasToReturnValue(program.isHasToReturnValue());
            programWithoutHierarchicalCode.setPlausiStatementsAllowed(program.isPlausiStatementsAllowed());
            programWithoutHierarchicalCode.setCanHaveIndexOperator(program.isCanHaveIndexOperator());
            Iterator params = program.parameters();
            while (params.hasNext()) {
                programWithoutHierarchicalCode.addParameter((MetaProgramParameter)params.next());
            }
        } else {
            programWithoutHierarchicalCode = program;
        }
        return programWithoutHierarchicalCode;
    }

    public static String stackToString(Stack stack, String separator) {
        StringBuffer result = new StringBuffer();
        Iterator iter = stack.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static List<MetaCustomTBFeld> getFieldsForMerkmal(MetaPlausibilisierung plausi, final MetaCustomMerkmal merkmal) {
        final ArrayList<MetaCustomTBFeld> result = new ArrayList<MetaCustomTBFeld>();
        ((MetaCustomPlausibilisierung)plausi).rootThemenbereich().accept(new AbstractElementVisitor(){

            @Override
            public void visitThemenbereich(MetaThemenbereich topic) {
                this.visitElements(topic.getFelder());
            }

            @Override
            public void visitTBFeld(MetaTBFeld field) {
                if (field.getKlasse() == merkmal) {
                    result.add((MetaCustomTBFeld)field);
                } else if (field.getKlasse() instanceof MetaThemenbereich) {
                    field.getKlasse().accept(this);
                }
            }
        });
        return result;
    }

    public static Map getFieldsForMerkmalWithHierarchy(MetaPlausibilisierung plausi, final MetaCustomMerkmal merkmal) {
        final HashMap result = new HashMap();
        ((MetaCustomPlausibilisierung)plausi).rootThemenbereich().accept(new AbstractElementVisitor(){
            private Stack hierarchy = new Stack();

            @Override
            public void visitThemenbereich(MetaThemenbereich topic) {
                this.visitElements(topic.getFelder());
            }

            @Override
            public void visitTBFeld(MetaTBFeld field) {
                this.hierarchy.push(field.getName());
                if (field.getKlasse() == merkmal) {
                    result.put(CodegenUtil.stackToString(this.hierarchy, "."), (MetaCustomTBFeld)field);
                } else if (field.getKlasse() instanceof MetaThemenbereich) {
                    field.getKlasse().accept(this);
                }
                this.hierarchy.pop();
            }
        });
        return result;
    }

    public static boolean containsMissingValues(MetaThemenbereich tb) {
        AbstractElementVisitor traverser = new AbstractElementVisitor(){

            @Override
            public void visitThemenbereich(MetaThemenbereich themenbereich) {
                this.visitElements(themenbereich.getFelder());
            }

            @Override
            public void visitTBFeld(MetaTBFeld tbFeld) {
                if (tbFeld.getKlasse() instanceof MetaMerkmal) {
                    MetaMerkmal merkmal = (MetaMerkmal)tbFeld.getKlasse();
                    if (merkmal.getKlasseFehlwerte() != null) {
                        throw new ElementFound();
                    }
                } else {
                    tbFeld.getKlasse().accept(this);
                }
            }
        };
        try {
            tb.accept(traverser);
        }
        catch (ElementFound e) {
            return true;
        }
        return false;
    }

    public static final int getAuspraegungenCount(MetaAuspraegungsgruppe apg) {
        if (apg == null) {
            throw new IllegalArgumentException("apg ist null.");
        }
        CountAuspraegungenTraverser traverser = new CountAuspraegungenTraverser();
        apg.accept(traverser);
        int dimension = traverser.getCount();
        return dimension;
    }

    public static final int getMehrfachantwortTbFieldDimension(MetaTBFeld tbField) {
        if (tbField == null) {
            throw new IllegalArgumentException("tbField ist null.");
        }
        boolean meharfachantwort = tbField.getMehrfachantworten();
        if (!meharfachantwort) {
            throw new IllegalArgumentException("Kein Mehrfachantwort-TBFeld.");
        }
        MetaStatspezObjekt klasse = tbField.getKlasse();
        if (klasse == null) {
            throw new IllegalStateException("Das Mehrfachantwort-TBFeld hat keine Klasse.");
        }
        if (!(klasse instanceof MetaMerkmal)) {
            throw new IllegalStateException("Dem Mehrfachantwort-TBFeld ist kein Merkmal zugeordnet.");
        }
        MetaMerkmal merkmal = (MetaMerkmal)klasse;
        MetaAuspraegungsgruppe apg = merkmal.getKlasseWertebereich();
        if (apg == null) {
            throw new IllegalStateException("Dem Merkmal des Mehrfachantwort-TBFelds ist keine Auspraegungsgruppe zugeordnet.");
        }
        int dimension = CodegenUtil.getAuspraegungenCount(apg);
        return dimension;
    }

    public static boolean containsMehrfachantwortTbFieldForMerkmal(MetaPlausibilisierung plausi, final MetaCustomMerkmal merkmal) {
        AbstractElementVisitor traverser = new AbstractElementVisitor(){

            @Override
            public void visitThemenbereich(MetaThemenbereich topic) {
                this.visitElements(topic.getFelder());
            }

            @Override
            public void visitTBFeld(MetaTBFeld field) {
                if (field.getKlasse() == merkmal) {
                    if (field.getMehrfachantworten()) {
                        throw new ElementFound();
                    }
                } else if (field.getKlasse() instanceof MetaThemenbereich) {
                    field.getKlasse().accept(this);
                }
            }
        };
        try {
            ((MetaCustomPlausibilisierung)plausi).rootThemenbereich().accept(traverser);
        }
        catch (ElementFound e) {
            return true;
        }
        return false;
    }

    public static List<MetaCustomThemenbereich> getSubTbsWithReferenceFunctions(MetaCustomThemenbereich tb) {
        ArrayList<MetaCustomThemenbereich> subTbsWithReferenceFunctions = new ArrayList<MetaCustomThemenbereich>();
        Iterator it = tb.getFelder();
        while (it.hasNext()) {
            MetaCustomThemenbereich subTb;
            MetaTBFeld tbFeld = (MetaTBFeld)it.next();
            MetaStatspezObjekt klasse = tbFeld.getKlasse();
            if (!(klasse instanceof MetaCustomThemenbereich) || !(subTb = (MetaCustomThemenbereich)klasse).hasReferenceFunctions() || subTbsWithReferenceFunctions.contains(subTb)) continue;
            subTbsWithReferenceFunctions.add(subTb);
        }
        return subTbsWithReferenceFunctions;
    }

    public static boolean containsFieldErrorTextesForMerkmal(MetaCustomPlausibilisierung plausi, final MetaMerkmal merkmal) {
        AbstractElementVisitor traverser = new AbstractElementVisitor(){

            @Override
            public void visitThemenbereich(MetaThemenbereich topic) {
                this.visitElements(topic.getFelder());
            }

            @Override
            public void visitTBFeld(MetaTBFeld field) {
                if (field.getKlasse() instanceof MetaMerkmal) {
                    if (field.getKlasse() == merkmal) {
                        if (field.getFehlertextKurz() != null && field.getFehlertextKurz().length() > 0) {
                            throw new ElementFound();
                        }
                        if (field.getFehlertextLang() != null && field.getFehlertextLang().length() > 0) {
                            throw new ElementFound();
                        }
                        if (field.getKorrekturhinweis() != null && field.getKorrekturhinweis().length() > 0) {
                            throw new ElementFound();
                        }
                    }
                } else {
                    field.getKlasse().accept(this);
                }
            }
        };
        try {
            plausi.rootThemenbereich().accept(traverser);
        }
        catch (ElementFound e) {
            return true;
        }
        return false;
    }

    public static boolean containsFieldErrorTextShort(MetaThemenbereich topic, final boolean deepSearch) {
        AbstractElementVisitor traverser = new AbstractElementVisitor(){

            @Override
            public void visitThemenbereich(MetaThemenbereich topic) {
                this.visitElements(topic.getFelder());
            }

            @Override
            public void visitTBFeld(MetaTBFeld field) {
                if (field.getKlasse() instanceof MetaMerkmal) {
                    if (field.getFehlertextKurz() != null && field.getFehlertextKurz().length() > 0) {
                        throw new ElementFound();
                    }
                } else if (deepSearch) {
                    field.getKlasse().accept(this);
                }
            }
        };
        try {
            topic.accept(traverser);
        }
        catch (ElementFound e) {
            return true;
        }
        return false;
    }

    public static boolean containsFieldErrorTextLong(MetaThemenbereich topic, final boolean deepSearch) {
        AbstractElementVisitor traverser = new AbstractElementVisitor(){

            @Override
            public void visitThemenbereich(MetaThemenbereich topic) {
                this.visitElements(topic.getFelder());
            }

            @Override
            public void visitTBFeld(MetaTBFeld field) {
                if (field.getKlasse() instanceof MetaMerkmal) {
                    if (field.getFehlertextLang() != null && field.getFehlertextLang().length() > 0) {
                        throw new ElementFound();
                    }
                } else if (deepSearch) {
                    field.getKlasse().accept(this);
                }
            }
        };
        try {
            topic.accept(traverser);
        }
        catch (ElementFound e) {
            return true;
        }
        return false;
    }

    public static boolean containsFieldErrorCorrectionAdvice(MetaThemenbereich topic, final boolean deepSearch) {
        AbstractElementVisitor traverser = new AbstractElementVisitor(){

            @Override
            public void visitThemenbereich(MetaThemenbereich topic) {
                this.visitElements(topic.getFelder());
            }

            @Override
            public void visitTBFeld(MetaTBFeld field) {
                if (field.getKlasse() instanceof MetaMerkmal) {
                    if (field.getKorrekturhinweis() != null && field.getKorrekturhinweis().length() > 0) {
                        throw new ElementFound();
                    }
                } else if (deepSearch) {
                    field.getKlasse().accept(this);
                }
            }
        };
        try {
            topic.accept(traverser);
        }
        catch (ElementFound e) {
            return true;
        }
        return false;
    }

    public static boolean containsTopicFields(MetaThemenbereich topic) {
        AbstractElementVisitor traverser = new AbstractElementVisitor(){

            @Override
            public void visitThemenbereich(MetaThemenbereich topic) {
                this.visitElements(topic.getFelder());
            }

            @Override
            public void visitTBFeld(MetaTBFeld field) {
                if (field.getKlasse() instanceof MetaThemenbereich) {
                    throw new ElementFound();
                }
            }
        };
        try {
            topic.accept(traverser);
        }
        catch (ElementFound e) {
            return true;
        }
        return false;
    }

    private static final class ElementFound
    extends RuntimeException {
    }

    private static class CountAuspraegungenTraverser
    extends AbstractElementVisitor {
        private int count = 0;

        private CountAuspraegungenTraverser() {
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe auspraegungsgruppe) {
            if (auspraegungsgruppe.getAuspraegungsComps() != null) {
                auspraegungsgruppe.getAuspraegungsComps().accept(this);
            }
        }

        @Override
        public void visitAuspraegungsgruppeComps(MetaAuspraegungsgruppeComps auspraegungsgruppeComps) {
            Iterator iter = auspraegungsgruppeComps.getAuspraegungen();
            while (iter != null && iter.hasNext()) {
                ((MetaElement)iter.next()).accept(this);
            }
        }

        @Override
        public void visitPLAuspraegung(MetaPLAuspraegung plAuspraegung) {
            if (plAuspraegung.sizeOfAuspraegungen() > 0) {
                Iterator iter = plAuspraegung.getAuspraegungen();
                while (iter != null && iter.hasNext()) {
                    ((MetaElement)iter.next()).accept(this);
                }
            } else {
                ++this.count;
            }
        }
    }
}

