/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.mapping;

import de.statspez.pleditor.generator.codegen.mapping.IndexVariableSupplier;
import de.statspez.pleditor.generator.codegen.mapping.MappingRegelGenerator;
import de.statspez.pleditor.generator.codegen.mapping.MappingUtil;
import de.statspez.pleditor.generator.codegen.mapping.structure.Mapping;
import de.statspez.pleditor.generator.codegen.mapping.structure.MappingElement;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaMappingElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class MappingProgramGenerator {
    private HashMap targetVARNames;
    private HashMap sourceVARNames;
    private boolean generateMappingElementComments = false;

    public String createMappingProgram(Mapping aMapping) throws IllegalArgumentException {
        String erg = null;
        erg = this.createMappingProgram(aMapping, null, null);
        return erg;
    }

    public String createMappingProgram(Mapping aMapping, Collection mappingSourceFieldNames, Collection mappingTargetFieldNames) throws IllegalArgumentException {
        String erg = null;
        MappingCodeGenerator mapGen = new MappingCodeGenerator(mappingSourceFieldNames, mappingTargetFieldNames);
        mapGen.generate(aMapping);
        erg = mapGen.getMappingCode();
        return erg;
    }

    protected int depth(String path) {
        int depth = 0;
        if (path != null) {
            for (int i = 0; i < path.length(); ++i) {
                if (path.charAt(i) != '.') continue;
                ++depth;
            }
        }
        return depth;
    }

    public boolean isGenerateMappingElementComments() {
        return this.generateMappingElementComments;
    }

    public void setGenerateMappingElementComments(boolean generateMappingElementComments) {
        this.generateMappingElementComments = generateMappingElementComments;
    }

    private class MappingCodeGenerator
    extends AbstractElementVisitor
    implements IndexVariableSupplier {
        private static final String INDENT = "   ";
        private StringBuffer code;
        private ArrayList mappingElementList;
        private MappingListAdapter listAdapter;
        private String einrueckung;
        Collection mappingSourceFieldNames = null;
        Collection mappingTargetFieldNames = null;

        public MappingCodeGenerator(Collection mappingSourceFieldNames, Collection mappingTargetFieldNames) {
            this.mappingSourceFieldNames = mappingSourceFieldNames;
            this.mappingTargetFieldNames = mappingTargetFieldNames;
            this.code = new StringBuffer();
            this.mappingElementList = new ArrayList();
            MappingProgramGenerator.this.targetVARNames = new HashMap();
            MappingProgramGenerator.this.sourceVARNames = new HashMap();
            this.einrueckung = "";
        }

        public MappingCodeGenerator() {
            this(null, null);
        }

        public String getMappingCode() {
            return this.code.toString();
        }

        private void schreiben(String string) {
            this.code.append(string);
        }

        private void umbruch() {
            this.code.append("\n");
        }

        private void einruecken() {
            this.code.append(this.einrueckung);
        }

        private void blockBeginn() {
            this.schreiben(this.einrueckung);
            this.umbruch();
            this.einrueckung = this.einrueckung + INDENT;
        }

        private void blockEnde() {
            this.einrueckung = this.einrueckung.substring(INDENT.length());
            this.schreiben(this.einrueckung);
        }

        private String generateTargetVar(String varname) {
            varname = MappingUtil.encodeName(varname);
            return "Z_" + varname.replaceAll("\\.", "_");
        }

        private String generateSourceVar(String varname) {
            varname = MappingUtil.encodeName(varname);
            return "Q_" + varname.replaceAll("\\.", "_");
        }

        public void generate(Mapping aMapping) {
            if (aMapping != null) {
                for (String path : aMapping.getSourceDimensionedHierarchyNames()) {
                    MappingProgramGenerator.this.sourceVARNames.put(path, this.generateSourceVar(path));
                }
                for (String path : aMapping.getTargetDimensionedHierarchyNames()) {
                    MappingProgramGenerator.this.targetVARNames.put(path, this.generateTargetVar(path));
                }
                this.generateLoopVARiableDeclarations();
                this.generateCodeBySourceHierarchy(aMapping);
            }
        }

        private void generateLoopVARiableDeclarations() {
            Iterator it = MappingProgramGenerator.this.targetVARNames.keySet().iterator();
            while (it.hasNext()) {
                String targetVARName = (String)MappingProgramGenerator.this.targetVARNames.get(it.next());
                this.code.append("VAR " + targetVARName + "\n" + targetVARName + " := 1\n");
            }
            it = MappingProgramGenerator.this.sourceVARNames.keySet().iterator();
            while (it.hasNext()) {
                String sourceVARName = (String)MappingProgramGenerator.this.sourceVARNames.get(it.next());
                this.code.append("VAR " + sourceVARName + "\n" + sourceVARName + " := 1\n");
            }
        }

        private String generateLoopVARiableZeroForDirectAncestors(String path, HashMap varNames, String indent) {
            StringBuffer erg = new StringBuffer("");
            int hierarchieStufe = path.split("\\.").length;
            for (String aktPath : varNames.keySet()) {
                int aktHierarchieStufe;
                if (!aktPath.startsWith(path) || (aktHierarchieStufe = aktPath.split("\\.").length) != hierarchieStufe + 1) continue;
                erg.append(indent + varNames.get(aktPath) + " := 1\n");
            }
            return erg.toString();
        }

        private void generateCodeBySourceHierarchy(Mapping aMapping) {
            MapElementComparator comparator = new MapElementComparator();
            MappingElement[] mappingElements = aMapping.getMappingElementList().toArray(new MappingElement[0]);
            Arrays.sort(mappingElements, comparator);
            this.listAdapter = new MappingListAdapter(mappingElements);
            if (this.listAdapter != null && this.listAdapter.hasNext()) {
                this.generateCodeForHierarchiestufe(0, "");
            }
        }

        private void generateCodeForHierarchiestufe(int stufe, String indent) {
            boolean inHierarchie = true;
            while (this.listAdapter.hasNext() && inHierarchie) {
                int stufeOfNextElement = this.listAdapter.nextDepth();
                if (stufeOfNextElement > stufe) {
                    this.generateCodeForHierarchiestufe(stufe + 1, indent);
                    continue;
                }
                if (stufeOfNextElement < stufe) {
                    inHierarchie = false;
                    continue;
                }
                MappingElement mappingElement = this.listAdapter.next();
                if (mappingElement.getType() != 0 && mappingElement.getType() != 1) continue;
                String targetHierarchyName = mappingElement.getTargetHierarchyAsString();
                String sourceHierarchyName = mappingElement.getSourceHierarchyAsString();
                if (this.mappingTargetFieldNames != null && !this.mappingTargetFieldNames.contains(targetHierarchyName) || this.mappingSourceFieldNames != null && !this.mappingSourceFieldNames.contains(sourceHierarchyName)) continue;
                String subIndent = indent + INDENT;
                String preText = "";
                String startText = "";
                String middleText = "";
                String endText = "";
                String postText = "";
                boolean isSubStructure = false;
                MetaProgram regelSpez = mappingElement.getMappingRule();
                if (mappingElement.getType() == 0) {
                    if (regelSpez != null) {
                        MappingRegelGenerator mappingRegelGenerator = new MappingRegelGenerator();
                        mappingRegelGenerator.generieren(regelSpez, this, indent, null);
                        preText = mappingRegelGenerator.getPreMappingCode();
                        postText = mappingRegelGenerator.getPostMappingCode();
                        startText = startText + INDENT;
                    }
                    startText = startText + indent + this.getHierarchyAsStringWithIndices(targetHierarchyName, MappingProgramGenerator.this.targetVARNames, true) + " := " + this.getHierarchyAsStringWithIndices(sourceHierarchyName, MappingProgramGenerator.this.sourceVARNames, true) + "\n";
                } else if (mappingElement.getType() == 1) {
                    String sourceVarName = (String)MappingProgramGenerator.this.sourceVARNames.get(sourceHierarchyName);
                    String targetVarName = (String)MappingProgramGenerator.this.targetVARNames.get(targetHierarchyName);
                    String stmtIncreaseTargetIndex = null;
                    if (targetVarName != null && sourceVarName != null) {
                        stmtIncreaseTargetIndex = targetVarName + " := " + targetVarName + " + 1\n";
                    }
                    if (regelSpez != null) {
                        MappingRegelGenerator mappingRegelGenerator = new MappingRegelGenerator();
                        mappingRegelGenerator.generieren(regelSpez, this, subIndent, stmtIncreaseTargetIndex);
                        startText = mappingRegelGenerator.getPreMappingCode();
                        endText = mappingRegelGenerator.getPostMappingCode();
                        subIndent = subIndent + INDENT;
                    } else if (targetVarName != null && sourceVarName != null) {
                        postText = subIndent + stmtIncreaseTargetIndex;
                    }
                    preText = "";
                    if (sourceVarName != null) {
                        isSubStructure = true;
                        preText = indent + "WIEDERHOLE FUER " + MappingProgramGenerator.this.sourceVARNames.get(sourceHierarchyName) + " := 1 BIS " + MappingProgramGenerator.this.sourceVARNames.get(sourceHierarchyName) + " > ANZAHL VON " + this.getHierarchyAsStringWithIndices(sourceHierarchyName, MappingProgramGenerator.this.sourceVARNames, false) + "\n";
                    }
                    middleText = this.generateLoopVARiableZeroForDirectAncestors(targetHierarchyName, MappingProgramGenerator.this.targetVARNames, subIndent);
                    if (sourceVarName != null) {
                        postText = postText + indent + "ENDE\n";
                        postText = postText + indent + sourceVarName + " := 1\n";
                    }
                }
                StringBuffer codeBackup = this.code;
                this.code = new StringBuffer();
                if (this.listAdapter.hasSubStructure()) {
                    this.generateCodeForHierarchiestufe(stufe + 1, subIndent);
                }
                StringBuffer subMappingsBuf = this.code;
                this.code = codeBackup;
                String subMappings = subMappingsBuf.toString();
                if (isSubStructure && subMappings.trim().length() == 0) {
                    preText = "";
                    startText = "";
                    subMappings = "";
                    middleText = "";
                    endText = "";
                    postText = "";
                }
                if (MappingProgramGenerator.this.isGenerateMappingElementComments()) {
                    this.code.append(indent + "\"" + sourceHierarchyName + " -> " + targetHierarchyName + "\"\n");
                }
                this.code.append(preText);
                this.code.append(startText);
                this.code.append(subMappings);
                this.code.append(middleText);
                this.code.append(endText);
                this.code.append(postText);
            }
        }

        @Override
        public void visitMapping(MetaMapping aMapping) {
            this.visitElements(aMapping.getMappingliste());
        }

        @Override
        public void visitMappingElement(MetaMappingElement anElement) {
            this.mappingElementList.add(anElement);
        }

        @Override
        public String getSourceIndexVariable(String structure) {
            return (String)MappingProgramGenerator.this.sourceVARNames.get(structure);
        }

        @Override
        public String getTargetIndexVariable(String structure) {
            return (String)MappingProgramGenerator.this.targetVARNames.get(structure);
        }

        private String getHierarchyAsStringWithIndices(String hierarchy, HashMap varNames, boolean withLastIndex) {
            String hierarchyWithIndices = "";
            String aktPath = "";
            String[] path = hierarchy.split("\\.");
            if (path != null) {
                for (int i = 0; i < path.length; ++i) {
                    if (i > 0) {
                        aktPath = aktPath + ".";
                        hierarchyWithIndices = hierarchyWithIndices + ".";
                    }
                    aktPath = aktPath + path[i];
                    hierarchyWithIndices = hierarchyWithIndices + path[i];
                    if (!varNames.containsKey(aktPath) || !withLastIndex && i + 1 >= path.length) continue;
                    hierarchyWithIndices = hierarchyWithIndices + "[" + varNames.get(aktPath) + "]";
                }
            }
            return hierarchyWithIndices;
        }

        private class MapElementComparator
        implements Comparator {
            public int compare(Object o1, Object o2) {
                int type2;
                int type1;
                String pathAndName2;
                String pathAndName1;
                int erg = -1;
                if (o1 instanceof MappingElement && o2 instanceof MappingElement && (erg = (pathAndName1 = ((MappingElement)o1).getSourceHierarchyAsString()).compareTo(pathAndName2 = ((MappingElement)o2).getSourceHierarchyAsString())) == 0 && ((MappingElement)o1).getSourceDimensions() != null && ((MappingElement)o2).getSourceDimensions() != null && (type1 = ((MappingElement)o1).getType()) != (type2 = ((MappingElement)o2).getType())) {
                    if (type1 == 1 && type2 == 0) {
                        erg = -1;
                    } else if (type1 == 0 && type2 == 1) {
                        erg = 1;
                    }
                }
                return erg;
            }
        }

        private class MappingListAdapter {
            private int aktIndex = -1;
            private MappingElement[] mappingListe;

            public MappingListAdapter(MappingElement[] neueMappingListe) {
                this.mappingListe = neueMappingListe;
            }

            public boolean hasNext() {
                return this.mappingListe != null && this.aktIndex + 1 < this.mappingListe.length;
            }

            public boolean hasSubStructure() {
                boolean hasSubStructure = false;
                if (this.hasNext()) {
                    MappingElement actual = this.actual();
                    if (actual == null) {
                        hasSubStructure = true;
                    } else {
                        MappingElement next = this.mappingListe[this.aktIndex + 1];
                        String actualPath = actual.getSourceHierarchyAsString();
                        String nextPath = next.getSourceHierarchyAsString();
                        if (actualPath != null && nextPath != null && actualPath.length() > 0 && nextPath.length() > 0 && nextPath.startsWith(actualPath)) {
                            hasSubStructure = true;
                        }
                    }
                }
                return hasSubStructure;
            }

            public MappingElement next() {
                MappingElement next = null;
                if (this.hasNext()) {
                    ++this.aktIndex;
                    next = this.mappingListe[this.aktIndex];
                }
                return next;
            }

            public MappingElement actual() {
                MappingElement actual = null;
                if (this.mappingListe != null && this.aktIndex >= 0 && this.aktIndex < this.mappingListe.length) {
                    actual = this.mappingListe[this.aktIndex];
                }
                return actual;
            }

            public int nextDepth() {
                MappingElement next;
                String nextPath;
                int nextDepth = 0;
                if (this.hasNext() && (nextPath = (next = this.mappingListe[this.aktIndex + 1]).getSourceHierarchyAsString()) != null && nextPath.length() > 0) {
                    nextDepth = MappingProgramGenerator.this.depth(nextPath);
                    if (next.getSourceDimensions() != null && next.getType() == 0) {
                        ++nextDepth;
                    }
                }
                return nextDepth;
            }
        }
    }
}

