/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.js.CodegenContext;
import de.statspez.pleditor.generator.codegen.js.JavaScriptCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;

public class TopicNameFunctionGenerator
extends JavaScriptCodeGenerator {
    private String namespace = "";
    private boolean firstIfBlock;

    public synchronized void generate(CodegenContext context) {
        this.setCodegenContext(context);
        this.firstIfBlock = true;
        this.indentNewLine();
        this.print("function getTopicName(");
        this.print("ns");
        this.print(")");
        this.openBlock();
        MetaThemenbereich rootTopic = ((MetaCustomPlausibilisierung)context.getPlausi()).rootThemenbereich();
        if (CodegenUtil.containsTopicFields(rootTopic)) {
            this.indentNewLine();
            this.print("var f = getFieldWithoutIndices(");
            this.print("ns");
            this.print(");");
            rootTopic.accept(this);
        }
        this.indentNewLine();
        this.print("return null;");
        this.closeBlock();
        this.out.flush();
        this.checkForErrors();
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich aTopic) {
        this.visitElements(aTopic.getFelder());
    }

    @Override
    public void visitTBFeld(MetaTBFeld aField) {
        if (aField.getKlasse() instanceof MetaThemenbereich) {
            MetaThemenbereich topic = (MetaThemenbereich)aField.getKlasse();
            this.indentNewLine();
            if (this.firstIfBlock) {
                this.firstIfBlock = false;
            } else {
                this.print("else ");
            }
            this.print("if (f == \"");
            if (this.namespace.length() > 0) {
                this.print(StringHelper.getEscapedStringValue(this.namespace));
            }
            this.print(StringHelper.getEscapedStringValue(aField.getName()));
            this.print("\")");
            this.openBlock();
            this.indentNewLine();
            this.print("return \"");
            this.print(StringHelper.getEscapedName(topic.getName()));
            this.print("\";");
            this.closeBlock();
            String previousNamespace = this.namespace;
            this.namespace = this.namespace + aField.getName() + ".";
            topic.accept(this);
            this.namespace = previousNamespace;
        }
    }
}

