/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.html;

import de.statspez.pleditor.generator.codegen.html.HtmlAblaufDocGenerator;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import java.io.File;
import java.io.FileInputStream;

public class HtmlAblaufDocGeneratorFacade {
    public static void main(String[] args) {
        String inName = null;
        String outName = null;
        String ablauf = null;
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length - 1; ++i) {
                if (args[i].equalsIgnoreCase("-in")) {
                    inName = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-out")) {
                    outName = args[++i];
                    continue;
                }
                if (!args[i].equalsIgnoreCase("-a")) continue;
                ablauf = args[++i];
            }
        }
        if (inName == null) {
            System.err.println("Das Quellverzeichnis oder Edt-Datei wurde nicht angegeben.");
            System.err.println("Usage: Test_HtmlAblaufDocGenerator -in <Quellverzeichnis|Datei> -out <Zielverzeichnis>");
            System.err.println("Usage: Test_HtmlAblaufDocGenerator -in <Quellverzeichnis|Datei> -out <Zielverzeichnis> -a <Ablauf>");
            System.exit(-1);
        }
        if (outName == null) {
            System.err.println("Das Zielverzeichnis wurde nicht angegeben.");
            System.err.println("Usage: Test_HtmlAblaufDocGenerator -in <Quellverzeichnis|Datei> -out <Zielverzeichnis>");
            System.exit(-1);
        }
        File inFile = new File(inName);
        File outDir = new File(outName);
        HtmlAblaufDocGeneratorFacade generator = new HtmlAblaufDocGeneratorFacade();
        if (inFile.isDirectory()) {
            File[] list;
            for (File file : list = inFile.listFiles()) {
                try {
                    if (!file.isFile()) continue;
                    generator.generateDokuFuerAlleAblaeufe(file, outDir);
                }
                catch (Exception e) {
                    System.out.println("Fehler bei Ablaufdokumentationgenerierung f\u00fcr Edt-Datei: " + file.getName());
                    e.printStackTrace();
                }
            }
        } else {
            try {
                if (ablauf != null) {
                    File doku = HtmlAblaufDocGeneratorFacade.generate(inFile, outDir, ablauf);
                    System.out.println("Ablaufdokumentation " + doku.getAbsolutePath() + " angelegt.");
                }
                generator.generateDokuFuerAlleAblaeufe(inFile, outDir);
            }
            catch (Exception e) {
                System.out.println("Fehler bei Ablaufdokumentationgenerierung f\u00fcr Edt-Datei: " + inFile.getName());
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File generate(File edtFile, File outDir, String ablaufName) throws Exception {
        if (edtFile == null) {
            throw new IllegalArgumentException("Die EDT-Datei muss angegeben werden");
        }
        if (outDir == null) {
            throw new IllegalArgumentException("Das Ausgabeverzeichnis muss angegeben werden");
        }
        if (ablaufName == null || ablaufName.trim().length() == 0) {
            throw new IllegalArgumentException("Der Name des Ablaufes muss angegeben werden");
        }
        File result = null;
        IntermediateLanguageParser parser = new IntermediateLanguageParser();
        parser.setTbFelderMuessenReferenzHaben(false);
        try (FileInputStream fin = null;){
            fin = new FileInputStream(edtFile);
            MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)parser.parse(fin);
            MetaCustomAblauf ablauf = null;
            MetaThemenbereich rootTB = plausi.rootThemenbereich();
            for (int i = 0; i < rootTB.sizeOfAblaeufe(); ++i) {
                MetaCustomAblauf tmp = (MetaCustomAblauf)rootTB.getFromAblaeufe(i);
                if (!ablaufName.equals(tmp.getName())) continue;
                ablauf = tmp;
            }
            if (ablauf == null) {
                throw new Exception("Ablauf mit dem Namen <" + ablaufName + "> in Themenbereich <" + rootTB.getName() + "> nicht vorhanden");
            }
            try {
                HtmlAblaufDocGenerator generator = new HtmlAblaufDocGenerator();
                result = generator.generate(outDir, ablauf, plausi);
            }
            catch (Exception e) {
                throw new Exception("Fehler bei Ablaufdokumentation-Generierung f\u00fcr Ablauf " + ablauf.getName(), e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDokuFuerAlleAblaeufe(File edtFile, File outDir) throws Exception {
        IntermediateLanguageParser parser = new IntermediateLanguageParser();
        parser.setTbFelderMuessenReferenzHaben(false);
        try (FileInputStream fin = null;){
            fin = new FileInputStream(edtFile);
            MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)parser.parse(fin);
            MetaThemenbereich rootTB = plausi.rootThemenbereich();
            String name = edtFile.getName().substring(0, edtFile.getName().length() - 4);
            for (int i = 0; i < rootTB.sizeOfAblaeufe(); ++i) {
                MetaCustomAblauf ablauf = (MetaCustomAblauf)rootTB.getFromAblaeufe(i);
                try {
                    File outputDir = new File(outDir, name + "_" + ablauf.getName());
                    HtmlAblaufDocGenerator generator = new HtmlAblaufDocGenerator();
                    File doku = generator.generate(outputDir, ablauf, plausi);
                    System.out.println("Ablaufdokumentation " + doku.getAbsolutePath() + " angelegt.");
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Fehler bei Doku-Generierung f\u00fcr Ablauf " + ablauf.getName(), e);
                }
            }
        }
    }
}

