/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff.dialog;

import de.statspez.pleditor.generator.codegen.diff.DiffConfig;
import de.statspez.pleditor.generator.codegen.diff.dialog.DiffConfigComponent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class DiffConfigCheckPanel
extends JPanel
implements DiffConfigComponent {
    private static final long serialVersionUID = -4524025141112118997L;
    private JCheckBox checkGlobal;
    private JCheckBox checkReferencedPLMaterials;
    private JCheckBox checkIdYes;
    private boolean dataChanged = false;

    public DiffConfigCheckPanel() {
        super(new GridBagLayout());
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffConfigCheckPanel.this.dataChanged = true;
            }
        };
        this.checkGlobal = new JCheckBox("Globale Elemente pr\u00fcfen");
        this.checkGlobal.addActionListener(actionListener);
        this.checkReferencedPLMaterials = new JCheckBox("Referenzierte Materialbeschreibungen (PL-Materialien) pr\u00fcfen");
        this.checkReferencedPLMaterials.addActionListener(actionListener);
        this.checkIdYes = new JCheckBox("Die ID der Elemente pr\u00fcfen");
        this.checkIdYes.addActionListener(actionListener);
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.add((Component)this.checkGlobal, gbc);
        ++gbc.gridy;
        this.add((Component)this.checkReferencedPLMaterials, gbc);
        ++gbc.gridy;
        this.add((Component)this.checkIdYes, gbc);
    }

    @Override
    public void setDataFromDiffConfig(DiffConfig diffConfig) {
        this.checkGlobal.setSelected(diffConfig.isCheckGlobal());
        this.checkIdYes.setSelected(diffConfig.isCheckId());
        this.checkReferencedPLMaterials.setSelected(diffConfig.isCheckReferencedPLMaterials());
    }

    @Override
    public void setDataToDiffConfig(DiffConfig diffConfig) {
        diffConfig.setCheckGlobal(this.checkGlobal.isSelected());
        diffConfig.setCheckId(this.checkIdYes.isSelected());
        diffConfig.setCheckReferencedPLMaterials(this.checkReferencedPLMaterials.isSelected());
    }

    @Override
    public boolean isDataChanged() {
        return this.dataChanged;
    }
}

