/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffResultTreeNode;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DiffResultTree {
    private Map contextNodeMap = null;
    private DiffResultTreeNode rootNode = null;

    DiffResultTree(MetaCustomPlausibilisierung plausi1, MetaCustomPlausibilisierung plausi2) {
        if (plausi1 == null || plausi2 == null) {
            throw new NullPointerException();
        }
        String plausiDisplayName = plausi2.getPLName();
        if (plausi1.getPLName() != null && plausi2.getPLName() != null && !plausi1.getPLName().equals(plausi2.getPLName())) {
            plausiDisplayName = plausi1.getPLName() + " => " + plausi2.getPLName();
        }
        this.rootNode = new DiffResultTreeNode(plausiDisplayName, plausi1, plausi2, this);
        this.contextNodeMap = new HashMap();
        this.contextNodeMap.put(plausiDisplayName, this.rootNode);
    }

    DiffResultTreeNode addNode(String context, MetaElement metaElement1, MetaElement metaElement2) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (context.equals("")) {
            throw new IllegalArgumentException("Context darf nicht leer sein!");
        }
        DiffResultTreeNode added = null;
        String parentContext = this.getParentContext(context);
        DiffResultTreeNode parent = (DiffResultTreeNode)this.contextNodeMap.get(parentContext);
        if (parent == null) {
            String farestContext = this.getFarestExistingContext(context);
            DiffResultTreeNode farest = (DiffResultTreeNode)this.contextNodeMap.get(farestContext);
            String missingContext = context.substring(farestContext.length() + "___PKT___".length());
            String[] missingContexts = missingContext.split("___PKT___");
            for (int i = 0; i < missingContexts.length - 1; ++i) {
                farestContext = farestContext + "___PKT___" + missingContexts[i];
                DiffResultTreeNode tmp = new DiffResultTreeNode(farestContext, null, null, this);
                farest.addChildNode(tmp);
                this.contextNodeMap.put(farestContext, tmp);
                farest = tmp;
            }
            parent = farest;
        }
        added = new DiffResultTreeNode(context, metaElement1, metaElement2, this);
        parent.addChildNode(added);
        this.contextNodeMap.put(context, added);
        return added;
    }

    DiffResultTreeNode getGlobalContextNode() {
        return this.getNode(this.getPlausiContext());
    }

    DiffResultTreeNode getGlobalThemenbereicheContextNode() {
        return this.getNode(this.getPlausiTBsContext());
    }

    DiffResultTreeNode getGlobalFunctionsContextNode() {
        return this.getNode(this.getPlausiFunctionsContext());
    }

    DiffResultTreeNode getGlobalClassificationsContextNode() {
        return this.getNode(this.getPlausiClassificationsContext());
    }

    DiffResultTreeNode getNode(String context) {
        return (DiffResultTreeNode)this.contextNodeMap.get(context);
    }

    List getNodeChildren(String context) {
        DiffResultTreeNode node = this.getNode(context);
        return node.getNodeChildren();
    }

    String getPlausiContext() {
        return this.getRootContext() + "___PKT___" + "Globale Elemente";
    }

    String getPlausiTBsContext() {
        return this.getPlausiContext() + "___PKT___" + "Themenbereiche";
    }

    String getPlausiFunctionsContext() {
        return this.getPlausiContext() + "___PKT___" + "Funktionen";
    }

    String getPlausiClassificationsContext() {
        return this.getPlausiContext() + "___PKT___" + "Auspr\u00e4gungsgruppen";
    }

    String getPLStrukturContext() {
        return this.getRootContext() + "___PKT___" + "PL-Struktur";
    }

    String getRootContext() {
        return this.getRootNode().getContext();
    }

    DiffResultTreeNode getRootNode() {
        return this.rootNode;
    }

    DiffResultTreeNode getRootTBContextNode() {
        return this.getNode(this.getPLStrukturContext());
    }

    boolean isHeaderNode(DiffResultTreeNode node) {
        return node == this.getRootNode() || node == this.getRootTBContextNode() || node == this.getGlobalContextNode() || node == this.getGlobalThemenbereicheContextNode() || node == this.getGlobalFunctionsContextNode() || node == this.getGlobalClassificationsContextNode();
    }

    private String getFarestExistingContext(String context) {
        String farestContext = context;
        while (!this.contextNodeMap.containsKey(farestContext)) {
            farestContext = this.getParentContext(farestContext);
        }
        return farestContext;
    }

    private String getParentContext(String context) {
        String parentContext = context;
        int lastSegmentIndex = parentContext.lastIndexOf("___PKT___");
        if (lastSegmentIndex != -1) {
            parentContext = parentContext.substring(0, lastSegmentIndex);
        }
        return parentContext;
    }
}

