/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.cpp.CppCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomParameter;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLParameter;
import java.io.PrintWriter;

public class CppExternalProgramCodeGenerator
extends CppCodeGenerator {
    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        if (!"extern".equals(funktion.getArt())) {
            throw new IllegalStateException("Externe Funktion erwartet.");
        }
        this.indentNewLine();
        CppExternalProgramCodeGenerator.defineFunctionMethodSignature(this.out, funktion);
        this.openBlock();
        this.indentNewLine();
        this.out.print("try");
        this.openBlock();
        this.startNewSection(ElementMessageContext.stringForType(4) + " " + funktion.getName());
        this.indentNewLine();
        this.out.print("Value* ___ext_erg = context->getExternalFunction(\"");
        this.out.print(funktion.getName());
        this.out.print("\")(context");
        if (funktion.sizeOfParameter() > 0) {
            int len = funktion.sizeOfParameter();
            for (int i = 0; i < len; ++i) {
                this.out.print(", ");
                funktion.getFromParameter(i).accept(this);
            }
        }
        this.out.print(");");
        this.leaveCurrentSection();
        this.indentNewLine();
        this.out.print("return ___ext_erg;");
        this.closeBlock();
        this.indentNewLine();
        this.out.print("catch (PlausiException& __exeption)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("context->getLogger()->error() << \"Fehler beim Ansprechen der externen Funktion: " + funktion.getName() + " (\" << __exeption.getMessage() << \")\";");
        this.closeBlock();
        this.indentNewLine();
        this.out.print("catch (...)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("context->getLogger()->error() << \"Fehler beim Ansprechen der externen Funktion: " + funktion.getName() + "\";");
        this.closeBlock();
        this.leaveCurrentSection();
        this.indentNewLine();
        this.out.print("return context->createInvalidValue();");
        this.closeBlock();
    }

    @Override
    public void visitPLParameter(MetaPLParameter aParam) {
        String paramName = StringHelper.getEscapedName(aParam.getName());
        this.out.print("param_" + paramName);
    }

    public static void defineFunctionMethodSignature(PrintWriter out, MetaPLFunktion function) {
        String escapedProgramName = StringHelper.getEscapedName(function.getName());
        out.print("Value* ");
        out.print("prg_");
        out.print(escapedProgramName);
        out.print("(");
        out.print("RuntimeContext*");
        out.print(" context");
        for (int i = 0; i < function.sizeOfParameter(); ++i) {
            MetaCustomParameter aParam = (MetaCustomParameter)function.getFromParameter(i);
            if (!aParam.getListe()) {
                out.print(", ");
                out.print("Value* param_");
                out.print(StringHelper.getEscapedName(aParam.getName()));
                continue;
            }
            out.print(", Value* param_");
            out.print(StringHelper.getEscapedName(aParam.getName()));
            int dimsize = aParam.dimensions().length;
            for (int j = 0; j < dimsize; ++j) {
                out.print("[]");
            }
        }
        out.print(")");
    }
}

