/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.server.FileRepository;
import mondrian.server.ImplicitRepository;
import mondrian.server.MondrianServerImpl;
import mondrian.server.Repository;
import mondrian.server.RepositoryContentFinder;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.IdentityCatalogLocator;
import mondrian.util.LockBox;
import org.apache.log4j.Logger;

public class MondrianServerRegistry {
    public static final Logger logger = Logger.getLogger(MondrianServerRegistry.class);
    public static final MondrianServerRegistry INSTANCE = new MondrianServerRegistry();
    final LockBox lockBox = new LockBox();
    final MondrianServer staticServer = this.createWithRepository(null, null);

    public MondrianServer serverForId(String instanceId) {
        if (instanceId != null) {
            LockBox.Entry entry = this.lockBox.get(instanceId);
            if (entry == null) {
                throw Util.newError("No server instance has id '" + instanceId + "'");
            }
            return (MondrianServer)entry.getValue();
        }
        return this.staticServer;
    }

    public MondrianServer.MondrianVersion getVersion() {
        StringBuilder sb;
        block4: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" Vendor: Pentaho");
                String title = "mondrian";
                logger.debug((Object)"  Title: mondrian");
                String versionString = "4.7.0.0-12";
                logger.debug((Object)"Version: 4.7.0.0-12");
                int majorVersion = 4;
                logger.debug((Object)String.format("Major Version: %d", 4));
                int minorVersion = 70012;
                logger.debug((Object)String.format("Minor Version: %d", 70012));
            }
            sb = new StringBuilder();
            try {
                Integer.parseInt("4.7.0.0-12");
                sb.append("4.7.0.0-12");
            }
            catch (NumberFormatException e) {
                String versionMajor = String.valueOf(4);
                String versionMinor = String.valueOf(70012);
                if (versionMajor != null) {
                    sb.append(versionMajor);
                }
                if (versionMinor == null) break block4;
                sb.append(".").append(versionMinor);
            }
        }
        return new MondrianServer.MondrianVersion(){

            public String getVersionString() {
                return sb.toString();
            }

            public String getProductName() {
                return "mondrian";
            }

            public int getMinorVersion() {
                return 70012;
            }

            public int getMajorVersion() {
                return 4;
            }
        };
    }

    public MondrianServer createWithRepository(RepositoryContentFinder contentFinder, CatalogLocator catalogLocator) {
        Repository repository;
        if (catalogLocator == null) {
            catalogLocator = new IdentityCatalogLocator();
        }
        if (contentFinder == null) {
            if (this.staticServer != null) {
                return this.staticServer;
            }
            repository = new ImplicitRepository();
        } else {
            repository = new FileRepository(contentFinder, catalogLocator);
        }
        return new MondrianServerImpl(this, repository, catalogLocator);
    }
}

