/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.spi.Dialect;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlQuery {
    private final boolean generateFormattedSql;
    private boolean distinct;
    private final ClauseList select;
    private final FromClauseList from;
    private final ClauseList where;
    private final ClauseList groupBy;
    private final ClauseList having;
    private final ClauseList orderBy;
    private final List<ClauseList> groupingSets;
    private final ClauseList groupingFunctions;
    private final List<SqlStatement.Type> types = new ArrayList<SqlStatement.Type>();
    private boolean allowHints;
    private final List<String> fromAliases;
    private int joinCount;
    private final Dialect dialect;
    private final StringBuilder buf;
    private final Map<String, String> columnAliases = new HashMap<String, String>();
    private final List<String> columnAliases2 = new ArrayList<String>();
    private static final String INDENT = "    ";

    public SqlQuery(Dialect dialect, boolean formatted) {
        assert (dialect != null);
        this.generateFormattedSql = formatted;
        this.select = new ClauseList(true);
        this.from = new FromClauseList(true);
        this.groupingFunctions = new ClauseList(false);
        this.where = new ClauseList(false);
        this.groupBy = new ClauseList(false);
        this.having = new ClauseList(false);
        this.orderBy = new ClauseList(false);
        this.fromAliases = new ArrayList<String>();
        this.buf = new StringBuilder(128);
        this.groupingSets = new ArrayList<ClauseList>();
        this.dialect = dialect;
        this.allowHints = false;
    }

    public SqlQuery(Dialect dialect) {
        this(dialect, MondrianProperties.instance().GenerateFormattedSql.get());
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setAllowHints(boolean t) {
        this.allowHints = t;
    }

    private boolean addFromQuery(String query, String alias, String parentAlias, String joinCondition, boolean failIfExists) {
        assert (alias != null);
        assert (alias.length() > 0);
        if (this.fromAliases.contains(alias)) {
            if (failIfExists) {
                throw Util.newInternal("query already contains alias '" + alias + "'");
            }
            return false;
        }
        this.buf.setLength(0);
        this.buf.append('(');
        this.buf.append(query);
        this.buf.append(')');
        if (this.dialect.allowsAs()) {
            this.buf.append(" as ");
        } else {
            this.buf.append(' ');
        }
        this.dialect.quoteIdentifier(alias, this.buf);
        if (parentAlias != null) {
            assert (this.fromAliases.contains(parentAlias));
            assert (joinCondition != null);
            if (this.dialect.allowsJoinOn()) {
                this.buf.append(" on ").append(joinCondition);
                ++this.joinCount;
            } else {
                this.where.add(joinCondition);
            }
        } else {
            assert (joinCondition == null);
            assert (this.from.isEmpty() || !this.dialect.allowsJoinOn());
        }
        this.fromAliases.add(alias);
        this.from.add(this.buf.toString());
        return true;
    }

    boolean addFromTable(String schema, String name, String alias, String filter, Map<String, String> hintMap, String parentAlias, String joinCondition, boolean failIfExists) {
        if (this.fromAliases.contains(alias)) {
            if (failIfExists) {
                throw Util.newInternal("query already contains alias '" + alias + "'");
            }
            return false;
        }
        this.buf.setLength(0);
        this.dialect.quoteIdentifier(this.buf, schema, name);
        if (alias != null) {
            Util.assertTrue(alias.length() > 0);
            if (this.dialect.allowsAs()) {
                this.buf.append(" as ");
            } else {
                this.buf.append(' ');
            }
            this.dialect.quoteIdentifier(alias, this.buf);
        }
        if (this.allowHints) {
            this.dialect.appendHintsAfterFromClause(this.buf, hintMap);
        }
        if (parentAlias != null) {
            assert (this.fromAliases.contains(parentAlias));
            assert (joinCondition != null);
            if (this.dialect.allowsJoinOn()) {
                this.buf.append(" on ").append(joinCondition);
                ++this.joinCount;
            } else {
                this.where.add(joinCondition);
            }
        } else {
            assert (joinCondition == null);
            assert (this.from.isEmpty() || !this.dialect.allowsJoinOn());
        }
        this.fromAliases.add(alias);
        this.from.add(this.buf.toString());
        if (filter != null) {
            this.addWhere("(" + filter + ")");
        }
        return true;
    }

    public void addFrom(SqlQuery sqlQuery, String alias, boolean failIfExists) {
        this.addFromQuery(sqlQuery.toString(), alias, null, null, failIfExists);
    }

    public boolean addFrom(RolapSchema.PhysRelation relation, String alias, boolean failIfExists) {
        return this.addFrom_(relation, alias, null, null, failIfExists);
    }

    public boolean addFrom(RolapSchema.PhysRelation relation, String alias, String parentAlias, String joinCondition, boolean failIfExists) {
        return this.addFrom_(relation, alias, parentAlias, joinCondition, failIfExists);
    }

    private boolean addFrom_(RolapSchema.PhysRelation relation, String alias, String parentAlias, String joinCondition, boolean failIfExists) {
        Util.deprecated("alias param probably not necessary", false);
        Util.deprecated("adopt visitor pattern and replace 'instanceof' below", false);
        if (relation instanceof RolapSchema.PhysView) {
            RolapSchema.PhysView view = (RolapSchema.PhysView)relation;
            String viewAlias = alias == null ? view.getAlias() : alias;
            String sqlString = view.getSqlString();
            return this.addFromQuery(sqlString, viewAlias, parentAlias, joinCondition, false);
        }
        if (relation instanceof RolapSchema.PhysTable) {
            RolapSchema.PhysTable table = (RolapSchema.PhysTable)relation;
            String tableAlias = alias == null ? table.getAlias() : alias;
            return this.addFromTable(table.getSchemaName(), table.getName(), tableAlias, null, table.getHintMap(), parentAlias, joinCondition, failIfExists);
        }
        if (relation instanceof RolapSchema.PhysInlineTable) {
            RolapSchema.PhysInlineTable table = (RolapSchema.PhysInlineTable)relation;
            RolapSchema.PhysView physView = RolapUtil.convertInlineTableToRelation(table, this.dialect);
            return this.addFromQuery(physView.getSqlString(), table.getAlias(), parentAlias, joinCondition, failIfExists);
        }
        Util.deprecated("remove above commented section", false);
        throw Util.newInternal("bad relation type " + relation);
    }

    public String addSelect(String expression, SqlStatement.Type type) {
        return this.addSelect(expression, type, null);
    }

    public String addSelectGroupBy(String expression, SqlStatement.Type type) {
        String alias = this.addSelect(expression, type);
        this.addGroupBy(expression, alias);
        return alias;
    }

    public int getCurrentSelectListSize() {
        return this.select.size();
    }

    public String nextColumnAlias() {
        return "c" + this.select.size();
    }

    public String addSelect(String expression, SqlStatement.Type type, String alias) {
        if (alias == null) {
            alias = this.nextColumnAlias();
        }
        switch (this.dialect.getDatabaseProduct()) {
            case DB2_AS400: 
            case DERBY: {
                alias = null;
            }
        }
        this.buf.setLength(0);
        this.buf.append(expression);
        if (alias != null) {
            this.buf.append(" as ");
            this.dialect.quoteIdentifier(alias, this.buf);
        }
        this.select.add(this.buf.toString());
        this.types.add(type);
        this.columnAliases2.add(alias);
        this.columnAliases.put(expression, alias);
        return alias;
    }

    public String getAlias(String expression) {
        return this.columnAliases.get(expression);
    }

    public String getAlias(int i) {
        return this.columnAliases2.get(i);
    }

    public void addWhere(String expression) {
        this.where.add(expression);
    }

    public void addGroupBy(String expression) {
        this.groupBy.add(expression);
    }

    public void addGroupBy(String expression, String alias) {
        if (this.dialect.requiresGroupByAlias()) {
            this.addGroupBy(this.dialect.quoteIdentifier(alias));
        } else {
            this.addGroupBy(expression);
        }
    }

    public void addHaving(String expression) {
        this.having.add(expression);
    }

    public void addOrderBy(String expr, boolean ascending, boolean prepend, boolean nullable) {
        this.addOrderBy(expr, expr, ascending, prepend, nullable, true);
    }

    public void addOrderBy(String expr, String alias, boolean ascending, boolean prepend, boolean nullable, boolean collateNullsLast) {
        String orderExpr = this.dialect.generateOrderItem(this.dialect.requiresOrderByAlias() ? alias : expr, nullable, ascending, collateNullsLast);
        if (prepend) {
            this.orderBy.add(0, orderExpr);
        } else {
            this.orderBy.add(orderExpr);
        }
    }

    public String toString() {
        return this.toBuffer(new StringBuilder(), "").toString();
    }

    public StringBuilder toBuffer(StringBuilder buf, String prefix) {
        String fromSep;
        String first = this.distinct ? "select distinct " : "select ";
        this.select.toBuffer(buf, this.generateFormattedSql, prefix, first, ", ", "", "");
        this.groupingFunctionsToBuffer(buf, prefix);
        String string = fromSep = this.joinCount > 0 ? " join " : ", ";
        if (this.dialect.allowsJoinOn() && this.from.size() > 1 && this.joinCount <= 0) {
            throw new AssertionError();
        }
        this.from.toBuffer(buf, this.generateFormattedSql, prefix, " from ", fromSep, "", "");
        this.where.toBuffer(buf, this.generateFormattedSql, prefix, " where ", " and ", "", "");
        if (this.groupingSets.isEmpty()) {
            this.groupBy.toBuffer(buf, this.generateFormattedSql, prefix, " group by ", ", ", "", "");
        } else {
            ClauseList.listToBuffer(buf, this.groupingSets, this.generateFormattedSql, prefix, " group by grouping sets (", ", ", ")");
        }
        this.having.toBuffer(buf, this.generateFormattedSql, prefix, " having ", " and ", "", "");
        this.orderBy.toBuffer(buf, this.generateFormattedSql, prefix, " order by ", ", ", "", "");
        return buf;
    }

    private void groupingFunctionsToBuffer(StringBuilder buf, String prefix) {
        if (this.groupingSets.isEmpty()) {
            return;
        }
        int n = 0;
        for (String groupingFunction : this.groupingFunctions) {
            if (this.generateFormattedSql) {
                buf.append(",").append(Util.nl).append(INDENT).append(prefix);
            } else {
                buf.append(", ");
            }
            buf.append("grouping(").append(groupingFunction).append(") as ");
            this.dialect.quoteIdentifier("g" + n++, buf);
        }
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public static SqlQuery newQuery(Dialect dialect, String err) {
        return new SqlQuery(dialect);
    }

    public void addGroupingSet(List<String> groupingColumnsExpr) {
        ClauseList groupingList = new ClauseList(false);
        for (String columnExp : groupingColumnsExpr) {
            groupingList.add(columnExp);
        }
        this.groupingSets.add(groupingList);
    }

    public void addGroupingFunction(String columnExpr) {
        this.groupingFunctions.add(columnExpr);
        this.types.add(null);
    }

    public String toSql() {
        return this.toString();
    }

    public Pair<String, List<SqlStatement.Type>> toSqlAndTypes() {
        assert (this.types.size() == this.select.size() + this.groupingFunctions.size()) : this.types.size() + " types, " + (this.select.size() + this.groupingFunctions.size()) + " select items in query " + this;
        return Pair.of(this.toString(), this.types);
    }

    public boolean isUnsatisfiable() {
        return this.where.contains("FALSE");
    }

    public static String getBestName(Dialect dialect) {
        return dialect.getDatabaseProduct().getFamily().name().toLowerCase();
    }

    private static class RelInfo {
        final MondrianDef.Relation relation;
        final String leftKey;
        final String leftAlias;
        final String rightKey;
        final String rightAlias;

        public RelInfo(MondrianDef.Relation relation, String leftKey, String leftAlias, String rightKey, String rightAlias) {
            this.relation = relation;
            this.leftKey = leftKey;
            this.leftAlias = leftAlias;
            this.rightKey = rightKey;
            this.rightAlias = rightAlias;
        }
    }

    public static class CodeSet {
        private final Map<String, String> dialectCodes = new HashMap<String, String>();

        public String put(String dialect, String code) {
            return this.dialectCodes.put(dialect, code);
        }

        public String chooseQuery(Dialect dialect) {
            String best = SqlQuery.getBestName(dialect);
            String bestCode = this.dialectCodes.get(best);
            if (bestCode != null) {
                return bestCode;
            }
            String genericCode = this.dialectCodes.get("generic");
            if (genericCode == null) {
                throw Util.newError("View has no 'generic' variant");
            }
            return genericCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClauseList
    extends ArrayList<String> {
        protected final boolean allowDups;

        ClauseList(boolean allowDups) {
            this.allowDups = allowDups;
        }

        @Override
        public boolean add(String element) {
            if (this.allowDups || !this.contains(element)) {
                return super.add(element);
            }
            return false;
        }

        final void toBuffer(StringBuilder buf, boolean generateFormattedSql, String prefix, String first, String sep, String last, String empty) {
            if (this.isEmpty()) {
                buf.append(empty);
                return;
            }
            first = ClauseList.foo(generateFormattedSql, prefix, first);
            sep = ClauseList.foo(generateFormattedSql, prefix, sep);
            this.toBuffer(buf, first, sep, last);
        }

        static String foo(boolean generateFormattedSql, String prefix, String s) {
            if (generateFormattedSql) {
                if (s.startsWith(" ")) {
                    s = Util.nl + prefix + s.substring(1);
                }
                if (s.endsWith(" ")) {
                    s = s.substring(0, s.length() - 1) + Util.nl + prefix + SqlQuery.INDENT;
                } else if (s.endsWith("(")) {
                    s = s + Util.nl + prefix + SqlQuery.INDENT;
                }
            }
            return s;
        }

        final void toBuffer(StringBuilder buf, String first, String sep, String last) {
            int n = 0;
            buf.append(first);
            for (String s : this) {
                if (n++ > 0) {
                    buf.append(sep);
                }
                buf.append(s);
            }
            buf.append(last);
        }

        static void listToBuffer(StringBuilder buf, List<ClauseList> clauseListList, boolean generateFormattedSql, String prefix, String first, String sep, String last) {
            first = ClauseList.foo(generateFormattedSql, prefix, first);
            sep = ClauseList.foo(generateFormattedSql, prefix, sep);
            buf.append(first);
            int n = 0;
            for (ClauseList clauseList : clauseListList) {
                if (n++ > 0) {
                    buf.append(sep);
                }
                clauseList.toBuffer(buf, false, prefix, "(", ", ", ")", "()");
            }
            buf.append(last);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FromClauseList
    extends ClauseList {
        private final List<JoinOnClause> joinOnClauses = new ArrayList<JoinOnClause>();

        FromClauseList(boolean allowsDups) {
            super(allowsDups);
        }

        public void addOn(String leftAlias, String leftKey, String rightAlias, String rightKey, String condition) {
            if (leftAlias != null || rightAlias != null) {
                if (leftAlias == null) {
                    leftAlias = rightAlias;
                } else if (rightAlias == null) {
                    rightAlias = leftAlias;
                }
            }
            this.joinOnClauses.add(new JoinOnClause(condition, leftAlias, rightAlias));
        }

        public void toBuffer(StringBuilder buf, List<String> fromAliases) {
            int n = 0;
            for (int i = 0; i < this.size(); ++i) {
                String s = (String)this.get(i);
                String alias = fromAliases.get(i);
                if (n++ == 0) {
                    buf.append(" from ");
                    buf.append(s);
                    continue;
                }
                this.appendJoin(fromAliases.subList(0, i), s, alias, buf);
            }
        }

        void appendJoin(List<String> addedTables, String from, String alias, StringBuilder buf) {
            int n = 0;
            for (JoinOnClause joinOnClause : this.joinOnClauses) {
                if (!(addedTables.size() == 1 && addedTables.get(0).equals(joinOnClause.left) && joinOnClause.left.equals(joinOnClause.right) || alias.equals(joinOnClause.left) && addedTables.contains(joinOnClause.right)) && (!alias.equals(joinOnClause.right) || !addedTables.contains(joinOnClause.left))) continue;
                if (n++ == 0) {
                    buf.append(" join ").append(from).append(" on ");
                } else {
                    buf.append(" and ");
                }
                buf.append(joinOnClause.condition);
            }
            if (n == 0) {
                buf.append(this.joinOnClauses.isEmpty() ? ", " : " cross join ").append(from);
            }
        }
    }

    private static class JoinOnClause {
        private final String condition;
        private final String left;
        private final String right;

        JoinOnClause(String condition, String left, String right) {
            this.condition = condition;
            this.left = left;
            this.right = right;
        }
    }
}

