/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.PredicateColumn;
import mondrian.spi.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberTuplePredicate
implements StarPredicate {
    private final List<Interval> intervals;
    private final List<PredicateColumn> columnList = new ArrayList<PredicateColumn>();
    private final BitKey columnBitKey;

    MemberTuplePredicate(RolapSchema.PhysRouter router, RolapSchema.PhysSchema physSchema, List<RolapSchema.PhysColumn> physColumnList, List<Interval> intervals) {
        this.columnBitKey = BitKey.Factory.makeBitKey(physSchema.getColumnCount());
        for (RolapSchema.PhysColumn column : physColumnList) {
            this.columnList.add(new PredicateColumn(router, column));
        }
        this.intervals = intervals;
    }

    public String toString() {
        return this.columnList + " " + this.intervals;
    }

    public int hashCode() {
        int h = this.columnBitKey.hashCode();
        return Util.hash(h, this.intervals);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MemberTuplePredicate)) {
            return false;
        }
        MemberTuplePredicate that = (MemberTuplePredicate)obj;
        return this.columnBitKey.equals(that.columnBitKey) && this.columnList.equals(that.columnList) && this.intervals.equals(that.intervals);
    }

    @Override
    public List<PredicateColumn> getColumnList() {
        return this.columnList;
    }

    @Override
    public BitKey getConstrainedColumnBitKey() {
        return this.columnBitKey;
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StarPredicate minus(StarPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StarPredicate or(StarPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StarPredicate and(StarPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        for (Interval interval : this.intervals) {
            if (!interval.evaluate(valueList)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void describe(StringBuilder buf) {
        int k = 0;
        for (Interval interval : this.intervals) {
            if (k++ > 0) {
                buf.append(" OR ");
            }
            interval.describe(buf);
        }
    }

    @Override
    public void toSql(Dialect dialect, StringBuilder buf) {
        for (int i = 0; i < this.intervals.size(); ++i) {
            Interval interval = this.intervals.get(i);
            if (i > 0) {
                buf.append(" or ");
            }
            interval.toSql(dialect, MemberTuplePredicate.unwrap(this.columnList), buf);
        }
    }

    private static List<RolapSchema.PhysColumn> unwrap(final List<PredicateColumn> columnList) {
        return new AbstractList<RolapSchema.PhysColumn>(){

            @Override
            public RolapSchema.PhysColumn get(int index) {
                return ((PredicateColumn)columnList.get((int)index)).physColumn;
            }

            @Override
            public int size() {
                return columnList.size();
            }
        };
    }

    static Interval createRange(RolapMember lower, boolean lowerStrict, RolapMember upper, boolean upperStrict) {
        if (lower == null) {
            assert (upper != null);
            return new Interval(new Bound(upper, upperStrict ? RelOp.LT : RelOp.LE));
        }
        if (upper == null) {
            return new Interval(new Bound(lower, lowerStrict ? RelOp.GT : RelOp.GE));
        }
        return new Interval(new Bound(lower, lowerStrict ? RelOp.GT : RelOp.GE), new Bound(upper, upperStrict ? RelOp.LT : RelOp.LE));
    }

    static Interval createPoint(RolapMember member) {
        return new Interval(new Bound(member, RelOp.EQ));
    }

    static List<Interval> createList(List<RolapMember> members) {
        ArrayList<Interval> list = new ArrayList<Interval>(members.size());
        for (RolapMember member : members) {
            list.add(MemberTuplePredicate.createPoint(member));
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Interval {
        protected final Bound[] bounds;

        Interval(Bound ... bounds) {
            this.bounds = bounds;
        }

        boolean evaluate(List<Object> valueList) {
            for (Bound bound : this.bounds) {
                block8: for (int k = 0; k < bound.values.size(); ++k) {
                    Object value = valueList.get(k);
                    if (value == StarPredicate.WILDCARD) {
                        return false;
                    }
                    Object boundValue = bound.values.get(k);
                    RelOp relOp = (RelOp)((Object)bound.relOps.get(k));
                    int c = Util.compareKey(value, boundValue);
                    switch (relOp) {
                        case GT: {
                            if (c > 0) continue block8;
                            return false;
                        }
                        case GE: {
                            if (c > 0) {
                                return true;
                            }
                            if (c == 0) continue block8;
                            return false;
                        }
                        case LT: {
                            if (c < 0) continue block8;
                            return false;
                        }
                        case LE: {
                            if (c < 0) {
                                return true;
                            }
                            if (c == 0) continue block8;
                            return false;
                        }
                        case EQ: {
                            if (c == 0) continue block8;
                            return false;
                        }
                    }
                }
            }
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bounds);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Interval && Arrays.equals(this.bounds, ((Interval)obj).bounds);
        }

        public String toString() {
            return Arrays.toString(this.bounds);
        }

        public void describe(StringBuilder buf) {
            int k = 0;
            for (Bound bound : this.bounds) {
                if (k++ > 0) {
                    buf.append(" AND ");
                }
                bound.describe(buf);
            }
        }

        public void toSql(Dialect dialect, List<RolapSchema.PhysColumn> columnList, StringBuilder buf) {
            for (int i = 0; i < this.bounds.length; ++i) {
                Bound bound = this.bounds[i];
                if (i > 0) {
                    buf.append(" and ");
                }
                bound.toSql(dialect, columnList, buf);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Bound {
        private final RolapMember member;
        private final List<Comparable> values;
        private final List<RelOp> relOps;

        Bound(RolapMember member, RelOp relOp) {
            this.member = member;
            this.values = member.getKeyAsList();
            this.relOps = relOp.list(this.values.size());
        }

        public int hashCode() {
            return Util.hashV(0, this.member, this.values, this.relOps);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Bound) {
                Bound that = (Bound)obj;
                return this.member.equals(that.member) && this.values.equals(that.values) && this.relOps.equals(that.relOps);
            }
            return false;
        }

        public void describe(StringBuilder buf) {
            buf.append(this.relOps.get(this.relOps.size() - 1).getOp());
            buf.append(' ');
            buf.append(this.member);
        }

        public void toSql(Dialect dialect, List<RolapSchema.PhysColumn> columns, StringBuilder buf) {
            for (int i = 0; i < this.values.size(); ++i) {
                if (i > 0) {
                    buf.append(" and ");
                }
                this.toSql(dialect, buf, this.relOps.get(i), this.values.get(i), columns.get(i));
            }
        }

        private void toSql(Dialect dialect, StringBuilder buf, RelOp relOp, Object value, RolapSchema.PhysColumn column) {
            if (value == RolapUtil.sqlNullValue) {
                relOp = RelOp.ISNULL;
            }
            buf.append(column.toSql());
            switch (relOp) {
                case ISNULL: {
                    buf.append(" IS NULL");
                    return;
                }
            }
            buf.append(' ');
            buf.append(relOp.getOp());
            buf.append(' ');
            dialect.quote(buf, value, column.getDatatype());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RelOp {
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">="),
        EQ("="),
        ISNULL("IS NULL");

        private final String op;
        private final List<RelOp> singletonList;

        private RelOp(String op) {
            this.op = op;
            this.singletonList = Collections.singletonList(this);
        }

        String getOp() {
            return this.op;
        }

        public RelOp destrict() {
            switch (this) {
                case GT: {
                    return GE;
                }
                case LT: {
                    return LE;
                }
            }
            return this;
        }

        public List<RelOp> list(final int size) {
            if (size == 1) {
                return this.singletonList;
            }
            switch (this) {
                case GT: 
                case LT: 
                case EQ: {
                    return Collections.nCopies(size, this);
                }
            }
            return new AbstractList<RelOp>(){

                @Override
                public RelOp get(int index) {
                    return index == size - 1 ? RelOp.this : RelOp.this.destrict();
                }

                @Override
                public int size() {
                    return size;
                }
            };
        }
    }
}

