/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Arrays;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MemberKey {
    private final RolapMember parent;
    private final Object[] value;

    MemberKey(RolapMember parent, Object[] value) {
        this.parent = parent;
        this.value = value;
    }

    MemberKey(RolapMember parent, List<Object> value) {
        this.parent = parent;
        this.value = value.toArray(new Object[value.size()]);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MemberKey)) {
            return false;
        }
        MemberKey other = (MemberKey)o;
        return Util.equals(this.parent, other.parent) && Arrays.equals(other.value, this.value);
    }

    public int hashCode() {
        int h = 0;
        if (this.value != null) {
            h = this.value.hashCode();
        }
        if (this.parent != null) {
            h = h * 31 + this.parent.hashCode();
        }
        return h;
    }

    public RolapCubeLevel getLevel() {
        if (this.parent == null) {
            return null;
        }
        RolapCubeLevel level = this.parent.getLevel();
        if (level.isParentChild()) {
            return level;
        }
        return level.getChildLevel();
    }
}

