/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.annotations.CarteServlet;
import org.pentaho.di.core.util.ExecutorUtil;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.Carte;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.CarteSingleton;

@CarteServlet(id="StopCarteServlet", name="StopCarteServlet")
public class StopCarteServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = StopCarteServlet.class;
    private static final long serialVersionUID = -5459379367791045161L;
    public static final String CONTEXT_PATH = "/kettle/stopCarte";
    public static final String REQUEST_ACCEPTED = "request_accepted";
    private final DelayedExecutor delayedExecutor;

    public StopCarteServlet() {
        this(new DelayedExecutor());
    }

    public StopCarteServlet(DelayedExecutor delayedExecutor) {
        this.delayedExecutor = delayedExecutor;
    }

    @Override
    public String getService() {
        return "/kettle/stopCarte (" + this.toString() + ")";
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StopCarteServlet.shutdownRequest", (String[])new String[0]));
        }
        response.setStatus(200);
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html");
        }
        PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
        final Carte carte = CarteSingleton.getCarte();
        if (useXML) {
            out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            out.print(XMLHandler.addTagValue((String)REQUEST_ACCEPTED, (carte != null ? 1 : 0) != 0));
            out.flush();
        } else {
            out.println("<HTML>");
            out.println("<HEAD><TITLE>" + BaseMessages.getString(PKG, (String)"StopCarteServlet.shutdownRequest", (String[])new String[0]) + "</TITLE></HEAD>");
            out.println("<BODY>");
            out.println("<H1>" + BaseMessages.getString(PKG, (String)"StopCarteServlet.status.label", (String[])new String[0]) + "</H1>");
            out.println("<p>");
            if (carte != null) {
                out.println(BaseMessages.getString(PKG, (String)"StopCarteServlet.shutdownRequest.status.ok", (String[])new String[0]));
            } else {
                out.println(BaseMessages.getString(PKG, (String)"StopCarteServlet.shutdownRequest.status.notFound", (String[])new String[0]));
            }
            out.println("</p>");
            out.println("</BODY>");
            out.println("</HTML>");
            out.flush();
        }
        if (carte != null) {
            this.delayedExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    carte.getWebServer().stopServer();
                    StopCarteServlet.exitJVM(0);
                }
            }, 1000L);
        }
    }

    public String toString() {
        return BaseMessages.getString(PKG, (String)"StopCarteServlet.description", (String[])new String[0]);
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    private static final void exitJVM(int status) {
        System.exit(status);
    }

    public static class DelayedExecutor {
        public void execute(final Runnable runnable, final long delay) {
            ExecutorUtil.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    runnable.run();
                }
            });
        }
    }
}

