/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.nullif;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.nullif.NullIf;
import org.pentaho.di.trans.steps.nullif.NullIfData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="Injection.NullIf.", groups={"FIELDS"})
public class NullIfMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = NullIfMeta.class;
    @InjectionDeep
    private Field[] fields;

    public Field[] getFields() {
        return this.fields;
    }

    public void setFields(Field[] fields) {
        this.fields = fields;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.fields = new Field[count];
        for (int i = 0; i < count; ++i) {
            this.fields[i] = new Field();
        }
    }

    @Override
    public Object clone() {
        NullIfMeta retval = (NullIfMeta)super.clone();
        int count = this.fields.length;
        retval.allocate(count);
        for (int i = 0; i < count; ++i) {
            retval.getFields()[i] = this.fields[i].clone();
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fieldNodes = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fieldNodes, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fieldNodes, (String)"field", (int)i);
                this.fields[i].setFieldName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.fields[i].setFieldValue(XMLHandler.getTagValue((Node)fnode, (String)"value"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"NullIfMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fields[i].setFieldName("field" + i);
            this.fields[i].setFieldValue("");
        }
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (r == null) {
            r = new RowMeta();
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.fields.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.fields[i].getFieldName()));
            retval.append("        " + XMLHandler.addTagValue((String)"value", (String)this.fields[i].getFieldValue()));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fields[i].setFieldName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.fields[i].setFieldValue(rep.getStepAttributeString(id_step, i, "field_value"));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"NullIfMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fields[i].getFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_value", this.fields[i].getFieldValue());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"NullIfMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"NullIfMeta.CheckResult.NoReceivingFieldsError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NullIfMeta.CheckResult.StepReceivingFieldsOK", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NullIfMeta.CheckResult.StepRecevingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"NullIfMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new NullIf(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new NullIfData();
    }

    public static class Field
    implements Cloneable {
        @Injection(name="FIELDNAME", group="FIELDS")
        private String fieldName;
        @Injection(name="FIELDVALUE", group="FIELDS")
        private String fieldValue;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }

        public void setFieldValue(String fieldValue) {
            Boolean isEmptyAndNullDiffer = ValueMetaBase.convertStringToBoolean((String)Const.NVL((String)System.getProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "N"), (String)"N"));
            this.fieldValue = fieldValue == null && isEmptyAndNullDiffer != false ? "" : fieldValue;
        }

        public Field clone() {
            try {
                return (Field)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

