/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mail;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mail.MailData;
import org.pentaho.di.trans.steps.mail.MailMeta;

public class Mail
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MailMeta.class;
    private static final String MAIL_CHARSET_KEY = "mail.mime.charset";
    private static final String MAIL_CHARSET = "UTF-8";
    private MailMeta meta;
    private MailData data;

    public Mail(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.setMailMimeCharsetProperty();
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block19: {
            this.meta = (MailMeta)smi;
            this.data = (MailData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.previousRowMeta = this.getInputRowMeta().clone();
                this.validateMetaFields(this.meta);
                this.cacheFieldsPosition(this.meta, this.data);
                this.checkEmbeddedImages(this.meta, this.data);
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                String servername;
                String maildestination = this.data.previousRowMeta.getString(r, this.data.indexOfDestination);
                if (Utils.isEmpty((CharSequence)maildestination)) {
                    throw new KettleException("Mail.Error.MailDestinationEmpty");
                }
                String maildestinationCc = null;
                if (this.data.indexOfDestinationCc > -1) {
                    maildestinationCc = this.data.previousRowMeta.getString(r, this.data.indexOfDestinationCc);
                }
                String maildestinationBCc = null;
                if (this.data.indexOfDestinationBCc > -1) {
                    maildestinationBCc = this.data.previousRowMeta.getString(r, this.data.indexOfDestinationBCc);
                }
                String mailsendername = null;
                if (this.data.indexOfSenderName > -1) {
                    mailsendername = this.data.previousRowMeta.getString(r, this.data.indexOfSenderName);
                }
                String mailsenderaddress = this.data.previousRowMeta.getString(r, this.data.indexOfSenderAddress);
                String mailreplyToAddresses = null;
                if (this.data.indexOfReplyToAddresses > -1) {
                    mailreplyToAddresses = this.data.previousRowMeta.getString(r, this.data.indexOfReplyToAddresses);
                }
                String contactperson = null;
                if (this.data.indexOfContactPerson > -1) {
                    contactperson = this.data.previousRowMeta.getString(r, this.data.indexOfContactPerson);
                }
                String contactphone = null;
                if (this.data.indexOfContactPhone > -1) {
                    contactphone = this.data.previousRowMeta.getString(r, this.data.indexOfContactPhone);
                }
                if (Utils.isEmpty((CharSequence)(servername = this.data.previousRowMeta.getString(r, this.data.indexOfServer)))) {
                    throw new KettleException("Mail.Error.MailServerEmpty");
                }
                int port = -1;
                if (this.data.indexOfPort > -1) {
                    port = Const.toInt((String)("" + this.data.previousRowMeta.getInteger(r, this.data.indexOfPort)), (int)-1);
                }
                String authuser = null;
                if (this.data.indexOfAuthenticationUser > -1) {
                    authuser = this.data.previousRowMeta.getString(r, this.data.indexOfAuthenticationUser);
                }
                String authpass = null;
                if (this.data.indexOfAuthenticationPass > -1) {
                    authpass = Utils.resolvePassword((VariableSpace)this.getParentVariableSpace(), (String)this.data.previousRowMeta.getString(r, this.data.indexOfAuthenticationPass));
                }
                String subject = null;
                if (this.data.indexOfSubject > -1) {
                    subject = this.data.previousRowMeta.getString(r, this.data.indexOfSubject);
                }
                String comment = null;
                if (this.data.indexOfComment > -1) {
                    comment = this.data.previousRowMeta.getString(r, this.data.indexOfComment);
                }
                this.sendMail(r, servername, port, mailsenderaddress, mailsendername, maildestination, maildestinationCc, maildestinationBCc, contactperson, contactphone, authuser, authpass, subject, comment, mailreplyToAddresses);
                this.putRow(this.getInputRowMeta(), r);
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"Mail.Log.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Error.General", (String[])new String[0]), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block19;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "MAIL001");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEmbeddedImages(MailMeta meta, MailData data) {
        if (meta.getEmbeddedImages() != null && meta.getEmbeddedImages().length > 0) {
            FileObject image = null;
            data.embeddedMimePart = new HashSet();
            try {
                for (int i = 0; i < meta.getEmbeddedImages().length; ++i) {
                    String imageFile = this.environmentSubstitute(meta.getEmbeddedImages()[i]);
                    String contentID = this.environmentSubstitute(meta.getContentIds()[i]);
                    image = KettleVFS.getFileObject((String)imageFile);
                    if (image.exists() && image.getType() == FileType.FILE) {
                        MimeBodyPart imagePart = new MimeBodyPart();
                        URLDataSource fds = new URLDataSource(image.getURL());
                        imagePart.setDataHandler(new DataHandler((DataSource)fds));
                        imagePart.setHeader("Content-ID", "<" + contentID + ">");
                        data.embeddedMimePart.add(imagePart);
                        this.logBasic(BaseMessages.getString(PKG, (String)"Mail.Log.ImageAdded", (String[])new String[]{imageFile}));
                        continue;
                    }
                    this.logError(BaseMessages.getString(PKG, (String)"Mail.Log.WrongImage", (String[])new String[]{imageFile}));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"Mail.Error.AddingImage", (String[])new String[]{e.getMessage()}));
            }
            finally {
                if (image != null) {
                    try {
                        image.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void cacheFieldsPosition(MailMeta meta, MailData data) throws KettleException {
        if (data.indexOfDestination < 0) {
            String realDestinationFieldname = meta.getDestination();
            data.indexOfDestination = data.previousRowMeta.indexOfValue(realDestinationFieldname);
            if (data.indexOfDestination < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindDestinationField", (String[])new String[]{realDestinationFieldname}));
            }
        }
        if (!Utils.isEmpty((CharSequence)meta.getDestinationCc()) && data.indexOfDestinationCc < 0) {
            String realDestinationCcFieldname = meta.getDestinationCc();
            data.indexOfDestinationCc = data.previousRowMeta.indexOfValue(realDestinationCcFieldname);
            if (data.indexOfDestinationCc < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindDestinationCcField", (String[])new String[]{realDestinationCcFieldname}));
            }
        }
        if (!Utils.isEmpty((CharSequence)meta.getDestinationBCc()) && data.indexOfDestinationBCc < 0) {
            String realDestinationBCcFieldname = meta.getDestinationBCc();
            data.indexOfDestinationBCc = data.previousRowMeta.indexOfValue(realDestinationBCcFieldname);
            if (data.indexOfDestinationBCc < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindDestinationBCcField", (String[])new String[]{realDestinationBCcFieldname}));
            }
        }
        if (!Utils.isEmpty((CharSequence)meta.getReplyName()) && data.indexOfSenderName < 0) {
            String realSenderName = meta.getReplyName();
            data.indexOfSenderName = data.previousRowMeta.indexOfValue(realSenderName);
            if (data.indexOfSenderName < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindReplyNameField", (String[])new String[]{realSenderName}));
            }
        }
        if (data.indexOfSenderAddress < 0) {
            String realSenderAddress = meta.getReplyAddress();
            data.indexOfSenderAddress = data.previousRowMeta.indexOfValue(realSenderAddress);
            if (data.indexOfSenderAddress < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindReplyAddressField", (String[])new String[]{realSenderAddress}));
            }
        }
        if (!Utils.isEmpty((CharSequence)meta.getReplyToAddresses()) && data.indexOfReplyToAddresses < 0) {
            String realReplyToAddresses = meta.getReplyToAddresses();
            data.indexOfReplyToAddresses = data.previousRowMeta.indexOfValue(realReplyToAddresses);
            if (data.indexOfReplyToAddresses < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindReplyToAddressesField", (String[])new String[]{realReplyToAddresses}));
            }
        }
        if (!Utils.isEmpty((CharSequence)meta.getContactPerson()) && data.indexOfContactPerson < 0) {
            String realContactPerson = meta.getContactPerson();
            data.indexOfContactPerson = data.previousRowMeta.indexOfValue(realContactPerson);
            if (data.indexOfContactPerson < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindContactPersonField", (String[])new String[]{realContactPerson}));
            }
        }
        if (!Utils.isEmpty((CharSequence)meta.getContactPhone()) && data.indexOfContactPhone < 0) {
            String realContactPhone = meta.getContactPhone();
            data.indexOfContactPhone = data.previousRowMeta.indexOfValue(realContactPhone);
            if (data.indexOfContactPhone < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindContactPhoneField", (String[])new String[]{realContactPhone}));
            }
        }
        if (data.indexOfServer < 0) {
            String realServer = meta.getServer();
            data.indexOfServer = data.previousRowMeta.indexOfValue(realServer);
            if (data.indexOfServer < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindServerField", (String[])new String[]{realServer}));
            }
        }
        if (!Utils.isEmpty((CharSequence)meta.getPort()) && data.indexOfPort < 0) {
            String realPort = meta.getPort();
            data.indexOfPort = data.previousRowMeta.indexOfValue(realPort);
            if (data.indexOfPort < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindPortField", (String[])new String[]{realPort}));
            }
        }
        if (meta.isUsingAuthentication()) {
            if (data.indexOfAuthenticationUser < 0) {
                String realAuthenticationUser = meta.getAuthenticationUser();
                data.indexOfAuthenticationUser = data.previousRowMeta.indexOfValue(realAuthenticationUser);
                if (data.indexOfAuthenticationUser < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindAuthenticationUserField", (String[])new String[]{realAuthenticationUser}));
                }
            }
            if (data.indexOfAuthenticationPass < 0) {
                String realAuthenticationPassword = Utils.resolvePassword((VariableSpace)this.variables, (String)meta.getAuthenticationPassword());
                data.indexOfAuthenticationPass = data.previousRowMeta.indexOfValue(realAuthenticationPassword);
                if (data.indexOfAuthenticationPass < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindAuthenticationPassField", (String[])new String[]{realAuthenticationPassword}));
                }
            }
        }
        if (!Utils.isEmpty((CharSequence)meta.getSubject()) && data.indexOfSubject < 0) {
            String realSubject = meta.getSubject();
            data.indexOfSubject = data.previousRowMeta.indexOfValue(realSubject);
            if (data.indexOfSubject < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindSubjectField", (String[])new String[]{realSubject}));
            }
        }
        if (!Utils.isEmpty((CharSequence)meta.getComment()) && data.indexOfComment < 0) {
            String realComment = meta.getComment();
            data.indexOfComment = data.previousRowMeta.indexOfValue(realComment);
            if (data.indexOfComment < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindCommentField", (String[])new String[]{realComment}));
            }
        }
        if (meta.isAttachContentFromField()) {
            String attachedContentField = meta.getAttachContentField();
            if (Utils.isEmpty((CharSequence)attachedContentField)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.AttachedContentFieldEmpty", (String[])new String[0]));
            }
            data.indexOfAttachedContent = data.previousRowMeta.indexOfValue(attachedContentField);
            if (data.indexOfAttachedContent < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindAttachedContentField", (String[])new String[]{attachedContentField}));
            }
            String attachedContentFileNameField = meta.getAttachContentFileNameField();
            if (Utils.isEmpty((CharSequence)attachedContentFileNameField)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.AttachedContentFileNameFieldEmpty", (String[])new String[0]));
            }
            data.IndexOfAttachedFilename = data.previousRowMeta.indexOfValue(attachedContentFileNameField);
            if (data.IndexOfAttachedFilename < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindAttachedContentFileNameField", (String[])new String[]{attachedContentFileNameField}));
            }
        } else {
            if (meta.isZipFilenameDynamic() && data.indexOfDynamicZipFilename < 0) {
                String realZipFilename = meta.getDynamicZipFilenameField();
                data.indexOfDynamicZipFilename = data.previousRowMeta.indexOfValue(realZipFilename);
                if (data.indexOfDynamicZipFilename < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotSourceAttachedZipFilenameField", (String[])new String[]{realZipFilename}));
                }
            }
            data.zipFileLimit = Const.toLong((String)this.environmentSubstitute(meta.getZipLimitSize()), (long)0L);
            if (data.zipFileLimit > 0L) {
                data.zipFileLimit *= 0x100000L;
            }
            if (!meta.isZipFilenameDynamic()) {
                data.ZipFilename = this.environmentSubstitute(meta.getZipFilename());
            }
            this.processAttachedFiles();
        }
    }

    @VisibleForTesting
    void validateMetaFields(MailMeta meta) throws KettleException {
        if (Utils.isEmpty((CharSequence)meta.getDestination())) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Log.DestinationFieldEmpty", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)meta.getReplyAddress())) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Log.ReplyFieldEmpty", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)meta.getServer())) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Log.ServerFieldEmpty", (String[])new String[0]));
        }
        if (meta.isDynamicFilename() && Utils.isEmpty((CharSequence)meta.getDynamicFieldname())) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Log.DynamicFilenameFielddEmpty", (String[])new String[0]));
        }
        if (meta.isZipFilenameDynamic() && Utils.isEmpty((CharSequence)meta.getDynamicZipFilenameField())) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Log.DynamicZipFilenameFieldEmpty", (String[])new String[0]));
        }
        this.validateZipFiles(meta);
        if (meta.isUsingAuthentication()) {
            if (Utils.isEmpty((CharSequence)meta.getAuthenticationUser())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Log.AuthenticationUserFieldEmpty", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)meta.getAuthenticationPassword())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Log.AuthenticationPasswordFieldEmpty", (String[])new String[0]));
            }
        }
    }

    @VisibleForTesting
    void validateZipFiles(MailMeta meta) throws KettleException {
        if (meta.isZipFiles() && Utils.isEmpty((CharSequence)meta.getZipFilename()) && !meta.isZipFilenameDynamic()) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Log.ZipFilenameEmpty", (String[])new String[0]));
        }
    }

    @VisibleForTesting
    void processAttachedFiles() throws KettleException {
        if (this.meta.isDynamicFilename()) {
            this.cacheSourceFileNameField();
            this.cacheWildCardField();
        } else {
            this.data.realSourceFileFoldername = this.environmentSubstitute(this.meta.getSourceFileFoldername());
            this.data.realSourceWildcard = this.environmentSubstitute(this.meta.getSourceWildcard());
        }
    }

    private void cacheWildCardField() throws KettleException {
        if (!Utils.isEmpty((CharSequence)this.meta.getDynamicWildcard()) && this.data.indexOfSourceWildcard < 0) {
            String realSourceattachedWildcard = this.meta.getDynamicWildcard();
            this.data.indexOfSourceWildcard = this.data.previousRowMeta.indexOfValue(realSourceattachedWildcard);
            if (this.data.indexOfSourceWildcard < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotSourceAttachedWildcard", (String[])new String[]{realSourceattachedWildcard}));
            }
        }
    }

    private void cacheSourceFileNameField() throws KettleException {
        if (this.data.indexOfSourceFilename < 0) {
            String realSourceattachedFilename = this.meta.getDynamicFieldname();
            this.data.indexOfSourceFilename = this.data.previousRowMeta.indexOfValue(realSourceattachedFilename);
            if (this.data.indexOfSourceFilename < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotSourceAttachedFilenameField", (String[])new String[]{realSourceattachedFilename}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMail(Object[] r, String server, int port, String senderAddress, String senderName, String destination, String destinationCc, String destinationBCc, String contactPerson, String contactPhone, String authenticationUser, String authenticationPassword, String mailsubject, String comment, String replyToAddresses) throws Exception {
        String realdestinationBCc;
        int i;
        InternetAddress[] address;
        String email_address;
        String protocol = "smtp";
        if (this.meta.isUsingSecureAuthentication()) {
            if (this.meta.getSecureConnectionType().equals("TLS")) {
                this.data.props.put("mail.smtp.starttls.enable", "true");
            } else {
                protocol = "smtps";
                this.data.props.put("mail.smtps.quitwait", "false");
            }
        }
        this.data.props.put("mail." + protocol + ".host", server);
        if (port != -1) {
            this.data.props.put("mail." + protocol + ".port", "" + port);
        }
        if (this.isDebug()) {
            this.data.props.put("mail.debug", "true");
        }
        if (this.meta.isUsingAuthentication()) {
            this.data.props.put("mail." + protocol + ".auth", "true");
        }
        Session session = Session.getInstance((Properties)this.data.props);
        session.setDebug(this.isDebug());
        MimeMessage msg = new MimeMessage(session);
        if (this.meta.isUsePriority()) {
            String priority_int = "1";
            if (this.meta.getPriority().equals("low")) {
                priority_int = "3";
            }
            if (this.meta.getPriority().equals("normal")) {
                priority_int = "2";
            }
            msg.setHeader("X-Priority", priority_int);
            msg.setHeader("Importance", this.meta.getImportance());
            msg.setHeader("Sensitivity", this.meta.getSensitivity());
        }
        if (!Utils.isEmpty((CharSequence)(email_address = senderAddress))) {
            if (!Utils.isEmpty((CharSequence)senderName)) {
                email_address = senderName + '<' + email_address + '>';
            }
        } else {
            throw new MessagingException(BaseMessages.getString(PKG, (String)"Mail.Error.ReplyEmailNotFilled", (String[])new String[0]));
        }
        msg.setFrom((Address)new InternetAddress(email_address));
        if (!Utils.isEmpty((CharSequence)replyToAddresses)) {
            String[] reply_Address_List = replyToAddresses.split(" ");
            address = new InternetAddress[reply_Address_List.length];
            for (i = 0; i < reply_Address_List.length; ++i) {
                address[i] = new InternetAddress(reply_Address_List[i]);
            }
            msg.setReplyTo((Address[])address);
        }
        String[] destinations = destination.split(" ");
        address = new InternetAddress[destinations.length];
        for (i = 0; i < destinations.length; ++i) {
            address[i] = new InternetAddress(destinations[i]);
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        String realdestinationCc = destinationCc;
        if (!Utils.isEmpty((CharSequence)realdestinationCc)) {
            String[] destinationsCc = realdestinationCc.split(" ");
            InternetAddress[] addressCc = new InternetAddress[destinationsCc.length];
            for (int i2 = 0; i2 < destinationsCc.length; ++i2) {
                addressCc[i2] = new InternetAddress(destinationsCc[i2]);
            }
            msg.setRecipients(Message.RecipientType.CC, (Address[])addressCc);
        }
        if (!Utils.isEmpty((CharSequence)(realdestinationBCc = destinationBCc))) {
            String[] destinationsBCc = realdestinationBCc.split(" ");
            InternetAddress[] addressBCc = new InternetAddress[destinationsBCc.length];
            for (int i3 = 0; i3 < destinationsBCc.length; ++i3) {
                addressBCc[i3] = new InternetAddress(destinationsBCc[i3]);
            }
            msg.setRecipients(Message.RecipientType.BCC, (Address[])addressBCc);
        }
        if (mailsubject != null) {
            msg.setSubject(mailsubject);
        }
        msg.setSentDate(new Date());
        StringBuilder messageText = new StringBuilder();
        if (comment != null) {
            messageText.append(comment).append(Const.CR).append(Const.CR);
        }
        if (this.meta.getIncludeDate()) {
            messageText.append(BaseMessages.getString(PKG, (String)"Mail.Log.Comment.MsgDate", (String[])new String[0]) + ": ").append(XMLHandler.date2string((Date)new Date())).append(Const.CR).append(Const.CR);
        }
        if (!(this.meta.isOnlySendComment() || Utils.isEmpty((CharSequence)contactPerson) && Utils.isEmpty((CharSequence)contactPhone))) {
            messageText.append(BaseMessages.getString(PKG, (String)"Mail.Log.Comment.ContactInfo", (String[])new String[0]) + " :").append(Const.CR);
            messageText.append("---------------------").append(Const.CR);
            messageText.append(BaseMessages.getString(PKG, (String)"Mail.Log.Comment.PersonToContact", (String[])new String[0]) + " : ").append(contactPerson).append(Const.CR);
            messageText.append(BaseMessages.getString(PKG, (String)"Mail.Log.Comment.Tel", (String[])new String[0]) + "  : ").append(contactPhone).append(Const.CR);
            messageText.append(Const.CR);
        }
        this.data.parts = new MimeMultipart();
        MimeBodyPart part1 = new MimeBodyPart();
        if (this.meta.isUseHTML()) {
            if (!Utils.isEmpty((CharSequence)this.meta.getEncoding())) {
                part1.setContent((Object)messageText.toString(), "text/html; charset=" + this.meta.getEncoding());
            } else {
                part1.setContent((Object)messageText.toString(), "text/html; charset=ISO-8859-1");
            }
        } else {
            part1.setText(messageText.toString());
        }
        this.data.parts.addBodyPart((BodyPart)part1);
        if (this.meta.isAttachContentFromField()) {
            this.addAttachedContent(this.data.previousRowMeta.getString(r, this.data.IndexOfAttachedFilename), this.data.previousRowMeta.getString(r, this.data.indexOfAttachedContent));
        } else {
            this.setAttachedFiles(this.meta, r, this.log);
        }
        this.addImagePart();
        if (this.data.nrEmbeddedImages > 0 && this.data.nrattachedFiles == 0) {
            this.data.parts.setSubType("related");
        }
        msg.setContent((Multipart)this.data.parts);
        try (Transport transport = null;){
            transport = session.getTransport(protocol);
            if (this.meta.isUsingAuthentication()) {
                if (port != -1) {
                    transport.connect(Const.NVL((String)server, (String)""), port, Const.NVL((String)authenticationUser, (String)""), Const.NVL((String)authenticationPassword, (String)""));
                } else {
                    transport.connect(Const.NVL((String)server, (String)""), Const.NVL((String)authenticationUser, (String)""), Const.NVL((String)authenticationPassword, (String)""));
                }
            } else {
                transport.connect();
            }
            transport.sendMessage((Message)msg, msg.getAllRecipients());
        }
    }

    @VisibleForTesting
    void setAttachedFiles(MailMeta meta, Object[] r, LogChannelInterface log) throws Exception {
        if (meta.isDynamicFilename() || meta.isZipFilenameDynamic()) {
            this.setAttachedFilesList(r, log);
        } else {
            this.setAttachedFilesList(null, log);
        }
    }

    private void setMailMimeCharsetProperty() {
        if (StringUtils.isBlank((String)System.getProperty(MAIL_CHARSET_KEY))) {
            System.setProperty(MAIL_CHARSET_KEY, MAIL_CHARSET);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setAttachedFilesList(Object[] r, LogChannelInterface log) throws Exception {
        String realSourceFileFoldername = null;
        String realSourceWildcard = null;
        FileObject sourcefile = null;
        FileObject file = null;
        ZipOutputStream zipOutputStream = null;
        File masterZipfile = null;
        if (this.meta.isZipFilenameDynamic()) {
            this.data.ZipFilename = this.data.previousRowMeta.getString(r, this.data.indexOfDynamicZipFilename);
        }
        try {
            if (this.meta.isDynamicFilename()) {
                if (this.data.indexOfSourceFilename > -1) {
                    realSourceFileFoldername = this.data.previousRowMeta.getString(r, this.data.indexOfSourceFilename);
                }
                if (this.data.indexOfSourceWildcard > -1) {
                    realSourceWildcard = this.data.previousRowMeta.getString(r, this.data.indexOfSourceWildcard);
                }
            } else {
                realSourceFileFoldername = this.data.realSourceFileFoldername;
                realSourceWildcard = this.data.realSourceWildcard;
            }
            if (!Utils.isEmpty((CharSequence)realSourceFileFoldername)) {
                sourcefile = KettleVFS.getFileObject((String)realSourceFileFoldername, (VariableSpace)this.getTransMeta());
                if (sourcefile.exists()) {
                    long FileSize = 0L;
                    FileObject[] list = null;
                    list = sourcefile.getType() == FileType.FILE ? new FileObject[]{sourcefile} : sourcefile.findFiles((FileSelector)new TextFileSelector(sourcefile.toString(), realSourceWildcard));
                    if (list.length > 0) {
                        int c;
                        BufferedInputStream inputStream;
                        ZipEntry zipEntry;
                        int i;
                        boolean zipFiles = this.meta.isZipFiles();
                        if (zipFiles && this.data.zipFileLimit == 0L) {
                            masterZipfile = new File(System.getProperty("java.io.tmpdir") + Const.FILE_SEPARATOR + this.data.ZipFilename);
                            zipOutputStream = new ZipOutputStream(new FileOutputStream(masterZipfile));
                        }
                        for (i = 0; i < list.length; ++i) {
                            file = KettleVFS.getFileObject((String)KettleVFS.getFilename((FileObject)list[i]), (VariableSpace)this.getTransMeta());
                            if (zipFiles) {
                                if (this.data.zipFileLimit == 0L) {
                                    zipEntry = new ZipEntry(file.getName().getBaseName());
                                    zipOutputStream.putNextEntry(zipEntry);
                                    inputStream = new BufferedInputStream(file.getContent().getInputStream());
                                    while ((c = inputStream.read()) >= 0) {
                                        zipOutputStream.write(c);
                                    }
                                    inputStream.close();
                                    zipOutputStream.closeEntry();
                                    continue;
                                }
                                FileSize += file.getContent().getSize();
                                continue;
                            }
                            this.addAttachedFilePart(file);
                        }
                        if (zipFiles) {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"Mail.Log.FileSize", (String[])new String[]{"" + FileSize}));
                            }
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"Mail.Log.LimitSize", (String[])new String[]{"" + this.data.zipFileLimit}));
                            }
                            if (this.data.zipFileLimit > 0L && FileSize > this.data.zipFileLimit) {
                                masterZipfile = new File(System.getProperty("java.io.tmpdir") + Const.FILE_SEPARATOR + this.data.ZipFilename);
                                zipOutputStream = new ZipOutputStream(new FileOutputStream(masterZipfile));
                                for (i = 0; i < list.length; ++i) {
                                    file = KettleVFS.getFileObject((String)KettleVFS.getFilename((FileObject)list[i]), (VariableSpace)this.getTransMeta());
                                    zipEntry = new ZipEntry(file.getName().getBaseName());
                                    zipOutputStream.putNextEntry(zipEntry);
                                    inputStream = new BufferedInputStream(file.getContent().getInputStream());
                                    while ((c = inputStream.read()) >= 0) {
                                        zipOutputStream.write(c);
                                    }
                                    inputStream.close();
                                    zipOutputStream.closeEntry();
                                }
                            }
                            if (this.data.zipFileLimit > 0L && FileSize > this.data.zipFileLimit || this.data.zipFileLimit == 0L) {
                                file = KettleVFS.getFileObject((String)masterZipfile.getAbsolutePath(), (VariableSpace)this.getTransMeta());
                                this.addAttachedFilePart(file);
                            }
                        }
                    }
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"Mail.Error.SourceFileFolderNotExists", (String[])new String[]{realSourceFileFoldername}));
                }
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage());
        }
        finally {
            if (sourcefile != null) {
                try {
                    sourcefile.close();
                }
                catch (Exception e) {}
            }
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception e) {}
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.finish();
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    this.logError("Unable to close attachement zip file archive : " + e.toString());
                }
            }
        }
    }

    private void addAttachedFilePart(FileObject file) throws Exception {
        MimeBodyPart files = new MimeBodyPart();
        URLDataSource fds = new URLDataSource(file.getURL());
        files.setDataHandler(new DataHandler((DataSource)fds));
        files.setFileName(file.getName().getBaseName());
        files.addHeader("Content-Transfer-Encoding", "base64");
        this.data.parts.addBodyPart((BodyPart)files);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"Mail.Log.AttachedFile", (String[])new String[]{fds.getName()}));
        }
    }

    private void addAttachedContent(String filename, String fileContent) throws Exception {
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(fileContent.getBytes(), "application/x-any")));
        mbp.setFileName(filename);
        this.data.parts.addBodyPart((BodyPart)mbp);
    }

    private void addImagePart() throws Exception {
        this.data.nrEmbeddedImages = 0;
        if (this.data.embeddedMimePart != null && this.data.embeddedMimePart.size() > 0) {
            for (MimeBodyPart part : this.data.embeddedMimePart) {
                this.data.parts.addBodyPart((BodyPart)part);
                ++this.data.nrEmbeddedImages;
            }
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MailMeta)smi;
        this.data = (MailData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MailMeta)smi;
        this.data = (MailData)sdi;
        if (this.data.embeddedMimePart != null) {
            this.data.embeddedMimePart.clear();
        }
        this.data.parts = null;
        super.dispose(this.meta, this.data);
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;

        public TextFileSelector(String sourcefolderin, String filewildcard) {
            if (!Utils.isEmpty((CharSequence)sourcefolderin)) {
                this.sourceFolder = sourcefolderin;
            }
            if (!Utils.isEmpty((CharSequence)filewildcard)) {
                this.fileWildcard = filewildcard;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            try {
                if (!info.getFile().toString().equals(this.sourceFolder)) {
                    String short_filename = info.getFile().getName().getBaseName();
                    if ((info.getFile().getParent().equals(info.getBaseFolder()) || !info.getFile().getParent().equals(info.getBaseFolder()) && Mail.this.meta.isIncludeSubFolders()) && (info.getFile().getType() == FileType.FILE && this.fileWildcard == null || info.getFile().getType() == FileType.FILE && this.fileWildcard != null && Mail.this.GetFileWildcard(short_filename, this.fileWildcard))) {
                        returncode = true;
                    }
                }
            }
            catch (Exception e) {
                Mail.this.logError(BaseMessages.getString((Class)PKG, (String)"Mail.Error.FindingFiles", (String[])new String[]{info.getFile().toString(), e.getMessage()}));
                returncode = false;
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

