/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.file;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.CompositeFileErrorHandler;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandler;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandlerContentLineNumber;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandlerMissingFiles;
import org.pentaho.di.trans.steps.file.BaseFileField;
import org.pentaho.di.trans.steps.file.BaseFileInputAdditionalField;
import org.pentaho.di.trans.steps.file.BaseFileInputFiles;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputStepData;
import org.pentaho.di.trans.steps.file.BaseFileInputStepUtils;
import org.pentaho.di.trans.steps.file.IBaseFileInputReader;
import org.pentaho.di.trans.steps.file.IBaseFileInputStepControl;

public abstract class BaseFileInputStep<M extends BaseFileInputMeta<?, ?, ?>, D extends BaseFileInputStepData>
extends BaseStep
implements IBaseFileInputStepControl {
    private static Class<?> PKG = BaseFileInputStep.class;
    protected M meta;
    protected D data;

    protected abstract boolean init();

    protected abstract IBaseFileInputReader createReader(M var1, D var2, FileObject var3) throws Exception;

    public BaseFileInputStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        Map resultFiles;
        this.meta = (BaseFileInputMeta)smi;
        this.data = (BaseFileInputStepData)sdi;
        if (!super.init(smi, sdi)) {
            return false;
        }
        if (this.getTransMeta().getNamedClusterEmbedManager() != null) {
            this.getTransMeta().getNamedClusterEmbedManager().passEmbeddedMetastoreKey(this, this.getTransMeta().getEmbeddedMetastoreProviderKey());
        }
        this.initErrorHandling();
        ((BaseFileInputAdditionalField)((BaseFileInputMeta)this.meta).additionalOutputFields).normalize();
        ((BaseFileInputStepData)this.data).files = ((BaseFileInputMeta)this.meta).getFileInputList(this);
        ((BaseFileInputStepData)this.data).currentFileIndex = 0;
        Result previousResult = this.getTrans().getPreviousResult();
        Map map = resultFiles = previousResult != null ? previousResult.getResultFiles() : null;
        if (!(previousResult != null && resultFiles != null && resultFiles.size() != 0 || ((BaseFileInputStepData)this.data).files.nrOfMissingFiles() <= 0 || ((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).acceptingFilenames || ((BaseFileInputMeta)this.meta).errorHandling.errorIgnored)) {
            this.logError(BaseMessages.getString(PKG, (String)"BaseFileInputStep.Log.Error.NoFilesSpecified", (String[])new String[0]));
            return false;
        }
        String clusterSize = this.getVariable("Internal.Cluster.Size");
        if (!Utils.isEmpty((CharSequence)clusterSize) && Integer.valueOf(clusterSize) > 1) {
            String nr = this.getVariable("Internal.Slave.Transformation.Number");
            if (this.log.isDetailed()) {
                this.logDetailed("Running on slave server #" + nr + " : assuming that each slave reads a dedicated part of the same file(s).");
            }
        }
        return this.init();
    }

    protected boolean openNextFile() {
        try {
            if (((BaseFileInputStepData)this.data).currentFileIndex >= ((BaseFileInputStepData)this.data).files.nrOfFiles()) {
                return false;
            }
            ((BaseFileInputStepData)this.data).file = ((BaseFileInputStepData)this.data).files.getFile(((BaseFileInputStepData)this.data).currentFileIndex);
            ((BaseFileInputStepData)this.data).filename = KettleVFS.getFilename((FileObject)((BaseFileInputStepData)this.data).file);
            this.fillFileAdditionalFields(this.data, ((BaseFileInputStepData)this.data).file);
            if (((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).passingThruFields) {
                StringBuilder sb = new StringBuilder();
                sb.append(((BaseFileInputStepData)this.data).currentFileIndex).append("_").append(((BaseFileInputStepData)this.data).file);
                ((BaseFileInputStepData)this.data).currentPassThruFieldsRow = ((BaseFileInputStepData)this.data).passThruFields.get(sb.toString());
            }
            if (((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).isaddresult) {
                ResultFile resultFile = new ResultFile(0, ((BaseFileInputStepData)this.data).file, this.getTransMeta().getName(), this.toString());
                resultFile.setComment("File was read by an Text File input step");
                this.addResultFile(resultFile);
            }
            if (this.log.isBasic()) {
                this.logBasic("Opening file: " + ((BaseFileInputStepData)this.data).file.getName().getFriendlyURI());
            }
            ((BaseFileInputStepData)this.data).dataErrorLineHandler.handleFile(((BaseFileInputStepData)this.data).file);
            ((BaseFileInputStepData)this.data).reader = this.createReader(this.meta, this.data, ((BaseFileInputStepData)this.data).file);
        }
        catch (Exception e) {
            if (!this.handleOpenFileException(e)) {
                return false;
            }
            ((BaseFileInputStepData)this.data).reader = null;
        }
        ++((BaseFileInputStepData)this.data).currentFileIndex;
        return true;
    }

    protected boolean handleOpenFileException(Exception e) {
        String errorMsg = "Couldn't open file #" + ((BaseFileInputStepData)this.data).currentFileIndex + " : " + ((BaseFileInputStepData)this.data).file.getName().getFriendlyURI();
        if (!this.failAfterBadFile(errorMsg)) {
            return true;
        }
        this.stopAll();
        this.setErrors(this.getErrors() + 1L);
        this.logError(errorMsg, e);
        return false;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (BaseFileInputMeta)smi;
        this.data = (BaseFileInputStepData)sdi;
        if (this.first) {
            this.first = false;
            this.prepareToRowProcessing();
            if (!this.openNextFile()) {
                this.setOutputDone();
                this.closeLastFile();
                return false;
            }
        }
        do {
            if (((BaseFileInputStepData)this.data).reader != null && ((BaseFileInputStepData)this.data).reader.readRow()) {
                return true;
            }
            this.closeLastFile();
        } while (this.openNextFile());
        this.setOutputDone();
        this.closeLastFile();
        return false;
    }

    protected void prepareToRowProcessing() throws KettleException {
        ((BaseFileInputStepData)this.data).outputRowMeta = new RowMeta();
        RowMetaInterface[] infoStep = null;
        if (((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).acceptingFilenames) {
            infoStep = this.filesFromPreviousStep();
        }
        ((BaseStepMeta)this.meta).getFields(((BaseFileInputStepData)this.data).outputRowMeta, this.getStepname(), infoStep, null, this, this.repository, this.metaStore);
        ((BaseFileInputStepData)this.data).convertRowMeta = ((BaseFileInputStepData)this.data).outputRowMeta.cloneToType(2);
        BaseFileInputStepUtils.handleMissingFiles(((BaseFileInputStepData)this.data).files, this.log, ((BaseFileInputMeta)this.meta).errorHandling.errorIgnored, ((BaseFileInputStepData)this.data).dataErrorLineHandler);
        for (int i = 0; i < ((BaseFileInputMeta)this.meta).inputFields.length; ++i) {
            if (!((BaseFileField)((BaseFileInputMeta)this.meta).inputFields[i]).isRepeated()) continue;
            ++((BaseFileInputStepData)this.data).nr_repeats;
        }
    }

    @Override
    public boolean checkFeedback(long lines) {
        return super.checkFeedback(lines);
    }

    private void initErrorHandling() {
        ArrayList<FileErrorHandler> dataErrorLineHandlers = new ArrayList<FileErrorHandler>(2);
        if (((BaseFileInputMeta)this.meta).errorHandling.lineNumberFilesDestinationDirectory != null) {
            dataErrorLineHandlers.add(new FileErrorHandlerContentLineNumber(this.getTrans().getCurrentDate(), this.environmentSubstitute(((BaseFileInputMeta)this.meta).errorHandling.lineNumberFilesDestinationDirectory), ((BaseFileInputMeta)this.meta).errorHandling.lineNumberFilesExtension, ((BaseFileInputMeta)this.meta).getEncoding(), this));
        }
        if (((BaseFileInputMeta)this.meta).errorHandling.errorFilesDestinationDirectory != null) {
            dataErrorLineHandlers.add(new FileErrorHandlerMissingFiles(this.getTrans().getCurrentDate(), this.environmentSubstitute(((BaseFileInputMeta)this.meta).errorHandling.errorFilesDestinationDirectory), ((BaseFileInputMeta)this.meta).errorHandling.errorFilesExtension, ((BaseFileInputMeta)this.meta).getEncoding(), this));
        }
        ((BaseFileInputStepData)this.data).dataErrorLineHandler = new CompositeFileErrorHandler(dataErrorLineHandlers);
    }

    private RowMetaInterface[] filesFromPreviousStep() throws KettleException {
        RowMetaInterface[] infoStep = null;
        ((BaseFileInputStepData)this.data).files.getFiles().clear();
        int idx = -1;
        RowSet rowSet = this.findInputRowSet(((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).acceptingStepName);
        Object[] fileRow = this.getRowFrom(rowSet);
        while (fileRow != null) {
            RowMetaInterface prevInfoFields = rowSet.getRowMeta();
            if (idx < 0) {
                if (((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).passingThruFields) {
                    ((BaseFileInputStepData)this.data).passThruFields = new HashMap();
                    infoStep = new RowMetaInterface[]{prevInfoFields};
                    ((BaseFileInputStepData)this.data).nrPassThruFields = prevInfoFields.size();
                }
                if ((idx = prevInfoFields.indexOfValue(((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).acceptingField)) < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"BaseFileInputStep.Log.Error.UnableToFindFilenameField", (String[])new String[]{((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).acceptingField}));
                    this.setErrors(this.getErrors() + 1L);
                    this.stopAll();
                    return null;
                }
            }
            String fileValue = prevInfoFields.getString(fileRow, idx);
            try {
                FileObject parentFileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(fileValue), (VariableSpace)this.getTransMeta());
                boolean isDir = parentFileObject != null && parentFileObject.getType() == FileType.FOLDER;
                int startingIndex = ((BaseFileInputStepData)this.data).files.nrOfFiles();
                if (isDir) {
                    this.addFilesFromFolder(parentFileObject);
                } else {
                    ((BaseFileInputStepData)this.data).files.addFile(parentFileObject);
                }
                if (((BaseFileInputFiles)((BaseFileInputMeta)this.meta).inputFiles).passingThruFields) {
                    StringBuilder sb = new StringBuilder();
                    if (isDir) {
                        for (int fileIndex = startingIndex; fileIndex < ((BaseFileInputStepData)this.data).files.nrOfFiles(); ++fileIndex) {
                            FileObject file = ((BaseFileInputStepData)this.data).files.getFile(fileIndex);
                            sb.setLength(0);
                            sb.append(fileIndex).append("_").append(file != null ? file.toString() : "");
                            ((BaseFileInputStepData)this.data).passThruFields.put(sb.toString(), fileRow);
                        }
                    } else {
                        sb.append(startingIndex).append("_").append(parentFileObject != null ? parentFileObject.toString() : "");
                        ((BaseFileInputStepData)this.data).passThruFields.put(sb.toString(), fileRow);
                    }
                }
            }
            catch (FileSystemException e) {
                this.logError(BaseMessages.getString(PKG, (String)"BaseFileInputStep.Log.Error.UnableToCreateFileObject", (String[])new String[]{fileValue}), e);
                throw new KettleException((Throwable)e);
            }
            fileRow = this.getRowFrom(rowSet);
        }
        if (((BaseFileInputStepData)this.data).files.nrOfFiles() == 0) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"BaseFileInputStep.Log.Error.NoFilesSpecified", (String[])new String[0]));
            }
            return null;
        }
        return infoStep;
    }

    private void addFilesFromFolder(FileObject parentFileObject) throws FileSystemException {
        boolean subdirs = true;
        Object[] fileObjects = parentFileObject.findFiles((FileSelector)new AllFileSelector(){

            public boolean traverseDescendents(FileSelectInfo info) {
                if (info.getDepth() != 0) {
                    // empty if block
                }
                return true;
            }

            public boolean includeFile(FileSelectInfo info) {
                if (info.getDepth() == 0) {
                    return false;
                }
                FileObject fileObject = info.getFile();
                try {
                    return fileObject != null && FileType.FILE.equals((Object)fileObject.getType());
                }
                catch (Exception ex) {
                    return false;
                }
            }
        });
        if (fileObjects != null) {
            for (int j = 0; j < fileObjects.length; ++j) {
                Object fileObject = fileObjects[j];
                if (!fileObject.exists()) continue;
                ((BaseFileInputStepData)this.data).files.addFile((FileObject)fileObject);
            }
        }
        if (Utils.isEmpty((Object[])fileObjects)) {
            ((BaseFileInputStepData)this.data).files.addNonAccessibleFile(parentFileObject);
        }
    }

    protected void closeLastFile() {
        if (((BaseFileInputStepData)this.data).reader != null) {
            try {
                ((BaseFileInputStepData)this.data).reader.close();
            }
            catch (Exception ex) {
                this.failAfterBadFile("Error close reader");
            }
            ((BaseFileInputStepData)this.data).reader = null;
        }
        if (((BaseFileInputStepData)this.data).file != null) {
            try {
                ((BaseFileInputStepData)this.data).file.close();
            }
            catch (Exception ex) {
                this.failAfterBadFile("Error close file");
            }
            ((BaseFileInputStepData)this.data).file = null;
        }
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.closeLastFile();
        super.dispose(smi, sdi);
    }

    @Override
    public boolean failAfterBadFile(String errorMsg) {
        if (this.getStepMeta().isDoingErrorHandling() && ((BaseFileInputStepData)this.data).filename != null && !((BaseFileInputStepData)this.data).rejectedFiles.containsKey(((BaseFileInputStepData)this.data).filename)) {
            ((BaseFileInputStepData)this.data).rejectedFiles.put(((BaseFileInputStepData)this.data).filename, true);
            this.rejectCurrentFile(errorMsg);
        }
        return !((BaseFileInputMeta)this.meta).errorHandling.errorIgnored || !((BaseFileInputMeta)this.meta).errorHandling.skipBadFiles;
    }

    private void rejectCurrentFile(String errorMsg) {
        if (StringUtils.isNotBlank((String)((BaseFileInputMeta)this.meta).errorHandling.fileErrorField) || StringUtils.isNotBlank((String)((BaseFileInputMeta)this.meta).errorHandling.fileErrorMessageField)) {
            RowMetaInterface rowMeta = this.getInputRowMeta();
            if (rowMeta == null) {
                rowMeta = new RowMeta();
            }
            int errorFileIndex = StringUtils.isBlank((String)((BaseFileInputMeta)this.meta).errorHandling.fileErrorField) ? -1 : BaseFileInputStepUtils.addValueMeta(this.getStepname(), rowMeta, this.environmentSubstitute(((BaseFileInputMeta)this.meta).errorHandling.fileErrorField));
            int errorMessageIndex = StringUtils.isBlank((String)((BaseFileInputMeta)this.meta).errorHandling.fileErrorMessageField) ? -1 : BaseFileInputStepUtils.addValueMeta(this.getStepname(), rowMeta, this.environmentSubstitute(((BaseFileInputMeta)this.meta).errorHandling.fileErrorMessageField));
            try {
                Object[] rowData = this.getRow();
                if (rowData == null) {
                    rowData = RowDataUtil.allocateRowData((int)rowMeta.size());
                }
                if (errorFileIndex >= 0) {
                    rowData[errorFileIndex] = ((BaseFileInputStepData)this.data).filename;
                }
                if (errorMessageIndex >= 0) {
                    rowData[errorMessageIndex] = errorMsg;
                }
                this.putError(rowMeta, rowData, this.getErrors(), ((BaseFileInputStepData)this.data).filename, null, "ERROR_CODE");
            }
            catch (Exception e) {
                this.logError("Error sending error row", e);
            }
        }
    }

    protected void fillFileAdditionalFields(D data, FileObject file) throws FileSystemException {
        ((BaseFileInputStepData)data).shortFilename = file.getName().getBaseName();
        ((BaseFileInputStepData)data).path = KettleVFS.getFilename((FileObject)file.getParent());
        ((BaseFileInputStepData)data).hidden = file.isHidden();
        ((BaseFileInputStepData)data).extension = file.getName().getExtension();
        ((BaseFileInputStepData)data).uriName = file.getName().getURI();
        ((BaseFileInputStepData)data).rootUriName = file.getName().getRootURI();
        if (file.getType().hasContent()) {
            ((BaseFileInputStepData)data).lastModificationDateTime = new Date(file.getContent().getLastModifiedTime());
            ((BaseFileInputStepData)data).size = file.getContent().getSize();
        } else {
            ((BaseFileInputStepData)data).lastModificationDateTime = null;
            ((BaseFileInputStepData)data).size = null;
        }
    }
}

