/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.pentaho.di.base.BaseMeta;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.core.AttributesInterface;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.attributes.AttributesUtil;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginLoaderException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceExportInterface;
import org.pentaho.di.resource.ResourceHolderInterface;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.shared.SharedObjectBase;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.RemoteStep;
import org.pentaho.di.trans.step.RowDistributionInterface;
import org.pentaho.di.trans.step.RowDistributionPluginType;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.missing.MissingTrans;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StepMeta
extends SharedObjectBase
implements Cloneable,
Comparable<StepMeta>,
GUIPositionInterface,
SharedObjectInterface,
CheckResultSourceInterface,
ResourceExportInterface,
ResourceHolderInterface,
AttributesInterface,
BaseMeta {
    private static Class<?> PKG = StepMeta.class;
    public static final String XML_TAG = "step";
    public static final String STRING_ID_MAPPING = "Mapping";
    public static final String STRING_ID_SINGLE_THREADER = "SingleThreader";
    public static final String STRING_ID_ETL_META_INJECT = "MetaInject";
    public static final String STRING_ID_JOB_EXECUTOR = "JobExecutor";
    public static final String STRING_ID_MAPPING_INPUT = "MappingInput";
    public static final String STRING_ID_MAPPING_OUTPUT = "MappingOutput";
    private String stepid;
    private String name;
    private StepMetaInterface stepMetaInterface;
    private boolean selected;
    private boolean distributes;
    private boolean isDeprecated;
    private String suggestion;
    private RowDistributionInterface rowDistribution;
    private String copiesString;
    private Point location;
    private boolean drawstep;
    private String description;
    private boolean terminator;
    private StepPartitioningMeta stepPartitioningMeta;
    private StepPartitioningMeta targetStepPartitioningMeta;
    private ClusterSchema clusterSchema;
    private String clusterSchemaName;
    private StepErrorMeta stepErrorMeta;
    private List<RemoteStep> remoteInputSteps;
    private List<RemoteStep> remoteOutputSteps;
    private ObjectId id;
    private TransMeta parentTransMeta;
    private Integer copiesCache;
    protected Map<String, Map<String, String>> attributesMap;

    public StepMeta(String stepid, String stepname, StepMetaInterface stepMetaInterface) {
        this(stepname, stepMetaInterface);
        if (this.stepid == null) {
            this.stepid = stepid;
        }
    }

    public StepMeta(String stepname, StepMetaInterface stepMetaInterface) {
        this.suggestion = "";
        this.copiesCache = null;
        if (stepMetaInterface != null) {
            PluginRegistry registry = PluginRegistry.getInstance();
            this.stepid = registry.getPluginId(StepPluginType.class, (Object)stepMetaInterface);
            this.setDeprecationAndSuggestedStep();
        }
        this.name = stepname;
        this.setStepMetaInterface(stepMetaInterface);
        this.selected = false;
        this.distributes = true;
        this.copiesString = "1";
        this.location = new Point(0, 0);
        this.drawstep = false;
        this.description = null;
        this.stepPartitioningMeta = new StepPartitioningMeta();
        this.clusterSchema = null;
        this.remoteInputSteps = new ArrayList<RemoteStep>();
        this.remoteOutputSteps = new ArrayList<RemoteStep>();
        this.attributesMap = new HashMap<String, Map<String, String>>();
    }

    public StepMeta() {
        this((String)null, (String)null, (StepMetaInterface)null);
    }

    public String getXML() throws KettleException {
        return this.getXML(true);
    }

    public String getXML(boolean includeInterface) throws KettleException {
        StringBuilder retval = new StringBuilder(200);
        retval.append("  ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"name", (String)this.getName()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"type", (String)this.getStepID()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"description", (String)this.description));
        retval.append("    ").append(XMLHandler.addTagValue((String)"distribute", (boolean)this.distributes));
        retval.append("    ").append(XMLHandler.addTagValue((String)"custom_distribution", this.rowDistribution == null ? null : this.rowDistribution.getCode()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"copies", (String)this.copiesString));
        retval.append(this.stepPartitioningMeta.getXML());
        if (this.targetStepPartitioningMeta != null) {
            retval.append(XMLHandler.openTag((String)"target_step_partitioning")).append(this.targetStepPartitioningMeta.getXML()).append(XMLHandler.closeTag((String)"target_step_partitioning"));
        }
        if (includeInterface) {
            retval.append(this.stepMetaInterface.getXML());
        }
        retval.append(AttributesUtil.getAttributesXml(this.attributesMap));
        retval.append("    ").append(XMLHandler.addTagValue((String)"cluster_schema", (String)(this.clusterSchema == null ? "" : this.clusterSchema.getName())));
        retval.append("    ").append(XMLHandler.openTag((String)"remotesteps")).append(Const.CR);
        ArrayList<RemoteStep> inputSteps = new ArrayList<RemoteStep>(this.remoteInputSteps);
        Collections.sort(inputSteps);
        retval.append("      ").append(XMLHandler.openTag((String)"input")).append(Const.CR);
        for (RemoteStep remoteStep : inputSteps) {
            retval.append("      ").append(remoteStep.getXML()).append(Const.CR);
        }
        retval.append("      ").append(XMLHandler.closeTag((String)"input")).append(Const.CR);
        ArrayList<RemoteStep> outputSteps = new ArrayList<RemoteStep>(this.remoteOutputSteps);
        Collections.sort(outputSteps);
        retval.append("      ").append(XMLHandler.openTag((String)"output")).append(Const.CR);
        for (RemoteStep remoteStep : outputSteps) {
            retval.append("      ").append(remoteStep.getXML()).append(Const.CR);
        }
        retval.append("      ").append(XMLHandler.closeTag((String)"output")).append(Const.CR);
        retval.append("    ").append(XMLHandler.closeTag((String)"remotesteps")).append(Const.CR);
        retval.append("    ").append(XMLHandler.openTag((String)"GUI")).append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"xloc", (int)this.location.x));
        retval.append("      ").append(XMLHandler.addTagValue((String)"yloc", (int)this.location.y));
        retval.append("      ").append(XMLHandler.addTagValue((String)"draw", (String)(this.drawstep ? "Y" : "N")));
        retval.append("    ").append(XMLHandler.closeTag((String)"GUI")).append(Const.CR);
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR).append(Const.CR);
        return retval.toString();
    }

    @Deprecated
    public StepMeta(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException, KettlePluginLoaderException {
        this(stepnode, databases, (IMetaStore)null);
    }

    public StepMeta(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException, KettlePluginLoaderException {
        block15: {
            this();
            PluginRegistry registry = PluginRegistry.getInstance();
            try {
                int y;
                int x;
                this.name = XMLHandler.getTagValue((Node)stepnode, (String)"name");
                this.stepid = XMLHandler.getTagValue((Node)stepnode, (String)"type");
                this.setDeprecationAndSuggestedStep();
                PluginInterface sp = registry.findPluginWithId(StepPluginType.class, this.stepid, true);
                if (sp == null) {
                    this.setStepMetaInterface(new MissingTrans(this.name, this.stepid));
                } else {
                    this.setStepMetaInterface((StepMetaInterface)registry.loadClass(sp));
                }
                if (this.stepMetaInterface == null) break block15;
                if (sp != null) {
                    this.stepid = sp.getIds()[0];
                }
                if (this.stepMetaInterface != null) {
                    this.loadXmlCompatibleStepMeta(this.stepMetaInterface, stepnode, databases);
                    this.stepMetaInterface.loadXML(stepnode, databases, metaStore);
                }
                this.description = XMLHandler.getTagValue((Node)stepnode, (String)"description");
                this.copiesString = XMLHandler.getTagValue((Node)stepnode, (String)"copies");
                String sdistri = XMLHandler.getTagValue((Node)stepnode, (String)"distribute");
                this.distributes = "Y".equalsIgnoreCase(sdistri);
                if (sdistri == null) {
                    this.distributes = true;
                }
                this.attributesMap = AttributesUtil.loadAttributes(XMLHandler.getSubNode((Node)stepnode, (String)"attributes"));
                String rowDistributionCode = XMLHandler.getTagValue((Node)stepnode, (String)"custom_distribution");
                this.rowDistribution = (RowDistributionInterface)PluginRegistry.getInstance().loadClass(RowDistributionPluginType.class, rowDistributionCode, RowDistributionInterface.class);
                String xloc = XMLHandler.getTagValue((Node)stepnode, (String)"GUI", (String)"xloc");
                String yloc = XMLHandler.getTagValue((Node)stepnode, (String)"GUI", (String)"yloc");
                try {
                    x = Integer.parseInt(xloc);
                }
                catch (Exception e) {
                    x = 0;
                }
                try {
                    y = Integer.parseInt(yloc);
                }
                catch (Exception e) {
                    y = 0;
                }
                this.location = new Point(x, y);
                this.drawstep = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"GUI", (String)"draw"));
                Node partNode = XMLHandler.getSubNode((Node)stepnode, (String)"partitioning");
                this.stepPartitioningMeta = new StepPartitioningMeta(partNode);
                Node targetPartNode = XMLHandler.getSubNode((Node)stepnode, (String)"target_step_partitioning");
                partNode = XMLHandler.getSubNode((Node)targetPartNode, (String)"partitioning");
                if (partNode != null) {
                    this.targetStepPartitioningMeta = new StepPartitioningMeta(partNode);
                }
                this.clusterSchemaName = XMLHandler.getTagValue((Node)stepnode, (String)"cluster_schema");
                Node remotestepsNode = XMLHandler.getSubNode((Node)stepnode, (String)"remotesteps");
                Node inputNode = XMLHandler.getSubNode((Node)remotestepsNode, (String)"input");
                int nrInput = XMLHandler.countNodes((Node)inputNode, (String)"remotestep");
                for (int i = 0; i < nrInput; ++i) {
                    this.remoteInputSteps.add(new RemoteStep(XMLHandler.getSubNodeByNr((Node)inputNode, (String)"remotestep", (int)i)));
                }
                Node outputNode = XMLHandler.getSubNode((Node)remotestepsNode, (String)"output");
                int nrOutput = XMLHandler.countNodes((Node)outputNode, (String)"remotestep");
                for (int i = 0; i < nrOutput; ++i) {
                    this.remoteOutputSteps.add(new RemoteStep(XMLHandler.getSubNodeByNr((Node)outputNode, (String)"remotestep", (int)i)));
                }
            }
            catch (KettlePluginLoaderException e) {
                throw e;
            }
            catch (Exception e) {
                throw new KettleXMLException(BaseMessages.getString(PKG, (String)"StepMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]) + e.toString(), (Throwable)e);
            }
        }
    }

    private void loadXmlCompatibleStepMeta(StepMetaInterface stepMetaInterface2, Node stepnode, List<DatabaseMeta> databases) throws KettleXMLException {
        this.stepMetaInterface.loadXML(stepnode, databases, new HashMap<String, Counter>());
    }

    public void setClusterSchemaAfterLoading(List<ClusterSchema> clusterSchemas) {
        if (this.clusterSchemaName == null) {
            return;
        }
        for (ClusterSchema look : clusterSchemas) {
            if (!look.getName().equals(this.clusterSchemaName)) continue;
            this.clusterSchema = look;
        }
    }

    public static StepMeta fromXml(String metaXml) {
        try {
            Document doc = XMLHandler.loadXMLString((String)metaXml);
            Node stepNode = XMLHandler.getSubNode((Node)doc, (String)XML_TAG);
            return new StepMeta(stepNode, Collections.emptyList(), (IMetaStore)null);
        }
        catch (KettlePluginLoaderException | KettleXMLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ObjectId getObjectId() {
        return this.id;
    }

    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    public boolean isDrawn() {
        return this.drawstep;
    }

    public boolean isDrawStep() {
        return this.drawstep;
    }

    public void setDraw(boolean draw) {
        this.drawstep = draw;
        this.setChanged();
    }

    public void setCopies(int c) {
        this.setChanged();
        this.copiesString = Integer.toString(c);
        this.copiesCache = c;
    }

    public int getCopies() {
        List<String> partitionIDs;
        if (this.isPartitioned() && this.getStepPartitioningMeta().getPartitionSchema() != null && (partitionIDs = this.getStepPartitioningMeta().getPartitionSchema().getPartitionIDs()) != null && partitionIDs.size() > 0) {
            return partitionIDs.size();
        }
        if (this.copiesCache != null) {
            return this.copiesCache;
        }
        this.copiesCache = this.parentTransMeta != null ? Integer.valueOf(Const.toInt((String)this.parentTransMeta.environmentSubstitute(this.copiesString), (int)-1)) : Integer.valueOf(Const.toInt((String)this.copiesString, (int)1));
        return this.copiesCache;
    }

    public void drawStep() {
        this.setDraw(true);
        this.setChanged();
    }

    public void hideStep() {
        this.setDraw(false);
        this.setChanged();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        StepMeta stepMeta = (StepMeta)obj;
        return this.getName().equalsIgnoreCase(stepMeta.getName());
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    @Override
    public int compareTo(StepMeta o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean hasChanged() {
        StepMetaInterface bsi = this.getStepMetaInterface();
        return bsi != null ? bsi.hasChanged() : false;
    }

    public void setChanged(boolean ch) {
        BaseStepMeta bsi = (BaseStepMeta)((Object)this.getStepMetaInterface());
        if (bsi != null) {
            bsi.setChanged(ch);
        }
    }

    public void setChanged() {
        StepMetaInterface bsi = this.getStepMetaInterface();
        if (bsi != null) {
            bsi.setChanged();
        }
    }

    public boolean chosesTargetSteps() {
        if (this.getStepMetaInterface() != null) {
            List<StreamInterface> targetStreams = this.getStepMetaInterface().getStepIOMeta().getTargetStreams();
            return targetStreams.isEmpty();
        }
        return false;
    }

    public Object clone() {
        StepMeta stepMeta = new StepMeta();
        stepMeta.replaceMeta(this);
        stepMeta.setObjectId(null);
        return stepMeta;
    }

    public void replaceMeta(StepMeta stepMeta) {
        this.stepid = stepMeta.stepid;
        this.name = stepMeta.name;
        if (stepMeta.stepMetaInterface != null) {
            this.setStepMetaInterface((StepMetaInterface)stepMeta.stepMetaInterface.clone());
        } else {
            this.stepMetaInterface = null;
        }
        this.selected = stepMeta.selected;
        this.distributes = stepMeta.distributes;
        this.setRowDistribution(stepMeta.getRowDistribution());
        this.copiesString = stepMeta.copiesString;
        this.copiesCache = null;
        this.location = stepMeta.location != null ? new Point(stepMeta.location.x, stepMeta.location.y) : null;
        this.drawstep = stepMeta.drawstep;
        this.description = stepMeta.description;
        this.terminator = stepMeta.terminator;
        this.stepPartitioningMeta = stepMeta.stepPartitioningMeta != null ? stepMeta.stepPartitioningMeta.clone() : null;
        this.clusterSchema = stepMeta.clusterSchema != null ? stepMeta.clusterSchema.clone() : null;
        this.clusterSchemaName = stepMeta.clusterSchemaName;
        this.remoteInputSteps = new ArrayList<RemoteStep>();
        for (RemoteStep remoteStep : stepMeta.remoteInputSteps) {
            this.remoteInputSteps.add((RemoteStep)remoteStep.clone());
        }
        this.remoteOutputSteps = new ArrayList<RemoteStep>();
        for (RemoteStep remoteStep : stepMeta.remoteOutputSteps) {
            this.remoteOutputSteps.add((RemoteStep)remoteStep.clone());
        }
        if (stepMeta.stepErrorMeta != null) {
            this.stepErrorMeta = stepMeta.stepErrorMeta.clone();
        }
        this.attributesMap = StepMeta.copyStringMap(stepMeta.attributesMap);
        this.id = stepMeta.getObjectId();
        this.setChanged(true);
    }

    private static Map<String, Map<String, String>> copyStringMap(Map<String, Map<String, String>> map) {
        if (map == null) {
            return new HashMap<String, Map<String, String>>();
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(map.size());
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            Map<String, String> value = entry.getValue();
            HashMap<String, String> copy = value == null ? null : new HashMap<String, String>(value);
            result.put(entry.getKey(), copy);
        }
        return result;
    }

    public StepMetaInterface getStepMetaInterface() {
        return this.stepMetaInterface;
    }

    public void setStepMetaInterface(StepMetaInterface stepMetaInterface) {
        this.stepMetaInterface = stepMetaInterface;
        if (stepMetaInterface != null) {
            this.stepMetaInterface.setParentStepMeta(this);
        }
    }

    public String getStepID() {
        return this.stepid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String sname) {
        this.name = sname;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSelected(boolean sel) {
        this.selected = sel;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setTerminator() {
        this.setTerminator(true);
    }

    public void setTerminator(boolean t) {
        this.terminator = t;
    }

    public boolean hasTerminator() {
        return this.terminator;
    }

    public StepMeta(ObjectId id_step) {
        this((String)null, (String)null, (StepMetaInterface)null);
        this.setObjectId(id_step);
    }

    public void setLocation(int x, int y) {
        int ny;
        int nx = x >= 0 ? x : 0;
        Point loc = new Point(nx, ny = y >= 0 ? y : 0);
        if (!loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public void setLocation(Point loc) {
        if (loc != null && !loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    @Override
    public Point getLocation() {
        return this.location;
    }

    @Deprecated
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        this.check(remarks, transMeta, prev, input, output, info, (VariableSpace)new Variables(), null, null);
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        this.stepMetaInterface.check(remarks, transMeta, this, prev, input, output, info);
        this.stepMetaInterface.check(remarks, transMeta, this, prev, input, output, info, space, repository, metaStore);
    }

    public String toString() {
        if (this.getName() == null) {
            return this.getClass().getName();
        }
        return this.getName();
    }

    public boolean isPartitioned() {
        return this.stepPartitioningMeta.isPartitioned();
    }

    public boolean isTargetPartitioned() {
        return this.targetStepPartitioningMeta.isPartitioned();
    }

    public StepPartitioningMeta getStepPartitioningMeta() {
        return this.stepPartitioningMeta;
    }

    public void setStepPartitioningMeta(StepPartitioningMeta stepPartitioningMeta) {
        this.stepPartitioningMeta = stepPartitioningMeta;
    }

    public ClusterSchema getClusterSchema() {
        return this.clusterSchema;
    }

    public void setClusterSchema(ClusterSchema clusterSchema) {
        this.clusterSchema = clusterSchema;
    }

    public boolean isDistributes() {
        return this.distributes;
    }

    public void setDistributes(boolean distributes) {
        if (this.distributes != distributes) {
            this.distributes = distributes;
            this.setChanged();
        }
    }

    public StepErrorMeta getStepErrorMeta() {
        return this.stepErrorMeta;
    }

    public void setStepErrorMeta(StepErrorMeta stepErrorMeta) {
        this.stepErrorMeta = stepErrorMeta;
    }

    public static final StepMeta findStep(List<StepMeta> steps, ObjectId id) {
        if (steps == null) {
            return null;
        }
        for (StepMeta stepMeta : steps) {
            if (stepMeta.getObjectId() == null || !stepMeta.getObjectId().equals(id)) continue;
            return stepMeta;
        }
        return null;
    }

    public static final StepMeta findStep(List<StepMeta> steps, String stepname) {
        if (steps == null) {
            return null;
        }
        for (StepMeta stepMeta : steps) {
            if (!stepMeta.getName().equalsIgnoreCase(stepname)) continue;
            return stepMeta;
        }
        return null;
    }

    public boolean supportsErrorHandling() {
        return this.stepMetaInterface.supportsErrorHandling();
    }

    public boolean isDoingErrorHandling() {
        return this.stepMetaInterface.supportsErrorHandling() && this.stepErrorMeta != null && this.stepErrorMeta.getTargetStep() != null && this.stepErrorMeta.isEnabled();
    }

    public boolean isSendingErrorRowsToStep(StepMeta targetStep) {
        return this.isDoingErrorHandling() && this.stepErrorMeta.getTargetStep().equals(targetStep);
    }

    @Override
    public String getTypeId() {
        return this.getStepID();
    }

    public boolean isMapping() {
        return STRING_ID_MAPPING.equals(this.stepid);
    }

    public boolean isSingleThreader() {
        return STRING_ID_SINGLE_THREADER.equals(this.stepid);
    }

    public boolean isEtlMetaInject() {
        return STRING_ID_ETL_META_INJECT.equals(this.stepid);
    }

    public boolean isJobExecutor() {
        return STRING_ID_JOB_EXECUTOR.equals(this.stepid);
    }

    public boolean isMappingInput() {
        return STRING_ID_MAPPING_INPUT.equals(this.stepid);
    }

    public boolean isMappingOutput() {
        return STRING_ID_MAPPING_OUTPUT.equals(this.stepid);
    }

    public List<ResourceReference> getResourceDependencies(TransMeta transMeta) {
        return this.stepMetaInterface.getResourceDependencies(transMeta, this);
    }

    @Deprecated
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        return this.exportResources(space, definitions, resourceNamingInterface, repository, repository.getMetaStore());
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        String resources = this.stepMetaInterface.exportResources(space, definitions, resourceNamingInterface, repository);
        if (resources != null) {
            return resources;
        }
        return this.stepMetaInterface.exportResources(space, definitions, resourceNamingInterface, repository, metaStore);
    }

    public List<RemoteStep> getRemoteInputSteps() {
        return this.remoteInputSteps;
    }

    public void setRemoteInputSteps(List<RemoteStep> remoteInputSteps) {
        this.remoteInputSteps = remoteInputSteps;
    }

    public List<RemoteStep> getRemoteOutputSteps() {
        return this.remoteOutputSteps;
    }

    public void setRemoteOutputSteps(List<RemoteStep> remoteOutputSteps) {
        this.remoteOutputSteps = remoteOutputSteps;
    }

    public StepPartitioningMeta getTargetStepPartitioningMeta() {
        return this.targetStepPartitioningMeta;
    }

    public void setTargetStepPartitioningMeta(StepPartitioningMeta targetStepPartitioningMeta) {
        this.targetStepPartitioningMeta = targetStepPartitioningMeta;
    }

    public boolean isRepartitioning() {
        if (!this.isPartitioned() && this.isTargetPartitioned()) {
            return true;
        }
        return this.isPartitioned() && this.isTargetPartitioned() && !this.stepPartitioningMeta.equals(this.targetStepPartitioningMeta);
    }

    @Override
    public String getHolderType() {
        return "STEP";
    }

    public boolean isClustered() {
        return this.clusterSchema != null;
    }

    public void setStepID(String stepid) {
        this.stepid = stepid;
    }

    public void setClusterSchemaName(String clusterSchemaName) {
        this.clusterSchemaName = clusterSchemaName;
    }

    public void setParentTransMeta(TransMeta parentTransMeta) {
        this.parentTransMeta = parentTransMeta;
    }

    public TransMeta getParentTransMeta() {
        return this.parentTransMeta;
    }

    public RowDistributionInterface getRowDistribution() {
        return this.rowDistribution;
    }

    public void setRowDistribution(RowDistributionInterface rowDistribution) {
        this.rowDistribution = rowDistribution;
        if (rowDistribution != null) {
            this.setDistributes(true);
        }
        this.setChanged(true);
    }

    public String getCopiesString() {
        return this.copiesString;
    }

    public void setCopiesString(String copiesString) {
        this.copiesString = copiesString;
        this.copiesCache = null;
    }

    public void setAttributesMap(Map<String, Map<String, String>> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public Map<String, Map<String, String>> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttribute(String groupName, String key, String value) {
        Map<String, String> attributes = this.getAttributes(groupName);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
            this.attributesMap.put(groupName, attributes);
        }
        attributes.put(key, value);
    }

    public void setAttributes(String groupName, Map<String, String> attributes) {
        this.attributesMap.put(groupName, attributes);
    }

    public Map<String, String> getAttributes(String groupName) {
        return this.attributesMap.get(groupName);
    }

    public String getAttribute(String groupName, String key) {
        Map<String, String> attributes = this.attributesMap.get(groupName);
        if (attributes == null) {
            return null;
        }
        return attributes.get(key);
    }

    private void setDeprecationAndSuggestedStep() {
        PluginRegistry registry = PluginRegistry.getInstance();
        List deprecatedSteps = registry.getPluginsByCategory(StepPluginType.class, BaseMessages.getString(PKG, (String)"BaseStep.Category.Deprecated", (String[])new String[0]));
        for (PluginInterface p : deprecatedSteps) {
            Object[] ids = p.getIds();
            if (ArrayUtils.isEmpty((Object[])ids) || !((String)ids[0]).equals(this.stepid)) continue;
            this.isDeprecated = true;
            this.suggestion = registry.findPluginWithId(StepPluginType.class, this.stepid) != null ? registry.findPluginWithId(StepPluginType.class, this.stepid).getSuggestion() : "";
            break;
        }
    }

    public boolean isMissing() {
        return this.stepMetaInterface instanceof MissingTrans;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public String getSuggestion() {
        return this.suggestion;
    }
}

