/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepStatus;
import org.pentaho.di.trans.steps.TransStepUtil;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorParameters;

public class SubtransExecutor {
    private static final Class<?> PKG = SubtransExecutor.class;
    private final Map<String, StepStatus> statuses;
    private final String subTransName;
    private Trans parentTrans;
    private TransMeta subtransMeta;
    private boolean shareVariables;
    private TransExecutorParameters parameters;
    private String subStep;
    private boolean stopped;
    Set<Trans> running;
    private Semaphore semaphore;
    private final int prefetchCount;

    public SubtransExecutor(String subTransName, Trans parentTrans, TransMeta subtransMeta, boolean shareVariables, TransExecutorParameters parameters, String subStep, int prefetchCount) {
        this.subTransName = subTransName;
        this.parentTrans = parentTrans;
        this.subtransMeta = subtransMeta;
        this.shareVariables = shareVariables;
        this.parameters = parameters;
        this.subStep = subStep;
        this.statuses = new LinkedHashMap<String, StepStatus>();
        this.running = new ConcurrentHashSet();
        this.prefetchCount = prefetchCount;
        this.semaphore = new Semaphore(prefetchCount);
    }

    public Optional<Result> execute(List<RowMetaAndData> rows) throws KettleException {
        if (rows.isEmpty() || this.stopped) {
            return Optional.empty();
        }
        Trans subtrans = this.createSubtrans();
        this.running.add(subtrans);
        this.parentTrans.addActiveSubTransformation(this.subTransName, subtrans);
        this.passParametersToTrans(subtrans, rows.get(0));
        Result result = new Result();
        result.setRows(rows);
        subtrans.setPreviousResult(result);
        subtrans.prepareExecution(this.parentTrans.getArguments());
        final ArrayList rowMetaAndData = new ArrayList();
        subtrans.getSteps().stream().filter(c -> c.step.getStepname().equalsIgnoreCase(this.subStep)).findFirst().ifPresent(c -> c.step.addRowListener(new RowAdapter(){

            @Override
            public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) {
                rowMetaAndData.add(new RowMetaAndData(rowMeta, row));
            }
        }));
        subtrans.startThreads();
        subtrans.waitUntilFinished();
        this.updateStatuses(subtrans);
        this.running.remove(subtrans);
        Result subtransResult = subtrans.getResult();
        subtransResult.setRows(rowMetaAndData);
        this.releaseBufferPermits(rows.size());
        return Optional.of(subtransResult);
    }

    private synchronized void updateStatuses(Trans subtrans) {
        List<StepMetaDataCombi> steps = subtrans.getSteps();
        for (StepMetaDataCombi combi : steps) {
            StepStatus stepStatus;
            if (this.statuses.containsKey(combi.stepname)) {
                stepStatus = this.statuses.get(combi.stepname);
                stepStatus.updateAll(combi.step);
            } else {
                stepStatus = new StepStatus(combi.step);
                this.statuses.put(combi.stepname, stepStatus);
            }
            stepStatus.setStatusDescription(BaseStepData.StepExecutionStatus.STATUS_RUNNING.getDescription());
        }
    }

    private Trans createSubtrans() {
        Trans subTrans = new Trans(this.subtransMeta, this.parentTrans);
        subTrans.setParentTrans(this.parentTrans);
        subTrans.setRepository(this.parentTrans.getRepository());
        subTrans.setLogLevel(this.parentTrans.getLogLevel());
        subTrans.setArguments(this.parentTrans.getArguments());
        if (this.shareVariables) {
            subTrans.shareVariablesWith(this.parentTrans);
        }
        subTrans.setInternalKettleVariables(this.parentTrans);
        subTrans.copyParametersFrom(this.subtransMeta);
        subTrans.setPreview(this.parentTrans.isPreview());
        TransStepUtil.initServletConfig(this.parentTrans, subTrans);
        return subTrans;
    }

    private void passParametersToTrans(Trans internalTrans, RowMetaAndData rowMetaAndData) throws KettleException {
        internalTrans.clearParameters();
        String[] parameterNames = internalTrans.listParameters();
        for (int i = 0; i < this.parameters.getVariable().length; ++i) {
            String value;
            String variable = this.parameters.getVariable()[i];
            String fieldName = this.parameters.getField()[i];
            String inputValue = this.parameters.getInput()[i];
            if (!Utils.isEmpty((CharSequence)fieldName)) {
                int idx = rowMetaAndData.getRowMeta().indexOfValue(fieldName);
                if (idx < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.Exception.UnableToFindField", (String[])new String[]{fieldName}));
                }
                value = rowMetaAndData.getString(idx, "");
            } else {
                value = this.parentTrans.environmentSubstitute(inputValue);
            }
            if (Const.indexOfString((String)variable, (String[])parameterNames) < 0) {
                internalTrans.setVariable(variable, Const.NVL((String)value, (String)""));
                continue;
            }
            internalTrans.setParameterValue(variable, Const.NVL((String)value, (String)""));
        }
        internalTrans.activateParameters();
    }

    public void stop() {
        this.stopped = true;
        for (Trans trans : this.running) {
            trans.stopAll();
        }
        this.running.clear();
        for (Map.Entry entry : this.statuses.entrySet()) {
            ((StepStatus)entry.getValue()).setStatusDescription(BaseStepData.StepExecutionStatus.STATUS_STOPPED.getDescription());
        }
    }

    public Map<String, StepStatus> getStatuses() {
        return this.statuses;
    }

    public Trans getParentTrans() {
        return this.parentTrans;
    }

    private void releaseBufferPermits(int count) {
        this.semaphore.release(count);
    }

    public void acquireBufferPermit() throws InterruptedException {
        this.semaphore.acquire();
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }
}

