/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.playlist;

import java.io.IOException;
import java.util.Date;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.playlist.FilePlayList;
import org.pentaho.di.core.playlist.FilePlayListReplayErrorFile;
import org.pentaho.di.core.playlist.FilePlayListReplayFile;
import org.pentaho.di.core.playlist.FilePlayListReplayLineNumberFile;
import org.pentaho.di.trans.step.errorhandling.AbstractFileErrorHandler;

public class FilePlayListReplay
implements FilePlayList {
    private final Date replayDate;
    private final String encoding;
    private final String lineNumberDirectory;
    private final String lineNumberExtension;
    private final String errorDirectory;
    private final String errorExtension;
    private FilePlayListReplayFile currentLineNumberFile;
    private FilePlayListReplayFile currentErrorFile;

    public FilePlayListReplay(Date replayDate, String lineNumberDirectory, String lineNumberExtension, String errorDirectory, String errorExtension, String encoding) {
        this.replayDate = replayDate;
        this.errorDirectory = errorDirectory;
        this.errorExtension = errorExtension;
        this.encoding = encoding;
        this.lineNumberDirectory = lineNumberDirectory;
        this.lineNumberExtension = lineNumberExtension;
    }

    private FileObject getCurrentProcessingFile() {
        FileObject result = null;
        if (this.currentLineNumberFile != null) {
            result = this.currentLineNumberFile.getProcessingFile();
        }
        return result;
    }

    private String getCurrentProcessingFilePart() {
        String result = null;
        if (this.currentLineNumberFile != null) {
            result = this.currentLineNumberFile.getProcessingFilePart();
        }
        return result;
    }

    @Override
    public boolean isProcessingNeeded(FileObject file, long lineNr, String filePart) throws KettleException {
        this.initializeCurrentIfNeeded(file, filePart);
        return this.currentLineNumberFile.isProcessingNeeded(file, lineNr, filePart) || this.currentErrorFile.isProcessingNeeded(file, lineNr, filePart);
    }

    private void initializeCurrentIfNeeded(FileObject file, String filePart) throws KettleException {
        if (!file.equals(this.getCurrentProcessingFile()) || !filePart.equals(this.getCurrentProcessingFilePart())) {
            this.initializeCurrent(file, filePart);
        }
    }

    private void initializeCurrent(FileObject file, String filePart) throws KettleException {
        try {
            FileObject lineFile = AbstractFileErrorHandler.getReplayFilename(this.lineNumberDirectory, file.getName().getBaseName(), this.replayDate, this.lineNumberExtension, (Object)filePart);
            this.currentLineNumberFile = lineFile.exists() ? new FilePlayListReplayLineNumberFile(lineFile, this.encoding, file, filePart) : new FilePlayListReplayFile(file, filePart);
            FileObject errorFile = AbstractFileErrorHandler.getReplayFilename(this.errorDirectory, file.getName().getBaseName(), this.replayDate, this.errorExtension, (Object)"NO_PARTS");
            this.currentErrorFile = errorFile.exists() ? new FilePlayListReplayErrorFile(errorFile, file) : new FilePlayListReplayFile(file, "NO_PARTS");
        }
        catch (IOException e) {
            throw new KettleException((Throwable)e);
        }
    }
}

