/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.injection.bean;

import com.google.common.collect.Lists;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.injection.AfterInjection;
import org.pentaho.di.core.injection.InjectionTypeConverter;
import org.pentaho.di.core.injection.bean.BeanInjectionInfo;
import org.pentaho.di.core.injection.bean.BeanLevelInfo;

public class BeanInjector {
    private final BeanInjectionInfo info;

    public BeanInjector(BeanInjectionInfo info) {
        this.info = info;
    }

    public Object getObject(Object root, String propName) throws Exception {
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        if (prop == null) {
            throw new RuntimeException("Property not found");
        }
        BeanLevelInfo beanLevelInfo = prop.path.get(1);
        return beanLevelInfo.field.get(root);
    }

    public Object getPropVal(Object root, String propName) {
        LinkedList beanInfos = Lists.newLinkedList(Optional.ofNullable(this.info.getProperties().get((Object)propName)).orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getPropVal$0(java.lang.String ), ()Ljava/lang/IllegalArgumentException;)((String)propName)).path);
        beanInfos.remove();
        return this.getPropVal(root, propName, beanInfos);
    }

    private Object getPropVal(Object obj, String propName, Queue<BeanLevelInfo> beanInfos) {
        BeanLevelInfo info = beanInfos.remove();
        if (beanInfos.isEmpty()) {
            return this.getObjFromBeanInfo(obj, info);
        }
        obj = this.getObjFromBeanInfo(obj, info);
        switch (info.dim) {
            case LIST: {
                return ((List)Objects.requireNonNull(obj)).stream().map(o -> this.getPropVal(o, propName, Lists.newLinkedList((Iterable)beanInfos))).collect(Collectors.toList());
            }
            case ARRAY: {
                return Arrays.stream((Object[])Objects.requireNonNull(obj)).map(o -> this.getPropVal(o, propName, Lists.newLinkedList((Iterable)beanInfos))).toArray(Object[]::new);
            }
            case NONE: {
                return this.getPropVal(obj, propName, beanInfos);
            }
        }
        throw new IllegalStateException("Unexpected value of BeanLevelInfo.dim " + (Object)((Object)info.dim));
    }

    private Object getObjFromBeanInfo(Object obj, BeanLevelInfo beanLevelInfo) {
        try {
            return beanLevelInfo.field == null ? null : beanLevelInfo.field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getProperty(Object root, String propName) throws Exception {
        ArrayList extractedIndexes = new ArrayList();
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        if (prop == null) {
            throw new RuntimeException("Property not found");
        }
        Object obj = root;
        int arrIndex = 0;
        block4: for (int i = 1; i < prop.path.size(); ++i) {
            BeanLevelInfo s = prop.path.get(i);
            if ((obj = s.field.get(obj)) == null) {
                return null;
            }
            switch (s.dim) {
                case ARRAY: {
                    int indexArray = (Integer)extractedIndexes.get(arrIndex++);
                    if (Array.getLength(obj) <= indexArray) {
                        return null;
                    }
                    if ((obj = Array.get(obj, indexArray)) != null) continue block4;
                    return null;
                }
                case LIST: {
                    int indexList = (Integer)extractedIndexes.get(arrIndex++);
                    List list = (List)obj;
                    if (list.size() <= indexList) {
                        return null;
                    }
                    obj = list.get(indexList);
                    if (obj != null) continue block4;
                    return null;
                }
            }
        }
        return obj;
    }

    public boolean hasProperty(Object root, String propName) {
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        return prop != null;
    }

    public void setProperty(Object root, String propName, List<RowMetaAndData> data, String dataN) throws KettleException {
        String dataValue;
        String dataName;
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        if (prop == null) {
            throw new KettleException("Property '" + propName + "' not found for injection to " + root.getClass());
        }
        if (data != null) {
            dataName = dataN;
            dataValue = null;
        } else {
            dataName = null;
            dataValue = dataN;
        }
        if (prop.pathArraysCount == 0) {
            try {
                this.setProperty(root, prop, 0, data != null ? data.get(0) : null, dataName, dataValue);
            }
            catch (Exception ex) {
                throw new KettleException("Error inject property '" + propName + "' into " + root.getClass(), (Throwable)ex);
            }
        } else if (prop.pathArraysCount == 1) {
            try {
                boolean found;
                if (data != null) {
                    for (int i = 0; i < data.size(); ++i) {
                        this.setProperty(root, prop, i, data.get(i), dataName, dataValue);
                    }
                }
                this.allocateCollectionField(root, this.info, propName);
                int i = 0;
                while (found = this.setProperty(root, prop, i, null, null, dataValue)) {
                    ++i;
                }
            }
            catch (Exception ex) {
                throw new KettleException("Error inject property '" + propName + "' into " + root.getClass(), (Throwable)ex);
            }
        } else if (prop.pathArraysCount > 1) {
            throw new KettleException("Property '" + propName + "' has more than one array in path for injection to " + root.getClass());
        }
    }

    private boolean setProperty(Object root, BeanInjectionInfo.Property prop, int index, RowMetaAndData data, String dataName, String dataValue) throws Exception {
        Object obj = root;
        for (int i = 1; i < prop.path.size(); ++i) {
            Object value;
            List<Object> existList;
            Object existArray;
            BeanLevelInfo s = prop.path.get(i);
            if (i < prop.path.size() - 1) {
                switch (s.dim) {
                    case ARRAY: {
                        Object object = existArray = data != null ? this.extendArray(s, obj, index + 1) : this.checkArray(s, obj, index);
                        if (existArray == null) {
                            return false;
                        }
                        Object next = Array.get(existArray, index);
                        if (next == null) {
                            next = this.createObject(s.leafClass, root);
                            Array.set(existArray, index, next);
                        }
                        obj = next;
                        break;
                    }
                    case LIST: {
                        List<Object> list = existList = data != null ? this.extendList(s, obj, index + 1) : this.checkList(s, obj, index);
                        if (existList == null) {
                            return false;
                        }
                        Object next = existList.get(index);
                        if (next == null) {
                            next = this.createObject(s.leafClass, root);
                            existList.set(index, next);
                        }
                        obj = next;
                        break;
                    }
                    case NONE: {
                        Object next;
                        if (s.field != null) {
                            next = s.field.get(obj);
                            if (next == null) {
                                next = this.createObject(s.leafClass, root);
                                s.field.set(obj, next);
                            }
                            obj = next;
                            break;
                        }
                        if (s.getter != null) {
                            next = s.getter.invoke(obj, new Object[0]);
                            if (next == null) {
                                if (s.setter == null) {
                                    throw new KettleException("No setter defined for " + root.getClass());
                                }
                                next = s.leafClass.newInstance();
                                s.setter.invoke(obj, next);
                            }
                            obj = next;
                            break;
                        }
                        throw new KettleException("No field or getter defined for " + root.getClass());
                    }
                }
                continue;
            }
            if (!s.convertEmpty && (data != null ? data.isEmptyValue(dataName) : dataValue == null)) {
                return true;
            }
            if (s.setter != null) {
                value = data != null ? data.getAsJavaType(dataName, s.leafClass, s.converter) : RowMetaAndData.getStringAsJavaType((String)dataValue, s.leafClass, (InjectionTypeConverter)s.converter);
                s.setter.invoke(obj, value);
                continue;
            }
            if (s.field != null) {
                value = data != null ? data.getAsJavaType(dataName, s.leafClass, s.converter) : RowMetaAndData.getStringAsJavaType((String)dataValue, s.leafClass, (InjectionTypeConverter)s.converter);
                switch (s.dim) {
                    case ARRAY: {
                        Object object = existArray = data != null ? this.extendArray(s, obj, index + 1) : this.checkArray(s, obj, index);
                        if (existArray == null) {
                            return false;
                        }
                        Array.set(existArray, index, value);
                        break;
                    }
                    case LIST: {
                        List<Object> list = existList = data != null ? this.extendList(s, obj, index + 1) : this.checkList(s, obj, index);
                        if (existList == null) {
                            return false;
                        }
                        existList.set(index, value);
                        break;
                    }
                    case NONE: {
                        s.field.set(obj, value);
                    }
                }
                continue;
            }
            throw new KettleException("No field or setter defined for " + root.getClass());
        }
        return true;
    }

    private Object createObject(Class<?> clazz, Object root) throws KettleException {
        try {
            for (Constructor<?> c : clazz.getConstructors()) {
                if (c.getParameterTypes().length == 0) {
                    return clazz.newInstance();
                }
                if (c.getParameterTypes().length != 1 || !c.getParameterTypes()[0].isAssignableFrom(this.info.clazz)) continue;
                return c.newInstance(root);
            }
        }
        catch (Throwable ex) {
            throw new KettleException("Can't create object " + clazz, ex);
        }
        throw new KettleException("Constructor not found for " + clazz);
    }

    private Object extendArray(BeanLevelInfo s, Object obj, int newSize) throws Exception {
        int existSize;
        Object existArray = s.field.get(obj);
        if (existArray == null) {
            existArray = Array.newInstance(s.leafClass, newSize);
            s.field.set(obj, existArray);
        }
        if ((existSize = Array.getLength(existArray)) < newSize) {
            Object newSized = Array.newInstance(s.leafClass, newSize);
            System.arraycopy(existArray, 0, newSized, 0, existSize);
            existArray = newSized;
            s.field.set(obj, existArray);
        }
        return existArray;
    }

    private Object checkArray(BeanLevelInfo s, Object obj, int index) throws Exception {
        Object existArray = s.field.get(obj);
        if (existArray == null) {
            return null;
        }
        int existSize = Array.getLength(existArray);
        return index < existSize ? existArray : null;
    }

    private List<Object> extendList(BeanLevelInfo s, Object obj, int newSize) throws Exception {
        ArrayList<Object> existList = (ArrayList<Object>)s.field.get(obj);
        if (existList == null) {
            existList = new ArrayList<Object>();
            s.field.set(obj, existList);
        }
        while (existList.size() < newSize) {
            existList.add(null);
        }
        return existList;
    }

    private List<Object> checkList(BeanLevelInfo s, Object obj, int index) throws Exception {
        List existList = (List)s.field.get(obj);
        if (existList == null) {
            return null;
        }
        return index < existList.size() ? existList : null;
    }

    void allocateCollectionField(Object object, BeanInjectionInfo beanInjectionInfo, String fieldName) {
        String groupName;
        BeanInjectionInfo.Property property = this.getProperty(beanInjectionInfo, fieldName);
        String string = groupName = property != null ? property.getGroupName() : null;
        if (groupName == null) {
            return;
        }
        List<BeanInjectionInfo.Property> groupProperties = this.getGroupProperties(beanInjectionInfo, groupName);
        Integer maxGroupSize = this.getMaxSize(groupProperties, object);
        if (maxGroupSize == null) {
            return;
        }
        this.allocateCollectionField(property, object, Math.max(1, maxGroupSize));
    }

    void allocateCollectionField(BeanInjectionInfo.Property property, Object obj, int size) {
        BeanLevelInfo beanLevelInfo = this.getFinalPath(property);
        this.allocateCollectionField(beanLevelInfo, obj, size);
    }

    void allocateCollectionField(BeanLevelInfo beanLevelInfo, Object obj, int size) {
        try {
            if (this.isArray(beanLevelInfo)) {
                Object newArray = Array.newInstance(beanLevelInfo.getLeafClass(), size);
                beanLevelInfo.getField().set(obj, newArray);
            } else {
                ArrayList existList = new ArrayList();
                beanLevelInfo.getField().set(obj, existList);
                while (existList.size() < size) {
                    existList.add(null);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isCollection(BeanInjectionInfo.Property property) {
        if (property == null) {
            return false;
        }
        BeanLevelInfo beanLevelInfo = this.getFinalPath(property);
        return beanLevelInfo != null ? Boolean.valueOf(this.isCollection(beanLevelInfo)) : null;
    }

    boolean isCollection(BeanLevelInfo beanLevelInfo) {
        return this.isList(beanLevelInfo) || this.isArray(beanLevelInfo);
    }

    boolean isArray(BeanLevelInfo beanLevelInfo) {
        return beanLevelInfo.getDim() == BeanLevelInfo.DIMENSION.ARRAY;
    }

    boolean isList(BeanLevelInfo beanLevelInfo) {
        return beanLevelInfo.getDim() == BeanLevelInfo.DIMENSION.LIST;
    }

    BeanLevelInfo getFinalPath(BeanInjectionInfo.Property property) {
        return !property.getPath().isEmpty() ? property.getPath().get(property.getPath().size() - 1) : null;
    }

    BeanInjectionInfo.Property getProperty(BeanInjectionInfo beanInjectionInfo, String fieldName) {
        return beanInjectionInfo.getProperties().get(fieldName);
    }

    List<BeanInjectionInfo.Property> getGroupProperties(BeanInjectionInfo beanInjectionInfo, String groupName) {
        BeanInjectionInfo.Group group = beanInjectionInfo.getGroups().stream().filter(g -> g.getName().equals(groupName)).findFirst().orElse(null);
        return group != null ? group.getGroupProperties() : new ArrayList<BeanInjectionInfo.Property>();
    }

    Integer getMaxSize(Collection<BeanInjectionInfo.Property> properties, Object obj) {
        int max = Integer.MIN_VALUE;
        for (BeanInjectionInfo.Property property : properties) {
            max = Math.max(max, this.isCollection(property) ? this.getCollectionSize(property, obj) : 1);
        }
        return max != Integer.MIN_VALUE ? Integer.valueOf(max) : null;
    }

    int getCollectionSize(BeanInjectionInfo.Property property, Object obj) {
        BeanLevelInfo beanLevelInfo = this.getFinalPath(property);
        return this.getCollectionSize(beanLevelInfo, obj);
    }

    int getCollectionSize(BeanLevelInfo beanLevelInfo, Object obj) {
        int size = -1;
        try {
            if (this.isArray(beanLevelInfo)) {
                Object existArray = beanLevelInfo.getField().get(obj);
                size = Array.getLength(existArray);
            } else {
                List existList = (List)beanLevelInfo.getField().get(obj);
                size = existList.size();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    public void runPostInjectionProcessing(Object object) {
        Method[] methods;
        for (Method m : methods = object.getClass().getDeclaredMethods()) {
            AfterInjection annotationAfterInjection = m.getAnnotation(AfterInjection.class);
            if (annotationAfterInjection == null) continue;
            if (m.isSynthetic() || Modifier.isStatic(m.getModifiers())) {
                throw new RuntimeException("Wrong modifier for annotated method " + m);
            }
            try {
                m.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Can not invoke after injection method " + m, e);
            }
        }
    }

    private static /* synthetic */ IllegalArgumentException lambda$getPropVal$0(String propName) {
        return new IllegalArgumentException("Property not found: " + propName);
    }
}

