/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.auth.core.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.pentaho.di.core.auth.core.AuthenticationConsumer;
import org.pentaho.di.core.auth.core.AuthenticationConsumerFactory;
import org.pentaho.di.core.auth.core.AuthenticationFactoryException;
import org.pentaho.di.i18n.BaseMessages;

public class DefaultAuthenticationConsumerFactory
implements AuthenticationConsumerFactory<Object, Object, Object> {
    private static final Class<?> PKG = DefaultAuthenticationConsumerFactory.class;
    private final Constructor<?> constructor;
    private final Class<Object> consumedType;
    private final Class<Object> returnType;
    private final Class<Object> createArgType;

    public DefaultAuthenticationConsumerFactory(Class<?> consumerClass) throws AuthenticationFactoryException {
        Constructor<?>[] constructors = consumerClass.getConstructors();
        if (constructors.length != 1) {
            throw new AuthenticationFactoryException(BaseMessages.getString(PKG, (String)"DefaultAuthenticationConsumerFactory.Constructor", (String[])new String[]{this.getClass().getName(), consumerClass.getCanonicalName()}));
        }
        this.constructor = constructors[0];
        Class<?>[] parameterTypes = this.constructor.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new AuthenticationFactoryException(BaseMessages.getString(PKG, (String)"DefaultAuthenticationConsumerFactory.Constructor.Arg", (String[])new String[]{this.getClass().getName(), consumerClass.getCanonicalName()}));
        }
        Method consumeMethod = null;
        Class consumedType = Object.class;
        for (Method method : consumerClass.getMethods()) {
            Class<?>[] methodParameterTypes;
            if (!"consume".equals(method.getName()) || (methodParameterTypes = method.getParameterTypes()).length != 1 || !consumedType.isAssignableFrom(methodParameterTypes[0])) continue;
            consumeMethod = method;
            consumedType = methodParameterTypes[0];
        }
        if (consumeMethod == null) {
            throw new AuthenticationFactoryException(BaseMessages.getString(PKG, (String)"DefaultAuthenticationConsumerFactory.Consume", (String[])new String[]{consumerClass.getCanonicalName()}));
        }
        this.consumedType = consumeMethod.getParameterTypes()[0];
        this.returnType = consumeMethod.getReturnType();
        this.createArgType = parameterTypes[0];
    }

    @Override
    public Class<Object> getConsumedType() {
        return this.consumedType;
    }

    @Override
    public Class<Object> getReturnType() {
        return this.returnType;
    }

    @Override
    public Class<Object> getCreateArgType() {
        return this.createArgType;
    }

    @Override
    public AuthenticationConsumer<Object, Object> create(Object createArg) {
        try {
            return (AuthenticationConsumer)this.constructor.newInstance(createArg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

