/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class KettleVariablesList {
    private static LogChannelInterface logger;
    private Map<String, String> descriptionMap;
    private Map<String, String> defaultValueMap;

    private KettleVariablesList() {
        logger = new LogChannel((Object)this);
        this.descriptionMap = new HashMap<String, String>();
        this.defaultValueMap = new HashMap<String, String>();
    }

    public static KettleVariablesList getInstance() {
        return KettleVariablesListHelper.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void init() throws KettleException {
        InputStream inputStream = null;
        try {
            KettleVariablesList variablesList = KettleVariablesList.getInstance();
            inputStream = variablesList.getClass().getResourceAsStream("kettle-variables.xml");
            if (inputStream == null) {
                inputStream = variablesList.getClass().getResourceAsStream("/kettle-variables.xml");
            }
            if (inputStream == null) {
                throw new KettlePluginException("Unable to find standard kettle variables definition file: kettle-variables.xml");
            }
            Document doc = XMLHandler.loadXMLFile((InputStream)inputStream, null, (boolean)false, (boolean)false);
            Node varsNode = XMLHandler.getSubNode((Node)doc, (String)"kettle-variables");
            int nrVars = XMLHandler.countNodes((Node)varsNode, (String)"kettle-variable");
            for (int i = 0; i < nrVars; ++i) {
                Node varNode = XMLHandler.getSubNodeByNr((Node)varsNode, (String)"kettle-variable", (int)i);
                String description = XMLHandler.getTagValue((Node)varNode, (String)"description");
                String variable = XMLHandler.getTagValue((Node)varNode, (String)"variable");
                String defaultValue = XMLHandler.getTagValue((Node)varNode, (String)"default-value");
                variablesList.getDescriptionMap().put(variable, description);
                variablesList.getDefaultValueMap().put(variable, defaultValue);
            }
            if (inputStream == null) return;
        }
        catch (Exception e) {
            try {
                throw new KettleException("Unable to read file 'kettle-variables.xml'", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.logDetailed("Unable to close file kettle variables definition file", new Object[]{e2});
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException e) {
            logger.logDetailed("Unable to close file kettle variables definition file", new Object[]{e});
            return;
        }
    }

    public Map<String, String> getDescriptionMap() {
        return this.descriptionMap;
    }

    public Map<String, String> getDefaultValueMap() {
        return this.defaultValueMap;
    }

    private static class KettleVariablesListHelper {
        private static final KettleVariablesList INSTANCE = new KettleVariablesList();

        private KettleVariablesListHelper() {
        }
    }
}

