/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.pentaho.di.core.util.HttpClientManager;
import org.pentaho.di.core.util.Utils;

public class HTTPProtocol {
    private static final String[] requestHeaders = new String[]{"accept", "accept-charset", "cache-control", "content-type"};

    public static String[] getRequestHeaders() {
        return requestHeaders;
    }

    public String get(String urlAsString, String username, String password) throws IOException, AuthenticationException {
        CloseableHttpClient httpClient;
        HttpGet getMethod = new HttpGet(urlAsString);
        if (!Utils.isEmpty((CharSequence)username)) {
            HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
            clientBuilder.setCredentials(username, password);
            httpClient = clientBuilder.build();
        } else {
            httpClient = HttpClientManager.getInstance().createDefaultClient();
        }
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)getMethod);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        StringBuilder bodyBuffer = new StringBuilder();
        if (statusCode != -1) {
            if (statusCode != 401) {
                int c;
                InputStreamReader inputStreamReader = new InputStreamReader(httpResponse.getEntity().getContent());
                while ((c = inputStreamReader.read()) != -1) {
                    bodyBuffer.append((char)c);
                }
                inputStreamReader.close();
            } else {
                throw new AuthenticationException();
            }
        }
        return bodyBuffer.toString();
    }
}

